/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.interfaces.IRSComponentBlock;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.blocks.BlockScarecrow;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.client.render.RenderBipedCitizen;
import com.minecolonies.coremod.colony.buildings.modules.TavernBuildingModule;
import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.VisitorSpawnedEvent;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import com.minecolonies.coremod.colony.interactionhandling.RecruitmentInteraction;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.commands.EntryPoint;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.mobs.EntityMercenary;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesChunkCapabilityProvider;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesWorldCapabilityProvider;
import com.minecolonies.coremod.event.capabilityproviders.MinecoloniesWorldColonyManagerCapabilityProvider;
import com.minecolonies.coremod.items.ItemBannerRallyGuards;
import com.minecolonies.coremod.loot.SupplyLoot;
import com.minecolonies.coremod.network.messages.client.OpenSuggestionWindowMessage;
import com.minecolonies.coremod.network.messages.client.UpdateChunkCapabilityMessage;
import com.minecolonies.coremod.network.messages.client.UpdateChunkRangeCapabilityMessage;
import com.minecolonies.coremod.util.ChunkClientDataHelper;
import com.minecolonies.coremod.util.ChunkDataHelper;
import com.mojang.brigadier.CommandDispatcher;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SilverfishBlock;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class EventHandler {
    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        SupplyLoot.getInstance().addLootToEvent(event);
    }

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        EntryPoint.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onEntityAdded(@NotNull EntityJoinWorldEvent event) {
        ITag mobBlacklist = EntityTypeTags.func_219762_a().func_199910_a(new ResourceLocation("minecolonies", "mob_attack_blacklist"));
        if (!event.getWorld().func_201670_d() && ((Boolean)MineColonies.getConfig().getServer().mobAttackCitizens.get()).booleanValue() && event.getEntity() instanceof IMob && !mobBlacklist.func_230235_a_((Object)event.getEntity().func_200600_R())) {
            ((MobEntity)event.getEntity()).field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)event.getEntity(), EntityCitizen.class, true));
            ((MobEntity)event.getEntity()).field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)event.getEntity(), EntityMercenary.class, true));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onDebugOverlay(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74330_P) {
            ClientWorld world = mc.field_71441_e;
            ClientPlayerEntity player = mc.field_71439_g;
            BlockPos pos = new BlockPos(player.func_213303_ch());
            IColony colony = IColonyManager.getInstance().getIColony((World)world, pos);
            if (colony == null) {
                if (IColonyManager.getInstance().isFarEnoughFromColonies((World)world, pos)) {
                    event.getLeft().add(LanguageHandler.format((String)"com.minecolonies.coremod.gui.debugScreen.noCloseColony", (Object[])new Object[0]));
                    return;
                }
                colony = IColonyManager.getInstance().getClosestIColony((World)world, pos);
                if (colony == null) {
                    return;
                }
                event.getLeft().add(LanguageHandler.format((String)"com.minecolonies.coremod.gui.debugScreen.nextColony", (Object[])new Object[]{(int)Math.sqrt(colony.getDistanceSquared(pos)), IColonyManager.getInstance().getMinimumDistanceBetweenTownHalls()}));
                return;
            }
            event.getLeft().add(colony.getName() + " : " + LanguageHandler.format((String)"com.minecolonies.coremod.gui.debugScreen.blocksFromCenter", (Object[])new Object[]{(int)Math.sqrt(colony.getDistanceSquared(pos))}));
        }
    }

    @SubscribeEvent
    public static void onAttachingCapabilitiesChunk(@NotNull AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(new ResourceLocation("minecolonies", "closecolony"), (ICapabilityProvider)new MinecoloniesChunkCapabilityProvider());
    }

    @SubscribeEvent
    public static void onAttachingCapabilitiesWorld(@NotNull AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("minecolonies", "chunkupdate"), (ICapabilityProvider)new MinecoloniesWorldCapabilityProvider());
        event.addCapability(new ResourceLocation("minecolonies", "colonymanager"), (ICapabilityProvider)new MinecoloniesWorldColonyManagerCapabilityProvider());
    }

    @SubscribeEvent
    public static void onChunkLoad(@NotNull ChunkEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ChunkDataHelper.loadChunk((Chunk)event.getChunk(), (World)((ServerWorld)event.getWorld()));
        } else if (event.getWorld() instanceof ClientWorld && event.getChunk() instanceof Chunk) {
            ChunkClientDataHelper.applyLate((Chunk)event.getChunk());
        }
    }

    @SubscribeEvent
    public static void onChunkUnLoad(ChunkEvent.Unload event) {
        if (event.getWorld() instanceof ServerWorld) {
            ChunkDataHelper.unloadChunk((Chunk)event.getChunk(), (World)((ServerWorld)event.getWorld()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity && !event.isCanceled()) {
            IColony oldColony;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            Chunk oldChunk = player.field_70170_p.func_212866_a_(player.field_70176_ah, player.field_70164_aj);
            IColonyTagCapability oldCloseColonies = oldChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
            if (oldCloseColonies != null && oldCloseColonies.getOwningColony() != 0 && (oldColony = IColonyManager.getInstance().getColonyByWorld(oldCloseColonies.getOwningColony(), player.field_70170_p)) != null) {
                oldColony.removeVisitingPlayer((PlayerEntity)player);
                oldColony.getPackageManager().removeCloseSubscriber(player);
            }
        }
    }

    @SubscribeEvent
    public static void playerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            IColony newColony;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            Chunk newChunk = player.field_70170_p.func_212866_a_(player.field_70176_ah, player.field_70164_aj);
            IColonyTagCapability closeColonyCap = newChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
            if (closeColonyCap != null && (newColony = IColonyManager.getInstance().getColonyByWorld(closeColonyCap.getOwningColony(), player.field_70170_p)) != null) {
                newColony.addVisitingPlayer((PlayerEntity)player);
                newColony.getPackageManager().addCloseSubscriber(player);
            }
        }
    }

    @SubscribeEvent
    public static void onEnteringChunk(@NotNull EntityEvent.EnteringChunk event) {
        Entity entity = event.getEntity();
        BlockPos pos = new BlockPos(entity.func_213303_ch());
        if (event.getOldChunkX() == 0 && event.getOldChunkZ() == 0 && pos.func_177951_i((Vector3i)BlockPos.field_177992_a) > 10000.0) {
            return;
        }
        if (entity instanceof ServerPlayerEntity) {
            IColony newColony;
            IColony oldColony;
            World world = entity.func_130014_f_();
            Chunk newChunk = world.func_212866_a_(event.getNewChunkX(), event.getNewChunkZ());
            ChunkDataHelper.loadChunk(newChunk, entity.field_70170_p);
            Network.getNetwork().sendToPlayer(new UpdateChunkRangeCapabilityMessage(world, event.getNewChunkX(), event.getNewChunkZ(), 8, true), (ServerPlayerEntity)event.getEntity());
            IColonyTagCapability newCloseColonies = newChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
            if (newCloseColonies == null) {
                return;
            }
            Network.getNetwork().sendToPlayer(new UpdateChunkCapabilityMessage(newCloseColonies, newChunk.func_76632_l().field_77276_a, newChunk.func_76632_l().field_77275_b), (ServerPlayerEntity)entity);
            @NotNull ServerPlayerEntity player = (ServerPlayerEntity)entity;
            Chunk oldChunk = world.func_212866_a_(event.getOldChunkX(), event.getOldChunkZ());
            IColonyTagCapability oldCloseColonies = oldChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
            if (oldCloseColonies == null) {
                return;
            }
            if (newCloseColonies.getOwningColony() != oldCloseColonies.getOwningColony() && (oldColony = IColonyManager.getInstance().getColonyByWorld(oldCloseColonies.getOwningColony(), world)) != null) {
                oldColony.removeVisitingPlayer((PlayerEntity)player);
                oldColony.getPackageManager().removeCloseSubscriber(player);
            }
            if (newCloseColonies.getOwningColony() != 0 && (newColony = IColonyManager.getInstance().getColonyByWorld(newCloseColonies.getOwningColony(), world)) != null && !newColony.getPackageManager().getCloseSubscribers().contains(player)) {
                newColony.addVisitingPlayer((PlayerEntity)player);
                newColony.getPackageManager().addCloseSubscriber(player);
            }
            if (newCloseColonies.getOwningColony() != 0) {
                for (Map.Entry<Integer, Set<BlockPos>> entry : newCloseColonies.getAllClaimingBuildings().entrySet()) {
                    IColony newColony2 = IColonyManager.getInstance().getColonyByWorld(entry.getKey(), world);
                    if (newColony2 == null) continue;
                    for (BlockPos buildingPos : entry.getValue()) {
                        IBuilding building = newColony2.getBuildingManager().getBuilding(buildingPos);
                        if (building == null) continue;
                        building.onPlayerEnterNearby((PlayerEntity)player);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void on(LivingSpawnEvent.CheckSpawn event) {
        if (!(event.getEntity() instanceof IMob)) {
            return;
        }
        BlockPos pos = new BlockPos(event.getX(), event.getY(), event.getZ());
        if (event.isSpawner() || event.getWorld().func_201670_d() || !WorldUtil.isEntityBlockLoaded(event.getWorld(), pos)) {
            return;
        }
        IColonyTagCapability closeColonyCap = ((World)event.getWorld()).func_175726_f(pos).getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (closeColonyCap == null || closeColonyCap.getOwningColony() == 0) {
            return;
        }
        IColony newColony = IColonyManager.getInstance().getColonyByWorld(closeColonyCap.getOwningColony(), (World)event.getWorld());
        if (newColony == null) {
            return;
        }
        for (BlockPos buildingPos : closeColonyCap.getAllClaimingBuildings().getOrDefault(closeColonyCap.getOwningColony(), Collections.emptySet())) {
            IBuilding building = newColony.getBuildingManager().getBuilding(buildingPos);
            if (building == null || building.getBuildingLevel() < 1 || !building.isInBuilding(pos)) continue;
            event.setResult(Event.Result.DENY);
            break;
        }
    }

    @SubscribeEvent
    public static void onPlayerEnterWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            IColony colony;
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            for (IColony colony2 : IColonyManager.getInstance().getAllColonies()) {
                if (!colony2.getPermissions().hasPermission((PlayerEntity)player, Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY) && !colony2.getPermissions().hasPermission((PlayerEntity)player, Action.RECEIVE_MESSAGES_FAR_AWAY)) continue;
                colony2.getPackageManager().addImportantColonyPlayer(player);
            }
            Chunk chunk = (Chunk)player.field_70170_p.func_217349_x(new BlockPos(player.func_213303_ch()));
            IColonyTagCapability cap = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
            if (cap != null && cap.getOwningColony() != 0 && (colony = IColonyManager.getInstance().getColonyByDimension(cap.getOwningColony(), (RegistryKey<World>)player.field_70170_p.func_234923_W_())) != null) {
                colony.addVisitingPlayer((PlayerEntity)player);
                colony.getPackageManager().addCloseSubscriber(player);
            }
            int size = player.field_71071_by.func_70302_i_();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof ItemBannerRallyGuards)) continue;
                ItemBannerRallyGuards.broadcastPlayerToRally(stack, (World)player.func_71121_q(), (PlayerEntity)player);
            }
            IGlobalResearchTree.getInstance().sendGlobalResearchTreePackets((ServerPlayerEntity)event.getPlayer());
            CustomRecipeManager.getInstance().sendCustomRecipeManagerPackets((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerLeaveWorld(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                colony.getPackageManager().removeCloseSubscriber(player);
                colony.getPackageManager().removeImportantColonyPlayer(player);
            }
        }
    }

    @SubscribeEvent
    public static void onEnteringChunkEntity(@NotNull EntityEvent.EnteringChunk event) {
        if (((Boolean)MineColonies.getConfig().getServer().pvp_mode.get()).booleanValue() && event.getEntity() instanceof EntityCitizen) {
            IColony colony;
            World world;
            Chunk chunk;
            IColonyTagCapability chunkCapability;
            if (event.getEntity().field_70170_p == null || !WorldUtil.isEntityChunkLoaded((IWorld)event.getEntity().field_70170_p, new ChunkPos(event.getNewChunkX(), event.getNewChunkZ())) || !WorldUtil.isEntityChunkLoaded((IWorld)event.getEntity().field_70170_p, new ChunkPos(event.getOldChunkX(), event.getOldChunkZ()))) {
                return;
            }
            EntityCitizen entityCitizen = (EntityCitizen)event.getEntity();
            if (entityCitizen.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && (chunkCapability = (IColonyTagCapability)(chunk = (world = entityCitizen.func_130014_f_()).func_212866_a_(event.getNewChunkX(), event.getNewChunkZ())).getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null)) != null && chunkCapability.getOwningColony() != 0 && entityCitizen.getCitizenColonyHandler().getColonyId() != chunkCapability.getOwningColony() && (colony = IColonyManager.getInstance().getColonyByWorld(chunkCapability.getOwningColony(), entityCitizen.field_70170_p)) != null) {
                colony.addGuardToAttackers(entityCitizen, ((IGuardBuilding)entityCitizen.getCitizenColonyHandler().getWorkBuilding()).getPlayerToFollowOrRally());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        IColony colony;
        TileEntity spawner;
        if (event.getWorld().func_201670_d() || !(event.getWorld() instanceof World)) {
            return;
        }
        World world = (World)event.getWorld();
        if (event.getState().func_177230_c() instanceof SpawnerBlock && (spawner = event.getWorld().func_175625_s(event.getPos())) instanceof MobSpawnerTileEntity && (colony = IColonyManager.getInstance().getColonyByDimension(((MobSpawnerTileEntity)spawner).func_145881_a().field_98282_f.func_185277_b().func_74762_e("colony"), (RegistryKey<World>)world.func_234923_W_())) != null) {
            colony.getEventManager().onTileEntityBreak(((MobSpawnerTileEntity)spawner).func_145881_a().field_98282_f.func_185277_b().func_74762_e("mc_event_id"), spawner);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(@NotNull PlayerInteractEvent.RightClickBlock event) {
        Block block;
        IColony colony;
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        BlockPos bedBlockPos = event.getPos();
        if (EventHandler.playerRightClickInteract(player, world, event.getPos()) && world.func_180495_p(event.getPos()).func_177230_c() instanceof AbstractBlockHut) {
            IColony colony2 = IColonyManager.getInstance().getIColony(world, event.getPos());
            if (colony2 != null && !colony2.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                event.setCanceled(true);
            }
            return;
        }
        if ("pmardle".equalsIgnoreCase(event.getPlayer().func_200200_C_().getString()) && Block.func_149634_a((Item)event.getItemStack().func_77973_b()) instanceof SilverfishBlock) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)event.getPlayer(), (String)"Stop that you twat!!!", (Object[])new Object[0]);
            event.setCanceled(true);
        }
        if (world.func_180495_p(event.getPos()).func_177230_c().isBed(world.func_180495_p(event.getPos()), (IBlockReader)world, event.getPos(), (Entity)player) && (colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, bedBlockPos)) != null && world.func_180495_p(event.getPos()).func_235901_b_((Property)BedBlock.field_176472_a)) {
            List<ICitizenData> citizenList = colony.getCitizenManager().getCitizens();
            BlockState potentialBed = world.func_180495_p(event.getPos());
            if (potentialBed.func_177230_c() instanceof BedBlock && potentialBed.func_177229_b((Property)BedBlock.field_176472_a) == BedPart.FOOT) {
                bedBlockPos = bedBlockPos.func_177972_a((Direction)world.func_180495_p(event.getPos()).func_177229_b((Property)BedBlock.field_185512_D));
            }
            for (ICitizenData citizen : citizenList) {
                if (!citizen.getBedPos().equals((Object)bedBlockPos) || !citizen.isAsleep()) continue;
                event.setCanceled(true);
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"block.minecraft.bed.occupied", (Object[])new Object[0]);
            }
        }
        EventHandler.handleEventCancellation((PlayerInteractEvent)event, player);
        if (!event.isCanceled() && event.getEntity() instanceof PlayerEntity && event.getItemStack().func_77973_b() instanceof BlockItem && (block = ((BlockItem)event.getItemStack().func_77973_b()).func_179223_d().getBlock()) instanceof AbstractBlockHut && !(block instanceof IRSComponentBlock)) {
            IColony colony3 = IColonyManager.getInstance().getIColony(world, event.getPos());
            if (colony3 != null && !colony3.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                event.setCanceled(true);
                return;
            }
            if (!(!((Boolean)MineColonies.getConfig().getServer().suggestBuildToolPlacement.get()).booleanValue() || player.func_184812_l_() && player.func_225608_bj_())) {
                ItemStack stack = event.getItemStack();
                if (!stack.func_190926_b() && !world.field_72995_K) {
                    Network.getNetwork().sendToPlayer(new OpenSuggestionWindowMessage((BlockState)block.func_176223_P().func_206870_a((Property)AbstractBlockHut.FACING, (Comparable)event.getPlayer().func_174811_aO()), event.getPos().func_177972_a(event.getFace()), stack), (ServerPlayerEntity)player);
                }
                event.setCanceled(true);
            }
            return;
        }
        if (!event.isCanceled() && event.getItemStack().func_77973_b() == ModItems.buildTool.get()) {
            if (event.getWorld().func_201670_d() && event.getUseBlock() == Event.Result.DEFAULT && event.getFace() != null) {
                IColonyView view = IColonyManager.getInstance().getClosestColonyView(event.getWorld(), event.getPos().func_177972_a(event.getFace()));
                if (view != null && Settings.instance.getStyle().isEmpty()) {
                    Settings.instance.setStyle(view.getStyle());
                }
                MineColonies.proxy.openBuildToolWindow(event.getPos().func_177972_a(event.getFace()));
            }
            event.setCanceled(true);
        }
        if (!event.isCanceled() && event.getItemStack().func_77973_b() == ModItems.shapeTool.get()) {
            if (event.getWorld().func_201670_d() && event.getUseBlock() == Event.Result.DEFAULT && event.getFace() != null) {
                MineColonies.proxy.openShapeToolWindow(event.getPos().func_177972_a(event.getFace()));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(@NotNull PlayerInteractEvent.RightClickItem event) {
        if (!event.isCanceled() && event.getItemStack().func_77973_b() == ModItems.buildTool.get() && event.getWorld().field_72995_K) {
            IColonyView view = IColonyManager.getInstance().getClosestColonyView(event.getWorld(), event.getPos());
            if (view != null && Settings.instance.getStyle().isEmpty()) {
                Settings.instance.setStyle(view.getStyle());
            }
            MineColonies.proxy.openBuildToolWindow(null);
            event.setCanceled(true);
        }
        if (!event.isCanceled() && event.getItemStack().func_77973_b() == ModItems.shapeTool.get() && event.getWorld().field_72995_K) {
            MineColonies.proxy.openShapeToolWindow(null);
            event.setCanceled(true);
        }
    }

    private static boolean playerRightClickInteract(@NotNull PlayerEntity player, World world, BlockPos pos) {
        return !player.func_225608_bj_() || player.func_184614_ca() == null || player.func_184614_ca().func_77973_b() == null || player.func_184614_ca().func_77973_b().doesSneakBypassUse(player.func_184614_ca(), (IWorldReader)world, pos, player);
    }

    private static void handleEventCancellation(@NotNull PlayerInteractEvent event, @NotNull PlayerEntity player) {
        Block heldBlock = Block.func_149634_a((Item)event.getItemStack().func_77973_b());
        if (heldBlock instanceof AbstractBlockHut || heldBlock instanceof BlockScarecrow) {
            if (event.getWorld().func_201670_d()) {
                event.setCanceled(((Boolean)MineColonies.getConfig().getServer().suggestBuildToolPlacement.get()).booleanValue());
            } else {
                event.setCanceled(!EventHandler.onBlockHutPlaced(event.getWorld(), player, heldBlock, event.getPos().func_177972_a(event.getFace())));
            }
        }
    }

    public static boolean onBlockHutPlaced(@NotNull World world, @NotNull PlayerEntity player, Block block, BlockPos pos) {
        if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && !WorldUtil.isOverworldType(world)) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.dimension.no", (Object[])new Object[0]);
            return false;
        }
        return EventHandler.onBlockHutPlaced(world, player, pos, block);
    }

    private static boolean onBlockHutPlaced(World world, @NotNull PlayerEntity player, BlockPos pos, Block block) {
        IColony colony = IColonyManager.getInstance().getIColony(world, pos);
        if (colony == null) {
            if (block instanceof BlockHutTownHall) {
                return true;
            }
            if (IColonyManager.getInstance().getIColonyByOwner(world, player) == null) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"tile.blockhut.messagenotownhall", (Object[])new Object[0]);
            } else {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"tile.blockhut.messagetoofarfromtownhall", (Object[])new Object[0]);
            }
            return player.func_184812_l_();
        }
        if (!colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"tile.blockhut.messagenopermission", (Object[])new Object[]{colony.getName()});
            return false;
        }
        return player.func_184812_l_() || colony.getBuildingManager().canPlaceAt(block, pos, player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldLoad(@NotNull WorldEvent.Load event) {
        if (event.getWorld() instanceof World) {
            IColonyManager.getInstance().onWorldLoad((World)event.getWorld());
        }
        if (event.getWorld().func_201670_d() && ((Boolean)MineColonies.getConfig().getServer().holidayFeatures.get()).booleanValue() && (LocalDateTime.now().getDayOfMonth() == 31 && LocalDateTime.now().getMonth() == Month.OCTOBER || LocalDateTime.now().getDayOfMonth() == 1 && LocalDateTime.now().getMonth() == Month.NOVEMBER || LocalDateTime.now().getDayOfMonth() == 2 && LocalDateTime.now().getMonth() == Month.NOVEMBER)) {
            RenderBipedCitizen.isItGhostTime = true;
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(@NotNull WorldEvent.Unload event) {
        if (!event.getWorld().func_201670_d() && event.getWorld() instanceof World) {
            IColonyManager.getInstance().onWorldUnload((World)event.getWorld());
        }
        if (event.getWorld().func_201670_d()) {
            IColonyManager.getInstance().resetColonyViews();
            Log.getLogger().info("Removed all colony views");
        }
    }

    @SubscribeEvent
    public static void onEntityConverted(@NotNull LivingConversionEvent.Pre event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof ZombieVillagerEntity && event.getOutcome() == EntityType.field_200756_av) {
            World world = entity.func_130014_f_();
            IColony colony = IColonyManager.getInstance().getIColony(world, entity.func_233580_cy_());
            if (colony != null && colony.hasBuilding("tavern", 1, false)) {
                event.setCanceled(true);
                if (ForgeEventFactory.canLivingConvert((LivingEntity)entity, ModEntities.VISITOR, null)) {
                    IVisitorData visitorData = (IVisitorData)colony.getVisitorManager().createAndRegisterCivilianData();
                    BlockPos tavernPos = colony.getBuildingManager().getRandomBuilding(b -> !b.getModules(TavernBuildingModule.class).isEmpty());
                    IBuilding tavern = colony.getBuildingManager().getBuilding(tavernPos);
                    visitorData.setHomeBuilding(tavern);
                    visitorData.setBedPos(tavernPos);
                    tavern.getModules(TavernBuildingModule.class).forEach(mod -> mod.getExternalCitizens().add(visitorData.getId()));
                    int recruitLevel = world.field_73012_v.nextInt(10 * tavern.getBuildingLevel()) + 15;
                    List<Tuple<Item, Integer>> recruitCosts = IColonyManager.getInstance().getCompatibilityManager().getRecruitmentCostsWeights();
                    visitorData.getCitizenSkillHandler().init(recruitLevel);
                    colony.getVisitorManager().spawnOrCreateCivilian(visitorData, world, entity.func_233580_cy_(), false);
                    colony.getEventDescriptionManager().addEventDescription(new VisitorSpawnedEvent(entity.func_233580_cy_(), visitorData.getName()));
                    if (visitorData.getEntity().isPresent()) {
                        AbstractEntityCitizen visitorEntity = visitorData.getEntity().get();
                        for (EquipmentSlotType slotType : EquipmentSlotType.values()) {
                            ItemStack itemstack = entity.func_184582_a(slotType);
                            if (slotType.func_188453_a() != EquipmentSlotType.Group.ARMOR || itemstack.func_190926_b()) continue;
                            visitorEntity.func_184201_a(slotType, itemstack);
                        }
                    }
                    if (!entity.func_174814_R()) {
                        world.func_217378_a((PlayerEntity)null, 1027, entity.func_233580_cy_(), 0);
                    }
                    entity.func_70106_y();
                    Tuple<Item, Integer> cost = recruitCosts.get(world.field_73012_v.nextInt(recruitCosts.size()));
                    visitorData.setRecruitCosts(new ItemStack((IItemProvider)cost.getA(), (int)((double)recruitLevel * 3.0 / (double)cost.getB().intValue())));
                    visitorData.triggerInteraction(new RecruitmentInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.chat.recruitstorycured", new Object[]{visitorData.getName().split(" ")[0]}), ChatPriority.IMPORTANT));
                }
            }
        }
    }
}

