/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.minecolonies.api.entity.pathfinding.WaterPathResult;
import com.minecolonies.api.util.Pond;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class PathJobFindWater
extends AbstractPathJob {
    private static final int MIN_DISTANCE = 40;
    private static final int MAX_RANGE = 250;
    private final BlockPos hutLocation;
    @NotNull
    private final ArrayList<Tuple<BlockPos, BlockPos>> ponds;

    public PathJobFindWater(World world, @NotNull BlockPos start, BlockPos home, int range, @NotNull List<Tuple<BlockPos, BlockPos>> ponds, LivingEntity entity) {
        super(world, start, start, range, new WaterPathResult(), entity);
        this.ponds = new ArrayList<Tuple<BlockPos, BlockPos>>(ponds);
        this.hutLocation = home;
    }

    private static double squareDistance(@NotNull BlockPos currentPond, @NotNull BlockPos nextPond) {
        return currentPond.func_177951_i((Vector3i)nextPond);
    }

    @Override
    @NotNull
    public WaterPathResult getResult() {
        return (WaterPathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        int dx = pos.func_177958_n() - this.hutLocation.func_177958_n();
        int dy = pos.func_177956_o() - this.hutLocation.func_177956_o();
        int dz = pos.func_177952_p() - this.hutLocation.func_177952_p();
        return (double)(Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) * 0.501;
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        if (PathJobFindWater.squareDistance(this.hutLocation, n.pos) > 250.0) {
            return false;
        }
        if (this.isWater(n)) {
            this.getResult().parent = n.pos;
            this.getResult().isEmpty = this.ponds.isEmpty();
            return true;
        }
        return false;
    }

    private boolean isWater(@NotNull Node n) {
        if (n.parent == null) {
            return false;
        }
        if (!(this.world.func_180495_p(n.pos).func_177230_c() == Blocks.field_150355_j || this.world.func_175623_d(n.pos) && this.world.func_180495_p(n.pos).func_177230_c() == Blocks.field_150355_j)) {
            if (n.pos.func_177958_n() == n.parent.pos.func_177958_n()) {
                int dz = n.pos.func_177952_p() > n.parent.pos.func_177952_p() ? 1 : -1;
                return Pond.checkWater(this.world, n.pos.func_177982_a(0, -1, dz), this.getResult()) || Pond.checkWater(this.world, n.pos.func_177982_a(-1, -1, 0), this.getResult()) || Pond.checkWater(this.world, n.pos.func_177982_a(1, -1, 0), this.getResult());
            }
            int dx = n.pos.func_177958_n() > n.parent.pos.func_177958_n() ? 1 : -1;
            return Pond.checkWater(this.world, n.pos.func_177982_a(dx, -1, 0), this.getResult()) || Pond.checkWater(this.world, n.pos.func_177982_a(0, -1, -1), this.getResult()) || Pond.checkWater(this.world, n.pos.func_177982_a(0, -1, 1), this.getResult());
        }
        return !this.ponds.contains(new Tuple<BlockPos, BlockPos>(n.pos, n.parent.pos)) && !PathJobFindWater.pondsAreNear(this.ponds, n.pos);
    }

    private static Predicate<BlockPos> generateDistanceFrom(int range, @NotNull BlockPos newPond) {
        return pond -> PathJobFindWater.squareDistance(pond, newPond) < (double)range;
    }

    private static boolean pondsAreNear(@NotNull ArrayList<Tuple<BlockPos, BlockPos>> ponds, @NotNull BlockPos newPond) {
        if (ponds.isEmpty()) {
            return false;
        }
        @NotNull Predicate<BlockPos> compare = PathJobFindWater.generateDistanceFrom(40, newPond);
        return ponds.stream().anyMatch(p -> compare.test((BlockPos)p.getB()));
    }

    @Override
    protected double getNodeResultScore(Node n) {
        return 0.0;
    }
}

