/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.TreePathResult;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.Tree;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class PathJobFindTree
extends AbstractPathJob {
    private static final double TIE_BREAKER = 0.951;
    private static final Vector3i AREA_SHRINK = new Vector3i(-1, 0, -1);
    private final BlockPos hutLocation;
    private final List<ItemStorage> excludedTrees;
    private final IColony colony;
    private final BlockPos boxCenter;
    private final int dyntreesize;

    public PathJobFindTree(World world, @NotNull BlockPos start, BlockPos home, int range, List<ItemStorage> treesToCut, int dyntreesize, IColony colony, LivingEntity entity) {
        super(world, start, start, range, new TreePathResult(), entity);
        this.excludedTrees = treesToCut;
        this.hutLocation = home;
        this.colony = colony;
        this.boxCenter = null;
        this.dyntreesize = dyntreesize;
    }

    public PathJobFindTree(World world, @NotNull BlockPos start, BlockPos home, BlockPos startRestriction, BlockPos endRestriction, BlockPos furthestRestriction, List<ItemStorage> excludedTrees, int dyntreesize, IColony colony, LivingEntity entity) {
        super(world, start, startRestriction, endRestriction, (int)Math.sqrt((double)BlockPosUtil.getDistanceSquared2D(home, furthestRestriction) * 1.5), AREA_SHRINK, false, new TreePathResult(), entity, AbstractAdvancedPathNavigate.RestrictionType.XZ);
        this.excludedTrees = excludedTrees;
        this.hutLocation = home;
        this.colony = colony;
        this.dyntreesize = dyntreesize;
        BlockPos size = startRestriction.func_177973_b((Vector3i)endRestriction);
        this.boxCenter = endRestriction.func_177982_a(size.func_177958_n() / 2, size.func_177956_o() / 2, size.func_177952_p() / 2);
    }

    @Override
    @NotNull
    public TreePathResult getResult() {
        return (TreePathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        return this.boxCenter == null ? pos.func_177951_i((Vector3i)this.hutLocation) * 0.951 : (double)BlockPosUtil.getDistanceSquared2D(pos, this.boxCenter);
    }

    @Override
    protected boolean isAtDestination(@NotNull Node n) {
        return n.parent != null && this.isNearTree(n);
    }

    private boolean isNearTree(@NotNull Node n) {
        if (n.pos.func_177958_n() == n.parent.pos.func_177958_n()) {
            int dz = n.pos.func_177952_p() > n.parent.pos.func_177952_p() ? 1 : -1;
            return this.isTree(n.pos.func_177982_a(0, 0, dz)) || this.isTree(n.pos.func_177982_a(-1, 0, 0)) || this.isTree(n.pos.func_177982_a(1, 0, 0));
        }
        int dx = n.pos.func_177958_n() > n.parent.pos.func_177958_n() ? 1 : -1;
        return this.isTree(n.pos.func_177982_a(dx, 0, 0)) || this.isTree(n.pos.func_177982_a(0, 0, -1)) || this.isTree(n.pos.func_177982_a(0, 0, 1));
    }

    private boolean isTree(BlockPos pos) {
        if (Tree.checkTree(this.world, pos, this.excludedTrees, this.dyntreesize) && Tree.checkIfInColonyAndNotInBuilding(pos, this.colony, this.world)) {
            this.getResult().treeLocation = pos;
            return true;
        }
        return false;
    }

    @Override
    protected double getNodeResultScore(Node n) {
        return 0.0;
    }

    @Override
    protected boolean isPassable(@NotNull BlockState block, BlockPos pos, Node parent) {
        return super.isPassable(block, pos, parent) || block.func_235714_a_((ITag)BlockTags.field_206952_E) && this.isInRestrictedArea(pos) || Compatibility.isDynamicTrunkShell(block.func_177230_c());
    }
}

