/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding;

import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Node
implements Comparable<Node> {
    private static final int HASH_A = 12;
    private static final int HASH_B = 20;
    private static final int HASH_C = 24;
    @NotNull
    public final BlockPos pos;
    private final int hash;
    @Nullable
    public Node parent;
    private int counterAdded;
    private int counterVisited;
    private int steps;
    private double cost;
    private double heuristic;
    private double score;
    private boolean closed = false;
    private boolean ladder = false;
    private boolean swimming = false;
    private boolean isOnRails = false;
    private boolean isCornerNode = false;
    private boolean isReachedByWorker = false;

    public Node(@NotNull BlockPos pos, double heuristic) {
        this(null, pos, 0.0, heuristic, heuristic);
    }

    public Node(@Nullable Node parent, @NotNull BlockPos pos, double cost, double heuristic, double score) {
        this.parent = parent;
        this.pos = pos;
        this.steps = parent == null ? 0 : parent.steps + 1;
        this.cost = cost;
        this.heuristic = heuristic;
        this.score = score;
        this.hash = pos.func_177958_n() ^ (pos.func_177952_p() << 12 | pos.func_177952_p() >> 20) ^ pos.func_177956_o() << 24;
    }

    public Node(PacketBuffer byteBuf) {
        if (byteBuf.readBoolean()) {
            this.parent = new Node(byteBuf.func_179259_c(), 0.0);
        }
        this.pos = byteBuf.func_179259_c();
        this.cost = byteBuf.readDouble();
        this.heuristic = byteBuf.readDouble();
        this.score = byteBuf.readDouble();
        this.hash = this.pos.func_177958_n() ^ (this.pos.func_177952_p() << 12 | this.pos.func_177952_p() >> 20) ^ this.pos.func_177956_o() << 24;
        this.isReachedByWorker = byteBuf.readBoolean();
    }

    public void serializeToBuf(PacketBuffer byteBuf) {
        byteBuf.writeBoolean(this.parent != null);
        if (this.parent != null) {
            byteBuf.func_179255_a(this.parent.pos);
        }
        byteBuf.func_179255_a(this.pos);
        byteBuf.writeDouble(this.cost);
        byteBuf.writeDouble(this.heuristic);
        byteBuf.writeDouble(this.score);
        byteBuf.writeBoolean(this.isReachedByWorker);
    }

    @Override
    public int compareTo(@NotNull Node o) {
        if (this.score < o.score) {
            return -1;
        }
        if (this.score > o.score) {
            return 1;
        }
        if (this.heuristic < o.heuristic) {
            return -1;
        }
        if (this.heuristic > o.heuristic) {
            return 1;
        }
        return this.counterAdded - o.counterAdded;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(@Nullable Object o) {
        if (o != null && o.getClass() == this.getClass()) {
            @Nullable Node other = (Node)o;
            return this.pos.func_177958_n() == other.pos.func_177958_n() && this.pos.func_177956_o() == other.pos.func_177956_o() && this.pos.func_177952_p() == other.pos.func_177952_p();
        }
        return false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isLadder() {
        return this.ladder;
    }

    public boolean isSwimming() {
        return this.swimming;
    }

    public void setClosed() {
        this.closed = true;
    }

    public int getCounterVisited() {
        return this.counterVisited;
    }

    public void setCounterVisited(int counterVisited) {
        this.counterVisited = counterVisited;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setSteps(int steps) {
        this.steps = steps;
    }

    public void setLadder() {
        this.ladder = true;
    }

    public void setSwimming() {
        this.swimming = true;
    }

    public double getHeuristic() {
        return this.heuristic;
    }

    public void setHeuristic(double heuristic) {
        this.heuristic = heuristic;
    }

    public int getCounterAdded() {
        return this.counterAdded;
    }

    public void setCounterAdded(int counterAdded) {
        this.counterAdded = counterAdded;
    }

    public void setOnRails(boolean isOnRails) {
        this.isOnRails = isOnRails;
    }

    public boolean isOnRails() {
        return this.isOnRails;
    }

    public void setReachedByWorker(boolean reached) {
        this.isReachedByWorker = reached;
    }

    public boolean isReachedByWorker() {
        return this.isReachedByWorker;
    }

    public void setCornerNode(boolean isCornerNode) {
        this.isCornerNode = isCornerNode;
    }

    public boolean isCornerNode() {
        return this.isCornerNode;
    }
}

