/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.mobs.aitasks;

import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.combat.CombatAIStates;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.HordeRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipBasedRaiderUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class RaiderWalkAI
implements IStateAI {
    private final AbstractEntityMinecoloniesMob raider;
    private BlockPos targetBlock = null;
    private long nextCampfireTime = 0L;

    public RaiderWalkAI(AbstractEntityMinecoloniesMob raider, ITickRateStateMachine<IState> stateMachine) {
        this.raider = raider;
        stateMachine.addTransition(new TickingTransition<IState>(CombatAIStates.NO_TARGET, this::walk, () -> null, 80));
    }

    private boolean walk() {
        if (this.raider.getColony() != null) {
            IColonyEvent event = this.raider.getColony().getEventManager().getEventByID(this.raider.getEventID());
            if (event == null) {
                return false;
            }
            if (event.getStatus() == EventStatus.PREPARING && event instanceof HordeRaidEvent) {
                this.walkToCampFire();
                return false;
            }
            if (this.targetBlock == null || this.raider.getNavigation().func_75500_f() || this.targetBlock != null && this.raider.func_233580_cy_().func_177951_i((Vector3i)this.targetBlock) < 25.0) {
                this.targetBlock = this.raider.getColony().getRaiderManager().getRandomBuilding();
                BlockPos moveToPos = ShipBasedRaiderUtils.chooseWaypointFor(((IColonyRaidEvent)event).getWayPoints(), this.raider.func_233580_cy_(), this.targetBlock);
                this.raider.getNavigation().moveToXYZ(moveToPos.func_177958_n(), moveToPos.func_177956_o(), moveToPos.func_177952_p(), 1.1);
            }
        }
        return false;
    }

    private void walkToCampFire() {
        if (this.raider.field_70170_p.func_82737_E() - this.nextCampfireTime < 0L) {
            return;
        }
        BlockPos campFire = ((HordeRaidEvent)this.raider.getColony().getEventManager().getEventByID(this.raider.getEventID())).getRandomCampfire();
        if (campFire == null) {
            return;
        }
        this.nextCampfireTime = this.raider.field_70170_p.func_82737_E() + (long)this.raider.field_70170_p.field_73012_v.nextInt(1000);
        this.targetBlock = BlockPosUtil.getRandomPosition(this.raider.field_70170_p, campFire, BlockPos.field_177992_a, 3, 6);
        if (this.targetBlock != null && this.targetBlock != BlockPos.field_177992_a) {
            this.raider.getNavigation().moveToXYZ(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p(), 1.0);
        }
    }
}

