/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Disease;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHospital;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.CircleParticleEffectMessage;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class EntityAISickTask
extends Goal {
    private static final int MIN_DIST_TO_HUT = 5;
    private static final int MIN_DIST_TO_HOSPITAL = 3;
    private static final long MINIMUM_DISTANCE_TO_HOSPITAL = 10L;
    private static final int REQUIRED_TIME_TO_CURE = 60;
    private static final int CHANCE_FOR_RANDOM_CURE = 10;
    private static final int GOING_TO_BED_ATTEMPTS = 20;
    private final ICitizenData citizenData;
    private int waitingTicks = 0;
    private BlockPos usedBed;
    private final EntityCitizen citizen;
    private BlockPos placeToPath;
    private final ITickRateStateMachine<DiseaseState> stateMachine;

    public EntityAISickTask(EntityCitizen citizen) {
        this.citizen = citizen;
        this.citizenData = citizen.getCitizenData();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.stateMachine = new TickRateStateMachine<DiseaseState>(DiseaseState.IDLE, e -> Log.getLogger().warn("Disease AI threw exception:", (Throwable)e));
        this.stateMachine.addTransition(new TickingTransition<DiseaseState>(DiseaseState.IDLE, this::isSick, () -> DiseaseState.CHECK_FOR_CURE, 20));
        this.stateMachine.addTransition(new AIEventTarget<Supplier<DiseaseState>>(AIBlockingEventType.AI_BLOCKING, () -> true, this::setNotWorking, 20));
        this.stateMachine.addTransition(new TickingTransition<DiseaseState>(DiseaseState.CHECK_FOR_CURE, () -> true, this::checkForCure, 20));
        this.stateMachine.addTransition(new TickingTransition<DiseaseState>(DiseaseState.WANDER, () -> true, this::wander, 200));
        this.stateMachine.addTransition(new TickingTransition<DiseaseState>(DiseaseState.CHECK_FOR_CURE, () -> true, this::checkForCure, 20));
        this.stateMachine.addTransition(new TickingTransition<DiseaseState>(DiseaseState.GO_TO_HUT, () -> true, this::goToHut, 20));
        this.stateMachine.addTransition(new TickingTransition<DiseaseState>(DiseaseState.SEARCH_HOSPITAL, () -> true, this::searchHospital, 20));
        this.stateMachine.addTransition(new TickingTransition<DiseaseState>(DiseaseState.GO_TO_HOSPITAL, () -> true, this::goToHospital, 20));
        this.stateMachine.addTransition(new TickingTransition<DiseaseState>(DiseaseState.WAIT_FOR_CURE, () -> true, this::waitForCure, 20));
        this.stateMachine.addTransition(new TickingTransition<DiseaseState>(DiseaseState.APPLY_CURE, () -> true, this::applyCure, 20));
        this.stateMachine.addTransition(new TickingTransition<DiseaseState>(DiseaseState.FIND_EMPTY_BED, () -> true, this::findEmptyBed, 20));
    }

    private DiseaseState setNotWorking() {
        IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
        if (job != null && this.stateMachine.getState() != DiseaseState.IDLE) {
            this.citizenData.setWorking(false);
            this.citizen.func_195064_c(new EffectInstance(Effects.field_76421_d, 600));
        }
        return null;
    }

    private boolean isSick() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.SLEEP && !this.citizen.func_70608_bn()) {
            return false;
        }
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null && !this.citizen.getCitizenJobHandler().getColonyJob().canAIBeInterrupted()) {
            return false;
        }
        return this.citizen.getCitizenDiseaseHandler().isSick() || !(this.citizen.getCitizenJobHandler() instanceof AbstractJobGuard) && (double)this.citizen.func_110143_aJ() < 6.0 && this.citizenData.getSaturation() > 6.0;
    }

    public DiseaseState wander() {
        this.citizen.getNavigation().moveToRandomPos(10.0, 0.6);
        return DiseaseState.CHECK_FOR_CURE;
    }

    public boolean func_75250_a() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.SLEEP) {
            return false;
        }
        this.stateMachine.tick();
        return this.stateMachine.getState() != DiseaseState.IDLE;
    }

    private DiseaseState findEmptyBed() {
        if (this.usedBed == null && this.citizen.getCitizenData() != null) {
            this.usedBed = this.citizen.getCitizenData().getBedPos();
            if (this.citizen.getCitizenData().getBedPos().equals((Object)BlockPos.field_177992_a)) {
                this.usedBed = null;
            }
        }
        BlockPos hospitalPos = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBestBuilding(this.citizen, BuildingHospital.class);
        IColony colony = this.citizen.getCitizenColonyHandler().getColony();
        IBuilding hospital = colony.getBuildingManager().getBuilding(hospitalPos);
        if (hospital instanceof BuildingHospital) {
            if (this.usedBed != null && !((BuildingHospital)hospital).getBedList().contains(this.usedBed)) {
                this.usedBed = null;
            }
            if (this.usedBed == null) {
                Iterator<BlockPos> iterator = ((BuildingHospital)hospital).getBedList().iterator();
                while (iterator.hasNext()) {
                    World world = this.citizen.field_70170_p;
                    BlockPos pos = iterator.next();
                    BlockState state = world.func_180495_p(pos);
                    if (!state.func_177230_c().func_203417_a((ITag)BlockTags.field_219747_F) || ((Boolean)state.func_177229_b((Property)BedBlock.field_176471_b)).booleanValue() || !((BedPart)state.func_177229_b((Property)BedBlock.field_176472_a)).equals((Object)BedPart.HEAD) || !world.func_175623_d(pos.func_177984_a())) continue;
                    this.usedBed = pos;
                    ((BuildingHospital)hospital).registerPatient(this.usedBed, this.citizen.getCivilianID());
                    return DiseaseState.FIND_EMPTY_BED;
                }
                if (this.usedBed == null) {
                    return DiseaseState.WAIT_FOR_CURE;
                }
            }
            if (this.citizen.isWorkerAtSiteWithMove(this.usedBed, 3)) {
                ++this.waitingTicks;
                if (!this.citizen.getCitizenSleepHandler().trySleep(this.usedBed)) {
                    ((BuildingHospital)hospital).registerPatient(this.usedBed, 0);
                    this.citizen.getCitizenData().setBedPos(BlockPos.field_177992_a);
                    this.usedBed = null;
                }
            }
        }
        if (this.waitingTicks > 20) {
            this.waitingTicks = 0;
            return DiseaseState.WAIT_FOR_CURE;
        }
        return DiseaseState.FIND_EMPTY_BED;
    }

    private DiseaseState applyCure() {
        if (this.checkForCure() != DiseaseState.APPLY_CURE) {
            return DiseaseState.CHECK_FOR_CURE;
        }
        List<ItemStack> list = IColonyManager.getInstance().getCompatibilityManager().getDisease(this.citizen.getCitizenDiseaseHandler().getDisease()).getCure();
        this.citizen.func_184611_a(Hand.MAIN_HAND, list.get(this.citizen.func_70681_au().nextInt(list.size())));
        this.citizen.func_184609_a(Hand.MAIN_HAND);
        this.citizen.func_184185_a(SoundEvents.field_187682_dG, 1.0f, (float)SoundUtils.getRandomPentatonic(this.citizen.func_70681_au()));
        Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.citizen.func_213303_ch().func_72441_c(0.0, 2.0, 0.0), ParticleTypes.field_197632_y, this.waitingTicks), (Entity)this.citizen);
        ++this.waitingTicks;
        if (this.waitingTicks < 60) {
            return DiseaseState.APPLY_CURE;
        }
        this.cure();
        return DiseaseState.IDLE;
    }

    private void cure() {
        Disease disease = IColonyManager.getInstance().getCompatibilityManager().getDisease(this.citizen.getCitizenDiseaseHandler().getDisease());
        if (disease != null) {
            for (ItemStack cure : disease.getCure()) {
                int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.citizen, stack -> stack.func_77969_a(cure));
                if (slot == -1) continue;
                this.citizenData.getInventory().extractItem(slot, 1, false);
            }
        }
        if (this.usedBed != null) {
            BlockPos hospitalPos = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBestBuilding(this.citizen, BuildingHospital.class);
            IColony colony = this.citizen.getCitizenColonyHandler().getColony();
            IBuilding hospital = colony.getBuildingManager().getBuilding(hospitalPos);
            ((BuildingHospital)hospital).registerPatient(this.usedBed, 0);
            this.usedBed = null;
            this.citizen.getCitizenData().setBedPos(BlockPos.field_177992_a);
        }
        this.citizen.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        this.citizenData.markDirty();
        this.citizen.getCitizenDiseaseHandler().cure();
        this.citizen.func_70606_j(this.citizen.func_110138_aP());
        this.reset();
    }

    private DiseaseState waitForCure() {
        IBuilding building;
        BlockPos hospital;
        IColony colony = this.citizenData.getColony();
        this.placeToPath = colony.getBuildingManager().getBestBuilding(this.citizen, BuildingHospital.class);
        if (this.placeToPath == null) {
            return DiseaseState.SEARCH_HOSPITAL;
        }
        DiseaseState state = this.checkForCure();
        if (state == DiseaseState.APPLY_CURE) {
            return DiseaseState.APPLY_CURE;
        }
        if (state == DiseaseState.IDLE) {
            this.reset();
            return DiseaseState.IDLE;
        }
        if (this.citizen.func_70681_au().nextInt(10000) < 10) {
            this.cure();
            return DiseaseState.IDLE;
        }
        if (this.citizen.getCitizenSleepHandler().isAsleep() && (hospital = colony.getBuildingManager().getBestBuilding(this.citizen, BuildingHospital.class)) != null && (building = colony.getBuildingManager().getBuilding(hospital)) instanceof BuildingHospital && !((BuildingHospital)building).getBedList().contains(this.citizen.getCitizenSleepHandler().getBedLocation())) {
            this.citizen.getCitizenSleepHandler().onWakeUp();
        }
        if (!this.citizen.getCitizenSleepHandler().isAsleep() && BlockPosUtil.getDistance2D(this.placeToPath, this.citizen.func_233580_cy_()) > 10L) {
            return DiseaseState.GO_TO_HOSPITAL;
        }
        if (!this.citizen.getCitizenSleepHandler().isAsleep()) {
            return DiseaseState.FIND_EMPTY_BED;
        }
        return DiseaseState.WAIT_FOR_CURE;
    }

    private DiseaseState goToHut() {
        IBuilding buildingWorker = this.citizenData.getWorkBuilding();
        if (buildingWorker == null) {
            return DiseaseState.SEARCH_HOSPITAL;
        }
        if (this.citizen.getCitizenSleepHandler().isAsleep() || this.citizen.isWorkerAtSiteWithMove(buildingWorker.getPosition(), 5)) {
            return DiseaseState.SEARCH_HOSPITAL;
        }
        return DiseaseState.GO_TO_HUT;
    }

    private DiseaseState goToHospital() {
        if (this.placeToPath == null) {
            return DiseaseState.SEARCH_HOSPITAL;
        }
        if (this.citizen.getCitizenSleepHandler().isAsleep() || this.citizen.getNavigation().func_75500_f() && this.citizen.isWorkerAtSiteWithMove(this.placeToPath, 3)) {
            return DiseaseState.WAIT_FOR_CURE;
        }
        return DiseaseState.SEARCH_HOSPITAL;
    }

    private DiseaseState searchHospital() {
        IColony colony = this.citizenData.getColony();
        this.placeToPath = colony.getBuildingManager().getBestBuilding(this.citizen, BuildingHospital.class);
        if (this.placeToPath == null) {
            String id = this.citizen.getCitizenDiseaseHandler().getDisease();
            if (id.isEmpty()) {
                return DiseaseState.IDLE;
            }
            Disease disease = IColonyManager.getInstance().getCompatibilityManager().getDisease(id);
            this.citizenData.triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.nohospital", new Object[]{disease.getName(), disease.getCureString()}), (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.nohospital"), ChatPriority.BLOCKING));
            return DiseaseState.WANDER;
        }
        if (!this.citizen.getCitizenDiseaseHandler().getDisease().isEmpty()) {
            Disease disease = IColonyManager.getInstance().getCompatibilityManager().getDisease(this.citizen.getCitizenDiseaseHandler().getDisease());
            this.citizenData.triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.waitingforcure", new Object[]{disease.getName(), disease.getCureString()}), (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.waitingforcure"), ChatPriority.BLOCKING));
        }
        return DiseaseState.GO_TO_HOSPITAL;
    }

    private DiseaseState checkForCure() {
        String id = this.citizen.getCitizenDiseaseHandler().getDisease();
        if (id.isEmpty()) {
            if ((double)this.citizen.func_110143_aJ() > 6.0) {
                this.reset();
                return DiseaseState.IDLE;
            }
            return DiseaseState.GO_TO_HUT;
        }
        Disease disease = IColonyManager.getInstance().getCompatibilityManager().getDisease(id);
        for (ItemStack cure : disease.getCure()) {
            int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.citizen, stack -> stack.func_77969_a(cure));
            if (slot != -1) continue;
            if (this.citizen.getCitizenDiseaseHandler().isSick()) {
                return DiseaseState.GO_TO_HUT;
            }
            this.reset();
            return DiseaseState.IDLE;
        }
        return DiseaseState.APPLY_CURE;
    }

    private void reset() {
        this.waitingTicks = 0;
        this.citizen.func_184597_cx();
        this.citizen.func_184602_cy();
        this.citizen.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        this.placeToPath = null;
    }

    public void func_75251_c() {
        this.reset();
        this.stateMachine.reset();
        this.citizen.getCitizenData().setVisibleStatus(null);
    }

    public void func_75249_e() {
        this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.SICK);
    }

    public static enum DiseaseState implements IState
    {
        IDLE,
        CHECK_FOR_CURE,
        GO_TO_HUT,
        SEARCH_HOSPITAL,
        GO_TO_HOSPITAL,
        WAIT_FOR_CURE,
        FIND_EMPTY_BED,
        APPLY_CURE,
        WANDER;

    }
}

