/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class EntityAIInteractToggleAble
extends Goal {
    private static final int DEFAULT_HEIGHT_TO_CHECK = 2;
    private static final int LENGTH_TO_CHECK = 2;
    private static final double MIN_DISTANCE = 4.0;
    private static final double MAX_DISTANCE = 6.25;
    public static final ToggleAble FENCE_TOGGLE = new FenceToggle();
    public static final ToggleAble TRAP_TOGGLE = new TrapToggle();
    public static final ToggleAble DOOR_TOGGLE = new DoorToggle();
    protected MobEntity entity;
    private Map<BlockPos, Boolean> toggleAblePositions = new HashMap<BlockPos, Boolean>();
    private final List<ToggleAble> toggleAbles;
    private int updateTimer = 10;
    private int executeTimerSlow = 100;
    private final int offSet;

    public EntityAIInteractToggleAble(@NotNull MobEntity entityIn, ToggleAble ... toggleAbles) {
        this.entity = entityIn;
        this.toggleAbles = Arrays.asList(toggleAbles);
        if (!(entityIn.func_70661_as() instanceof GroundPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for EntityAIInteractToggleAble");
        }
        this.offSet = entityIn.field_70170_p.field_73012_v.nextInt(20);
    }

    public boolean func_75250_a() {
        if (this.entity.field_70123_F || this.entity.field_70124_G && !this.entity.func_233570_aj_()) {
            return this.checkPath();
        }
        if (this.executeTimerSlow-- <= 0) {
            this.executeTimerSlow = 50;
            return this.checkPathBlocksBelow();
        }
        return false;
    }

    private boolean checkPath() {
        @NotNull GroundPathNavigator pathnavigateground = (GroundPathNavigator)this.entity.func_70661_as();
        Path path = pathnavigateground.func_75505_d();
        this.checkPathBlocksCollided(path);
        return !this.toggleAblePositions.isEmpty();
    }

    private void checkPathBlocksCollided(Path path) {
        if (path == null || path.func_75879_b()) {
            this.resetAll();
            return;
        }
        int maxLengthToCheck = Math.min(path.func_75873_e() + 2, path.func_75874_d());
        for (int i = Math.max(0, path.func_75873_e() - 1); i < maxLengthToCheck; ++i) {
            if (i == path.func_75874_d() - 1) {
                return;
            }
            PathPoint current = path.func_75877_a(i);
            PathPoint next = path.func_75877_a(i + 1);
            if (next.field_75839_a == current.field_75839_a && next.field_75837_b == current.field_75837_b && next.field_75838_c == current.field_75838_c) continue;
            Direction dir = current.field_75839_a == next.field_75839_a && current.field_75838_c == next.field_75838_c ? Direction.EAST : Direction.func_176737_a((float)(next.field_75839_a - current.field_75839_a), (float)0.0f, (float)(next.field_75838_c - current.field_75838_c));
            for (int level = 0; level < this.getHeightToCheck(path, i); ++level) {
                this.checkPosAndAdd((Entity)this.entity, dir, new BlockPos(current.field_75839_a, current.field_75837_b + level, current.field_75838_c));
                this.checkPosAndAdd((Entity)this.entity, dir, new BlockPos(next.field_75839_a, next.field_75837_b + level, next.field_75838_c));
            }
        }
    }

    private void checkPosAndAdd(Entity entity, Direction dir, BlockPos pos) {
        VoxelShape collisionShape;
        if (this.toggleAblePositions.containsKey(pos)) {
            return;
        }
        BlockState state = entity.field_70170_p.func_180495_p(pos);
        if (this.entity.func_70092_e((double)pos.func_177958_n(), this.entity.func_226278_cu_(), (double)pos.func_177952_p()) <= 4.0 && this.isValidBlockState(state) && (collisionShape = state.func_196952_d((IBlockReader)entity.field_70170_p, pos)).func_197762_b((dir = dir.func_176746_e()).func_176740_k()) + 0.1 < (double)entity.func_213311_cf() && collisionShape.func_197758_c(dir.func_176740_k()) + 0.1 + (double)entity.func_213311_cf() > 1.0) {
            this.toggleAblePositions.put(pos, (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208193_t));
        }
    }

    private boolean checkPathBlocksBelow() {
        @NotNull GroundPathNavigator pathnavigateground = (GroundPathNavigator)this.entity.func_70661_as();
        Path path = pathnavigateground.func_75505_d();
        if (path == null || path.func_75879_b()) {
            this.resetAll();
            return false;
        }
        int maxLengthToCheck = Math.min(path.func_75873_e() + 2, path.func_75874_d());
        for (int i = Math.max(0, path.func_75873_e() - 1); i < maxLengthToCheck; ++i) {
            PathPoint pathpoint = path.func_75877_a(i);
            for (int level = 0; level < this.getHeightToCheck(path, i); ++level) {
                BlockPos pos = new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b + level, pathpoint.field_75838_c);
                if (!this.entity.func_233580_cy_().equals((Object)pos) && !this.entity.func_233580_cy_().func_177977_b().equals((Object)pos)) continue;
                BlockState state = this.entity.field_70170_p.func_180495_p(pos);
                if (!(this.entity.func_70092_e((double)pos.func_177958_n(), this.entity.func_226278_cu_(), (double)pos.func_177952_p()) <= 4.0) || !this.isValidBlockState(state)) continue;
                if (level > 0) {
                    this.toggleAblePositions.put(pos, (Boolean)this.entity.field_70170_p.func_180495_p(pos).func_177229_b((Property)BlockStateProperties.field_208193_t));
                    continue;
                }
                if (i >= path.func_75874_d() - 1) continue;
                PathPoint nextPoint = path.func_75877_a(i + 1);
                if (pos.func_177958_n() != nextPoint.field_75839_a || pos.func_177956_o() <= nextPoint.field_75837_b || pos.func_177952_p() != nextPoint.field_75838_c) continue;
                this.toggleAblePositions.put(pos, (Boolean)this.entity.field_70170_p.func_180495_p(pos).func_177229_b((Property)BlockStateProperties.field_208193_t));
            }
        }
        return !this.toggleAblePositions.isEmpty();
    }

    private int getHeightToCheck(Path path, int index) {
        if (path == null || index < 0 || index >= path.func_75874_d()) {
            return 2;
        }
        PathPoint current = path.func_75877_a(index);
        int prevDist = 0;
        if (index > 0) {
            PathPoint prev = path.func_75877_a(index - 1);
            prevDist = prev.field_75837_b - current.field_75837_b;
        }
        int nextDist = 0;
        if (index + 1 < path.func_75874_d()) {
            PathPoint next = path.func_75877_a(index + 1);
            nextDist = next.field_75837_b - current.field_75837_b;
        }
        return Math.max(2, 2 + Math.max(prevDist, nextDist));
    }

    public boolean func_75253_b() {
        return !this.toggleAblePositions.isEmpty();
    }

    private void resetAll() {
        block0: for (BlockPos pos : this.toggleAblePositions.keySet()) {
            for (ToggleAble toggleAble : this.toggleAbles) {
                BlockState state;
                if (!toggleAble.isBlockToggleAble(state = this.entity.field_70170_p.func_180495_p(pos))) continue;
                toggleAble.toggleBlockClosed(state, this.entity.field_70170_p, pos);
                continue block0;
            }
        }
        this.toggleAblePositions.clear();
    }

    private boolean isValidBlockState(BlockState state) {
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        for (ToggleAble toggleAble : this.toggleAbles) {
            if (!toggleAble.isBlockToggleAble(state) || !state.func_235901_b_((Property)BlockStateProperties.field_208193_t)) continue;
            return true;
        }
        return false;
    }

    public void func_75246_d() {
        BlockState state;
        if (--this.updateTimer >= 0) {
            return;
        }
        this.updateTimer = 20 + this.offSet;
        if (!this.checkPath()) {
            return;
        }
        Iterator<BlockPos> it = this.toggleAblePositions.keySet().iterator();
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        block0: while (it.hasNext()) {
            BlockPos pos = it.next();
            state = this.entity.field_70170_p.func_180495_p(pos);
            if (!this.isValidBlockState(state)) {
                it.remove();
                continue;
            }
            if (this.entity.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > 6.25) {
                it.remove();
                BlockState blockState = this.entity.field_70170_p.func_180495_p(pos);
                for (ToggleAble toggleAble : this.toggleAbles) {
                    if (!toggleAble.isBlockToggleAble(blockState)) continue;
                    toggleAble.toggleBlockClosed(blockState, this.entity.field_70170_p, pos);
                    continue block0;
                }
                continue;
            }
            posList.add(pos);
        }
        if (!posList.isEmpty()) {
            BlockPos chosen = (BlockPos)posList.get(this.entity.field_70170_p.field_73012_v.nextInt(posList.size()));
            state = this.entity.field_70170_p.func_180495_p(chosen);
            for (ToggleAble toggleAble : this.toggleAbles) {
                if (!toggleAble.isBlockToggleAble(state)) continue;
                toggleAble.toggleBlock(state, this.entity.field_70170_p, chosen);
                break;
            }
        }
    }

    private static class DoorToggle
    extends ToggleAble {
        private DoorToggle() {
        }

        @Override
        public boolean isBlockToggleAble(BlockState state) {
            return state.func_177230_c() instanceof DoorBlock;
        }

        @Override
        public void toggleBlock(BlockState state, World world, BlockPos pos) {
            if (state.func_177230_c().getClass() == DoorBlock.class) {
                boolean isOpening = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208193_t) == false;
                WorldUtil.setBlockState((IWorld)world, pos, (BlockState)state.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(isOpening)), 10);
                BlockPos otherPos = state.func_177229_b((Property)BlockStateProperties.field_208163_P) == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
                BlockState otherState = world.func_180495_p(otherPos);
                if (otherState.func_177230_c().getClass() == DoorBlock.class) {
                    WorldUtil.setBlockState((IWorld)world, otherPos, (BlockState)otherState.func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(isOpening)), 10);
                }
                ((DoorBlock)state.func_177230_c()).func_196426_b(world, pos, isOpening);
            } else {
                ((DoorBlock)state.func_177230_c()).func_242663_a(world, state, pos, (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208193_t) == false);
            }
        }

        @Override
        public void toggleBlockClosed(BlockState state, World world, BlockPos pos) {
            ((DoorBlock)state.func_177230_c()).func_242663_a(world, state, pos, false);
        }
    }

    private static class TrapToggle
    extends ToggleAble {
        private TrapToggle() {
        }

        @Override
        public boolean isBlockToggleAble(BlockState state) {
            return state.func_177230_c() instanceof TrapDoorBlock;
        }

        @Override
        public void toggleBlock(BlockState state, World world, BlockPos pos) {
            WorldUtil.setBlockState((IWorld)world, pos, (BlockState)state.func_235896_a_((Property)BlockStateProperties.field_208193_t));
        }

        @Override
        public void toggleBlockClosed(BlockState state, World world, BlockPos pos) {
            WorldUtil.setBlockState((IWorld)world, pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208193_t, (Comparable)Boolean.valueOf(false)));
        }
    }

    private static class FenceToggle
    extends ToggleAble {
        private FenceToggle() {
        }

        @Override
        public boolean isBlockToggleAble(BlockState state) {
            return state.func_177230_c() instanceof FenceGateBlock;
        }

        @Override
        public void toggleBlock(BlockState state, World world, BlockPos pos) {
            WorldUtil.setBlockState((IWorld)world, pos, (BlockState)state.func_235896_a_((Property)BlockStateProperties.field_208193_t));
        }

        @Override
        public void toggleBlockClosed(BlockState state, World world, BlockPos pos) {
            WorldUtil.setBlockState((IWorld)world, pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208193_t, (Comparable)Boolean.valueOf(false)));
        }
    }

    public static abstract class ToggleAble {
        public abstract boolean isBlockToggleAble(BlockState var1);

        public abstract void toggleBlock(BlockState var1, World var2, BlockPos var3);

        public abstract void toggleBlockClosed(BlockState var1, World var2, BlockPos var3);
    }
}

