/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.combat;

import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.combat.CombatAIStates;
import com.minecolonies.api.entity.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.combat.threat.ThreatTableEntry;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.coremod.entity.ai.combat.TargetAI;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3i;

public class AttackMoveAI<T extends MobEntity>
extends TargetAI<T> {
    private static final long STOP_PERSECUTION_AFTER = 1200L;
    private PathResult targetPath = null;
    protected long nextAttackTime = 0L;
    private int pathAttempts = 0;

    public AttackMoveAI(T owner, ITickRateStateMachine stateMachine) {
        super(owner, 80, stateMachine);
        stateMachine.addTransition(new TickingTransition<IState>(CombatAIStates.ATTACKING, () -> true, this::tryAttack, 5));
        stateMachine.addTransition(new TickingTransition<IState>(CombatAIStates.ATTACKING, () -> true, this::move, 10));
    }

    private IState move() {
        if (!this.checkForTarget()) {
            return CombatAIStates.NO_TARGET;
        }
        ThreatTableEntry nextTarget = ((IThreatTableEntity)((MobEntity)this.user)).getThreatTable().getTarget();
        if (nextTarget == null) {
            return CombatAIStates.NO_TARGET;
        }
        boolean canSeeTarget = ((MobEntity)this.user).func_70635_at().func_75522_a((Entity)this.target);
        if (canSeeTarget) {
            nextTarget.setLastSeen(((MobEntity)this.user).field_70170_p.func_82737_E());
        } else if (((MobEntity)this.user).field_70170_p.func_82737_E() - nextTarget.getLastSeen() > 1200L) {
            this.resetTarget();
            return null;
        }
        if (!this.isInAttackDistance(this.target) || !canSeeTarget) {
            ((MobEntity)this.user).func_70625_a((Entity)this.target, 180.0f, 180.0f);
            ((MobEntity)this.user).func_70671_ap().func_75651_a((Entity)this.target, 180.0f, 180.0f);
            if (this.pathAttempts > 5 || this.targetPath != null && this.targetPath.isDone() && this.targetPath.failedToReachDestination()) {
                this.pathAttempts = 0;
                this.targetPath = null;
                ((IThreatTableEntity)((MobEntity)this.user)).getThreatTable().addThreat(this.target, -1);
                if (nextTarget.getThreat() < 5) {
                    this.resetTarget();
                    return null;
                }
            }
            if (this.targetPath == null || ((MobEntity)this.user).func_70661_as().func_75500_f() || this.targetPath.isDone() && this.targetPath.hasPath() && this.targetPath.getPath().func_224770_k().func_177951_i((Vector3i)this.target.func_233580_cy_()) > Math.pow(this.getAttackDistance(), 2.0) - 1.0) {
                this.targetPath = this.moveInAttackPosition(this.target);
                ++this.pathAttempts;
            }
        }
        return null;
    }

    @Override
    public void resetTarget() {
        super.resetTarget();
        this.targetPath = null;
        this.pathAttempts = 0;
    }

    protected boolean isInAttackDistance(LivingEntity target) {
        return (double)((MobEntity)this.user).func_70032_d((Entity)target) <= this.getAttackDistance();
    }

    protected IState tryAttack() {
        if (!this.checkForTarget() || !this.canAttack()) {
            return CombatAIStates.NO_TARGET;
        }
        if (this.nextAttackTime >= ((MobEntity)this.user).field_70170_p.func_82737_E() || !this.isInDistanceForAttack(this.target)) {
            return null;
        }
        if (((MobEntity)this.user).func_70635_at().func_75522_a((Entity)this.target)) {
            this.pathAttempts = 0;
            ((MobEntity)this.user).func_70625_a((Entity)this.target, 180.0f, 180.0f);
            this.doAttack(this.target);
            this.nextAttackTime = ((MobEntity)this.user).field_70170_p.func_82737_E() + (long)this.getAttackDelay();
        }
        return null;
    }

    public boolean canAttack() {
        return true;
    }

    protected boolean isInDistanceForAttack(LivingEntity target) {
        return this.isInAttackDistance(target);
    }

    protected void doAttack(LivingEntity target) {
        target.func_70097_a((DamageSource)new EntityDamageSource("Default", (Entity)this.user), 5.0f);
        ((MobEntity)this.user).func_184609_a(Hand.MAIN_HAND);
    }

    protected double getAttackDistance() {
        return 5.0;
    }

    protected int getAttackDelay() {
        return 40;
    }

    protected PathResult moveInAttackPosition(LivingEntity target) {
        return ((AbstractAdvancedPathNavigate)((MobEntity)this.user).func_70661_as()).moveToLivingEntity((Entity)target, 1.0);
    }
}

