/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.trainingcamps;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCombatAcademy;
import com.minecolonies.coremod.colony.jobs.JobCombatTraining;
import com.minecolonies.coremod.entity.ai.citizen.trainingcamps.AbstractEntityAITraining;
import com.minecolonies.coremod.util.NamedDamageSource;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAICombatTraining
extends AbstractEntityAITraining<JobCombatTraining, BuildingCombatAcademy> {
    private static final int ACTIONS_PER_BUILDING_LEVEL = 5;
    private static final double XP_BASE_RATE = 2.0;
    private static final int PARTNER_TRAINING_CHANCE = 25;
    private static final int TRAININGS_DELAY = 60;
    private static final int MIN_DISTANCE_TO_TRAIN = 5;
    private BlockPos currentCombatTarget;
    private AbstractEntityCitizen trainingPartner;
    private int targetCounter;

    public EntityAICombatTraining(@NotNull JobCombatTraining job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.COMBAT_TRAINING, this::decideOnTrainingType, 20), new AITarget((IAIState)AIWorkerState.FIND_TRAINING_PARTNER, this::findTrainingPartner, 20), new AITarget((IAIState)AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER, this::trainWithPartner, 20), new AITarget((IAIState)AIWorkerState.FIND_DUMMY_PARTNER, this::findDummyPartner, 20), new AITarget((IAIState)AIWorkerState.KNIGHT_ATTACK_DUMMY, this::attackDummy, 20), new AITarget((IAIState)AIWorkerState.KNIGHT_ATTACK_PROTECT, this::attack, 60));
    }

    private IAIState decideOnTrainingType() {
        if (((BuildingCombatAcademy)this.getOwnBuilding()).hasCombatPartner(this.worker) || this.worker.func_70681_au().nextInt(100) < 25) {
            return AIWorkerState.FIND_TRAINING_PARTNER;
        }
        return AIWorkerState.FIND_DUMMY_PARTNER;
    }

    @Override
    public IAIState decide() {
        if (((BuildingCombatAcademy)this.getOwnBuilding()).hasCombatPartner(this.worker)) {
            return AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
        }
        return super.decide();
    }

    private IAIState findTrainingPartner() {
        BuildingCombatAcademy academy = (BuildingCombatAcademy)this.getOwnBuilding();
        this.trainingPartner = academy.hasCombatPartner(this.worker) ? academy.getCombatPartner(this.worker) : academy.getRandomCombatPartner(this.worker);
        if (this.trainingPartner == null) {
            return AIWorkerState.COMBAT_TRAINING;
        }
        return AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
    }

    private IAIState trainWithPartner() {
        if (this.trainingPartner == null || !this.getModuleForJob().getAssignedCitizen().contains(this.trainingPartner.getCitizenData())) {
            this.trainingPartner = null;
            return AIWorkerState.COMBAT_TRAINING;
        }
        if (BlockPosUtil.getDistance2D(this.worker.func_233580_cy_(), this.trainingPartner.func_233580_cy_()) > 5L && this.walkToBlock(this.trainingPartner.func_233580_cy_())) {
            return AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
        }
        return AIWorkerState.KNIGHT_ATTACK_PROTECT;
    }

    private IAIState attack() {
        if (this.trainingPartner == null) {
            return AIWorkerState.START_WORKING;
        }
        if (BlockPosUtil.getDistance2D(this.worker.func_233580_cy_(), this.trainingPartner.func_233580_cy_()) > 5L) {
            this.currentPathingTarget = this.trainingPartner.func_233580_cy_();
            this.stateAfterPathing = AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
            return AIWorkerState.GO_TO_TARGET;
        }
        if (this.currentAttackDelay <= 0) {
            this.worker.getCitizenExperienceHandler().addExperience(2.0);
            this.worker.decreaseSaturationForAction();
            this.worker.func_70625_a((Entity)this.trainingPartner, 180.0f, 180.0f);
            WorkerUtil.faceBlock(this.trainingPartner.func_233580_cy_().func_177984_a(), this.worker);
            this.worker.func_184602_cy();
            if (this.worker.func_70681_au().nextBoolean()) {
                int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), Items.field_185159_cQ);
                if (shieldSlot != -1) {
                    this.worker.func_184185_a(SoundEvents.field_187767_eL, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.func_70681_au()));
                    this.worker.getCitizenItemHandler().setHeldItem(Hand.OFF_HAND, shieldSlot);
                    this.worker.func_184598_c(Hand.OFF_HAND);
                    this.worker.func_70671_ap().func_75651_a((Entity)this.trainingPartner, 180.0f, 180.0f);
                }
            } else {
                this.worker.func_184609_a(Hand.MAIN_HAND);
                this.worker.func_184185_a(SoundEvents.field_187730_dW, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.func_70681_au()));
                this.trainingPartner.func_70097_a((DamageSource)new NamedDamageSource("death.attack.entity.minecolonies.training", (Entity)this.worker), 0.0f);
                this.worker.getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
            }
            this.worker.getNavigation().moveAwayFromXYZ(this.trainingPartner.func_233580_cy_(), 4.0, 1.0, true);
            ++this.targetCounter;
            if (this.targetCounter > ((BuildingCombatAcademy)this.getOwnBuilding()).getBuildingLevel() * 5) {
                ((BuildingCombatAcademy)this.getOwnBuilding()).resetPartner(this.worker);
                this.targetCounter = 0;
                return AIWorkerState.START_WORKING;
            }
        } else {
            this.reduceAttackDelay();
            return AIWorkerState.KNIGHT_ATTACK_PROTECT;
        }
        this.currentAttackDelay = 60;
        return AIWorkerState.KNIGHT_ATTACK_PROTECT;
    }

    private IAIState findDummyPartner() {
        BuildingCombatAcademy academy = (BuildingCombatAcademy)this.getOwnBuilding();
        if (this.targetCounter >= academy.getBuildingLevel() * 5) {
            this.worker.func_184602_cy();
            this.targetCounter = 0;
            return AIWorkerState.DECIDE;
        }
        if (((BuildingCombatAcademy)this.getOwnBuilding()).hasCombatPartner(this.worker)) {
            return AIWorkerState.KNIGHT_TRAIN_WITH_PARTNER;
        }
        BlockPos targetPos = academy.getRandomCombatTarget(this.worker.func_70681_au());
        if (targetPos == null) {
            this.worker.func_184602_cy();
            return AIWorkerState.DECIDE;
        }
        this.currentCombatTarget = targetPos;
        ++this.targetCounter;
        this.currentPathingTarget = targetPos;
        this.stateAfterPathing = AIWorkerState.KNIGHT_ATTACK_DUMMY;
        return AIWorkerState.GO_TO_TARGET;
    }

    private IAIState attackDummy() {
        if (this.currentCombatTarget == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.currentAttackDelay <= 0) {
            this.worker.getCitizenExperienceHandler().addExperience(2.0);
            this.worker.decreaseSaturationForAction();
            WorkerUtil.faceBlock(this.currentCombatTarget, this.worker);
            this.worker.func_184602_cy();
            if (this.worker.func_70681_au().nextBoolean()) {
                int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), Items.field_185159_cQ);
                if (shieldSlot != -1) {
                    this.worker.func_184185_a(SoundEvents.field_187767_eL, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.func_70681_au()));
                    this.worker.getCitizenItemHandler().setHeldItem(Hand.OFF_HAND, shieldSlot);
                    this.worker.func_184598_c(Hand.OFF_HAND);
                }
            } else {
                this.worker.func_184609_a(Hand.MAIN_HAND);
                this.worker.func_184185_a(SoundEvents.field_187730_dW, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.func_70681_au()));
                this.worker.getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
            }
        } else {
            this.reduceAttackDelay();
            return AIWorkerState.KNIGHT_ATTACK_DUMMY;
        }
        this.currentAttackDelay = 60;
        return AIWorkerState.FIND_DUMMY_PARTNER;
    }

    @Override
    protected boolean isSetup() {
        if (this.checkForToolOrWeapon(ToolType.SWORD)) {
            return false;
        }
        if (this.checkForToolOrWeapon(ToolType.SHIELD)) {
            return false;
        }
        int weaponSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), ToolType.SWORD, 0, ((BuildingCombatAcademy)this.getOwnBuilding()).getMaxToolLevel());
        if (weaponSlot != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, weaponSlot);
        }
        return true;
    }

    @Override
    public Class<BuildingCombatAcademy> getExpectedBuildingClass() {
        return BuildingCombatAcademy.class;
    }
}

