/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.miner;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ai.citizen.builder.IBuilderUndestroyable;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.SurfaceType;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.modules.QuarryModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobQuarrier;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import com.minecolonies.coremod.entity.ai.util.WorkerLoadOnlyStructureHandler;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIQuarrier
extends AbstractEntityAIStructureWithWorkOrder<JobQuarrier, BuildingMiner> {
    private static final String RENDER_META_TORCH = "torch";
    private static final String RENDER_META_STONE = "stone";
    private static final int MAX_BLOCKS_MINED = 128;

    public EntityAIQuarrier(@NotNull JobQuarrier job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.BUILDING_STEP, this::structureStep, 5));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingMiner> getExpectedBuildingClass() {
        return BuildingMiner.class;
    }

    @NotNull
    private IAIState startWorkingAtOwnBuilding() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        IBuilding quarry = ((JobQuarrier)this.job).findQuarry();
        if (quarry == null) {
            this.walkToBuilding();
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.quarrier.noquarry"), ChatPriority.BLOCKING));
            return AIWorkerState.IDLE;
        }
        if (quarry.getFirstModuleOccurance(QuarryModule.class).isFinished()) {
            this.walkToBuilding();
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.quarrier.finishedquarry"), ChatPriority.BLOCKING));
            return AIWorkerState.IDLE;
        }
        if (this.walkToBlock(quarry.getPosition())) {
            return this.getState();
        }
        return AIWorkerState.LOAD_STRUCTURE;
    }

    @Override
    public IAIState loadRequirements() {
        if (((JobQuarrier)this.job).getWorkOrder() == null) {
            IBuilding quarry = ((JobQuarrier)this.job).findQuarry();
            if (quarry == null || quarry.getFirstModuleOccurance(QuarryModule.class).isFinished()) {
                return AIWorkerState.IDLE;
            }
            String name = "schematics/" + quarry.getStyle() + "/" + quarry.getSchematicName() + "shaft1";
            WorkOrderBuildMiner wo = new WorkOrderBuildMiner(name, name, quarry.getRotation(), quarry.getPosition().func_177979_c(2), false, ((BuildingMiner)this.getOwnBuilding()).getPosition());
            ((BuildingMiner)this.getOwnBuilding()).getColony().getWorkManager().addWorkOrder(wo, false);
            ((JobQuarrier)this.job).setWorkOrder(wo);
        }
        return super.loadRequirements();
    }

    @Override
    public void loadStructure(@NotNull String name, int rotateTimes, BlockPos position, boolean isMirrored, boolean removal) {
        BuildingStructureHandler<JobQuarrier, BuildingMiner> structure = new BuildingStructureHandler<JobQuarrier, BuildingMiner>(this.world, position, name, new PlacementSettings(isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, BlockPosUtil.getRotationFromRotations(rotateTimes)), this, new BuildingStructureHandler.Stage[]{BuildingStructureHandler.Stage.BUILD_SOLID, BuildingStructureHandler.Stage.DECORATE, BuildingStructureHandler.Stage.CLEAR});
        ((BuildingMiner)this.getOwnBuilding()).setTotalStages(3);
        if (!structure.hasBluePrint()) {
            this.handleSpecificCancelActions();
            Log.getLogger().warn("Couldn't find structure with name: " + name + " aborting loading procedure");
            return;
        }
        ((JobQuarrier)this.job).setBlueprint(structure.getBluePrint());
        ((JobQuarrier)this.job).getBlueprint().rotateWithMirror(BlockPosUtil.getRotationFromRotations(rotateTimes), isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, this.world);
        this.setStructurePlacer(structure);
        if (this.getProgressPos() != null) {
            structure.setStage(this.getProgressPos().getB());
        }
    }

    @Override
    protected IBuilding getBuildingToDump() {
        IBuilding quarry = ((JobQuarrier)this.job).findQuarry();
        return quarry == null ? super.getBuildingToDump() : quarry;
    }

    @Override
    protected IAIState structureStep() {
        StructurePhasePlacementResult result;
        if (((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage() == null) {
            return AIWorkerState.PICK_UP_RESIDUALS;
        }
        if (InventoryUtils.isItemHandlerFull((IItemHandler)this.worker.getInventoryCitizen())) {
            return AIWorkerState.INVENTORY_FULL;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.building")});
        this.checkForExtraBuildingActions();
        BlockPos progress = this.getProgressPos() == null ? AbstractBlueprintIterator.NULL_POS : this.getProgressPos().getA();
        BlockPos worldPos = ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getProgressPosInWorld(progress);
        if (this.getProgressPos() != null) {
            ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).setStage(this.getProgressPos().getB());
        }
        if (!progress.equals((Object)AbstractBlueprintIterator.NULL_POS) && !this.limitReached && (this.blockToMine == null ? !this.walkToConstructionSite(worldPos) : !this.walkToConstructionSite(this.blockToMine))) {
            return this.getState();
        }
        this.limitReached = false;
        StructurePlacer placer = (StructurePlacer)this.structurePlacer.getA();
        switch (((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage()) {
            case BUILD_SOLID: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> placer.getIterator().decrement(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !info.getBlockInfo().getState().func_185904_a().func_76220_a() || EntityAIQuarrier.isDecoItem(info.getBlockInfo().getState().func_177230_c()) || pos.func_177956_o() < worldPos.func_177956_o())), false);
                if (progress.func_177956_o() != -1 && result.getIteratorPos().func_177956_o() < progress.func_177956_o()) {
                    ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).nextStage();
                    this.storeProgressPos(new BlockPos(0, progress.func_177956_o() + 1, 0), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                    break;
                }
                this.storeProgressPos(result.getIteratorPos(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                break;
            }
            case DECORATE: {
                if (progress.func_177956_o() >= ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeY()) {
                    ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).nextStage();
                    this.storeProgressPos(new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), progress.func_177956_o() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                    return this.getState();
                }
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> info.getBlockInfo().getState().func_185904_a().func_76220_a() && !EntityAIQuarrier.isDecoItem(info.getBlockInfo().getState().func_177230_c()) || pos.func_177956_o() > worldPos.func_177956_o())), false);
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).nextStage();
                    this.storeProgressPos(new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), progress.func_177956_o() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                    break;
                }
                if (progress.func_177956_o() != -1 && result.getIteratorPos().func_177956_o() > progress.func_177956_o()) {
                    ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).nextStage();
                    this.storeProgressPos(new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), progress.func_177956_o() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                    break;
                }
                this.storeProgressPos(result.getIteratorPos(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                break;
            }
            default: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_REMOVAL, () -> placer.getIterator().decrement((info, pos, handler) -> handler.getWorld().func_180495_p(pos).func_177230_c() instanceof IBuilderUndestroyable || handler.getWorld().func_180495_p(pos).func_177230_c() == Blocks.field_150357_h || handler.getWorld().func_180495_p(pos).func_177230_c() instanceof AirBlock || info.getBlockInfo().getState().func_177230_c() == ModBlocks.blockFluidSubstitution.get() || !handler.getWorld().func_180495_p(pos).func_204520_s().func_206888_e()), false);
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    ((BuildingMiner)this.getOwnBuilding()).nextStage();
                    ((BuildingMiner)this.getOwnBuilding()).setProgressPos(null, null);
                    return AIWorkerState.COMPLETE_BUILD;
                }
                if (progress.func_177956_o() != -1 && (result.getIteratorPos().func_177956_o() < progress.func_177956_o() || result.getBlockResult().getWorldPos().func_177956_o() < worldPos.func_177956_o())) {
                    ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).setStage(BuildingStructureHandler.Stage.BUILD_SOLID);
                    this.storeProgressPos(new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), progress.func_177956_o() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
                    break;
                }
                this.storeProgressPos(result.getIteratorPos(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getStage());
            }
        }
        if (result.getBlockResult().getResult() == BlockPlacementResult.Result.LIMIT_REACHED) {
            this.limitReached = true;
        }
        if (result.getBlockResult().getResult() == BlockPlacementResult.Result.MISSING_ITEMS) {
            if (EntityAIQuarrier.hasListOfResInInvOrRequest(this, result.getBlockResult().getRequiredItems(), result.getBlockResult().getRequiredItems().size() > 1) == AbstractEntityAIStructure.ItemCheckResult.RECALC) {
                ((JobQuarrier)this.job).getWorkOrder().setRequested(false);
                return AIWorkerState.LOAD_STRUCTURE;
            }
            return AIWorkerState.NEEDS_ITEM;
        }
        if (result.getBlockResult().getResult() == BlockPlacementResult.Result.BREAK_BLOCK) {
            BlockPos currentWorldPos = result.getBlockResult().getWorldPos();
            if (currentWorldPos.func_177956_o() < 5) {
                ((BuildingMiner)this.getOwnBuilding()).setProgressPos(null, null);
                return AIWorkerState.COMPLETE_BUILD;
            }
            this.blockToMine = currentWorldPos;
            return AIWorkerState.MINE_BLOCK;
        }
        if ((Integer)MineColonies.getConfig().getServer().builderBuildBlockDelay.get() > 0) {
            double decrease = 1.0 - this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_PLACE_SPEED);
            this.setDelay((int)((double)((Integer)MineColonies.getConfig().getServer().builderBuildBlockDelay.get() * 10 / (this.getPlaceSpeedLevel() / 2 + 10)) * decrease));
        }
        return this.getState();
    }

    @Override
    public boolean requestMaterials() {
        WorkerLoadOnlyStructureHandler<JobQuarrier, BuildingMiner> structure = new WorkerLoadOnlyStructureHandler<JobQuarrier, BuildingMiner>(this.world, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getWorldPos(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint(), new PlacementSettings(), true, this);
        ((JobQuarrier)this.job).getWorkOrder().setIteratorType("default");
        StructurePlacer placer = new StructurePlacer(structure, ((JobQuarrier)this.job).getWorkOrder().getIteratorType());
        if (this.requestProgress == null) {
            AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.getOwnBuilding();
            buildingWorker.resetNeededResources();
            this.requestProgress = new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeY() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1);
            this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.SOLID;
        }
        BlockPos worldPos = structure.getProgressPosInWorld(this.requestProgress);
        AbstractEntityAIStructureWithWorkOrder.RequestStage currState = this.requestState;
        switch (currState) {
            case SOLID: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().decrement(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !info.getBlockInfo().getState().func_185904_a().func_76220_a() || EntityAIQuarrier.isDecoItem(info.getBlockInfo().getState().func_177230_c()) || pos.func_177956_o() < worldPos.func_177956_o())), false);
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((BuildingMiner)this.getOwnBuilding()).addNeededResource(stack, stack.func_190916_E());
                }
                if (this.requestProgress.func_177956_o() != -1 && result.getIteratorPos().func_177956_o() < this.requestProgress.func_177956_o()) {
                    this.requestProgress = new BlockPos(0, this.requestProgress.func_177956_o() + 1, 0);
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.DECO;
                } else if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestProgress = new BlockPos(0, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeY() - 2, 0);
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.DECO;
                } else {
                    this.requestProgress = result.getIteratorPos();
                }
                return false;
            }
            case DECO: {
                if (this.requestProgress.func_177956_o() >= ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeY()) {
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.ENTITIES;
                    this.requestProgress = new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), this.requestProgress.func_177956_o() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1);
                    return false;
                }
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> info.getBlockInfo().getState().func_185904_a().func_76220_a() && !EntityAIQuarrier.isDecoItem(info.getBlockInfo().getState().func_177230_c()) || pos.func_177956_o() > worldPos.func_177956_o())), false);
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((BuildingMiner)this.getOwnBuilding()).addNeededResource(stack, stack.func_190916_E());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.ENTITIES;
                    this.requestProgress = new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), this.requestProgress.func_177956_o() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1);
                } else if (this.requestProgress.func_177956_o() != -1 && result.getIteratorPos().func_177956_o() > this.requestProgress.func_177956_o()) {
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.ENTITIES;
                    this.requestProgress = new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), this.requestProgress.func_177956_o() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1);
                } else {
                    this.requestProgress = result.getIteratorPos();
                }
                return false;
            }
            case ENTITIES: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().decrement(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> info.getEntities().length == 0 || pos.func_177956_o() < worldPos.func_177956_o())), true);
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.SOLID;
                    this.requestProgress = null;
                    return true;
                }
                if (this.requestProgress.func_177956_o() != -1 && result.getIteratorPos().func_177956_o() < this.requestProgress.func_177956_o()) {
                    this.requestState = AbstractEntityAIStructureWithWorkOrder.RequestStage.SOLID;
                    this.requestProgress = new BlockPos((int)((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeX(), this.requestProgress.func_177956_o() - 1, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint().getSizeZ() - 1);
                } else {
                    this.requestProgress = result.getIteratorPos();
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean checkIfCanceled() {
        if (((JobQuarrier)this.job).findQuarry() == null) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.quarrier.noquarry"), ChatPriority.BLOCKING));
            return true;
        }
        if (((JobQuarrier)this.job).findQuarry().getFirstModuleOccurance(QuarryModule.class).isFinished()) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.quarrier.finishedquarry"), ChatPriority.BLOCKING));
            return true;
        }
        if (((JobQuarrier)this.job).getWorkOrder() != null && !((JobQuarrier)this.job).getWorkOrder().getSchematicLocation().equals((Object)((JobQuarrier)this.job).findQuarry().getPosition().func_177979_c(2))) {
            this.blockToMine = null;
            ((JobQuarrier)this.job).complete();
            ((BuildingMiner)this.getOwnBuilding()).setProgressPos(null, null);
            return true;
        }
        return super.checkIfCanceled();
    }

    @Override
    public void setStructurePlacer(BuildingStructureHandler<JobQuarrier, BuildingMiner> structure) {
        this.structurePlacer = new Tuple<StructurePlacer, BuildingStructureHandler<JobQuarrier, BuildingMiner>>(new StructurePlacer(structure, "default"), structure);
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    @Override
    public int getPlaceSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return ((BuildingMiner)this.getOwnBuilding()).getBuildingLevel() * 128;
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.getRenderMetaStone() + this.getRenderMetaTorch());
    }

    @NotNull
    private String getRenderMetaTorch() {
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.field_221657_bQ)) {
            return RENDER_META_TORCH;
        }
        return "";
    }

    @NotNull
    private String getRenderMetaStone() {
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(this.getMainFillBlock())) {
            return RENDER_META_STONE;
        }
        return "";
    }

    @Override
    public IAIState doMining() {
        if (this.blockToMine == null) {
            return AIWorkerState.BUILDING_STEP;
        }
        for (Direction direction : Direction.values()) {
            BlockPos pos = this.blockToMine.func_177972_a(direction);
            BlockState surroundingState = this.world.func_180495_p(pos);
            FluidState fluid = this.world.func_204610_c(pos);
            if (surroundingState.func_177230_c() != Blocks.field_150353_l && (fluid == null || fluid.func_206888_e() || fluid.func_206886_c() != Fluids.field_204547_b && fluid.func_206886_c() != Fluids.field_207213_d) && !SurfaceType.isWater((IBlockReader)this.world, pos, surroundingState, fluid)) continue;
            this.setBlockFromInventory(pos, this.getMainFillBlock());
        }
        if (this.world.func_180495_p(this.blockToMine).func_177230_c() instanceof AirBlock) {
            this.blockToMine = null;
            return AIWorkerState.BUILDING_STEP;
        }
        if (!this.mineBlock(this.blockToMine, this.getCurrentWorkingPosition())) {
            this.worker.func_184609_a(Hand.MAIN_HAND);
            return this.getState();
        }
        this.worker.decreaseSaturationForContinuousAction();
        this.blockToMine = null;
        return AIWorkerState.BUILDING_STEP;
    }

    private Block getMainFillBlock() {
        return ((BuildingMiner)this.getOwnBuilding()).getSetting(BuildingMiner.FILL_BLOCK).getValue().func_179223_d();
    }

    @Override
    public ItemStack getTotalAmount(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return null;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(Math.max(super.getTotalAmount(stack).func_190916_E(), copy.func_77976_d() / 2));
        return copy;
    }

    @Override
    public IAIState afterStructureLoading() {
        return AIWorkerState.BUILDING_STEP;
    }

    private void setBlockFromInventory(@NotNull BlockPos location, Block block) {
        this.worker.func_184609_a(this.worker.func_184600_cs());
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(block);
        if (slot != -1) {
            this.getInventory().extractItem(slot, 1, false);
            WorldUtil.setBlockState((IWorld)this.world, location, block.func_176223_P());
        }
    }

    @Override
    public void executeSpecificCompleteActions() {
        super.executeSpecificCompleteActions();
        IBuilding quarry = ((JobQuarrier)this.job).findQuarry();
        if (quarry != null) {
            quarry.getFirstModuleOccurance(QuarryModule.class).setFinished();
        }
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, BlockState worldMetadata) {
        return IColonyManager.getInstance().getCompatibilityManager().isOre(worldMetadata);
    }

    @Override
    public boolean walkToConstructionSite(BlockPos currentBlock) {
        if (this.workFrom == null) {
            this.workFrom = this.findRandomPositionToWalkTo(5, currentBlock);
            if (this.workFrom == null && this.pathBackupFactor > 10) {
                this.workFrom = this.worker.func_233580_cy_();
            }
            return false;
        }
        if (this.walkToBlock(this.workFrom)) {
            return false;
        }
        if (BlockPosUtil.getDistance(this.worker.func_233580_cy_(), currentBlock) > (double)(5 + 5 * this.pathBackupFactor)) {
            this.workFrom = null;
            return false;
        }
        if (this.pathBackupFactor > 1) {
            --this.pathBackupFactor;
        }
        return true;
    }

    @Override
    public BlockState getSolidSubstitution(BlockPos ignored) {
        return this.getMainFillBlock().func_176223_P();
    }
}

