/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.lumberjack;

import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.entity.pathfinding.TreePathResult;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.colony.jobs.JobLumberjack;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.Tree;
import com.minecolonies.coremod.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobMoveToWithPassable;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherrackBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkLumberjack
extends AbstractEntityAICrafting<JobLumberjack, BuildingLumberjack> {
    private static final String RENDER_META_LOGS = "logs";
    public static final int SEARCH_RANGE = 50;
    private static final int SEARCH_INCREMENT = 5;
    private static final int SEARCH_LIMIT = 150;
    public static final String SAPLINGS_LIST = "saplings";
    public static final float RANGE_VERTICAL_PICKUP = 2.0f;
    public static final float RANGE_HORIZONTAL_PICKUP = 5.0f;
    private static final int MIN_WORKING_RANGE = 2;
    private static final int WAIT_BEFORE_SAPLING = 50;
    private static final int MAX_WAITING_TIME = 50;
    private static final int TIMEOUT_DELAY = 10;
    private static final int WAIT_BEFORE_SEARCH = 400;
    private static final int WAIT_BEFORE_INCREMENT = 20;
    private static final int MAX_BLOCKS_MINED = 32;
    private static final int GATHERING_DELAY = 3;
    private static final VisibleCitizenStatus SEARCH = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/lumberjack_search.png"), "com.minecolonies.gui.visiblestatus.lumberjack_search");
    private static final double XP_PER_TREE = 1.0;
    private BlockPos workFrom;
    private int timeWaited = 0;
    private boolean checkedInHut = false;
    @Nullable
    private TreePathResult pathResult;
    private int searchIncrement = 0;
    private PathResult<?> pathToTree;

    @Override
    protected int getActionRewardForCraftingSuccess() {
        return this.getActionsDoneUntilDumping();
    }

    public EntityAIWorkLumberjack(@NotNull JobLumberjack job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.LUMBERJACK_START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepareForWoodcutting, 20), new AITarget((IAIState)AIWorkerState.LUMBERJACK_SEARCHING_TREE, this::findTrees, 20), new AITarget((IAIState)AIWorkerState.LUMBERJACK_CHOP_TREE, this::chopWood, 20), new AITarget((IAIState)AIWorkerState.LUMBERJACK_GATHERING, this::gathering, 20), new AITarget((IAIState)AIWorkerState.LUMBERJACK_NO_TREES_FOUND, this::waitBeforeCheckingAgain, 20));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingLumberjack> getExpectedBuildingClass() {
        return BuildingLumberjack.class;
    }

    @Override
    protected IAIState decide() {
        if (this.checkIfStuck()) {
            this.tryUnstuck();
            return this.getState();
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((JobLumberjack)this.job).getActionsDone() >= this.getActionsDoneUntilDumping()) {
            return this.getState();
        }
        if (((JobLumberjack)this.job).getTaskQueue().isEmpty()) {
            return AIWorkerState.LUMBERJACK_START_WORKING;
        }
        if (((JobLumberjack)this.job).getCurrentTask() == null) {
            return AIWorkerState.LUMBERJACK_START_WORKING;
        }
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            return AIWorkerState.QUERY_ITEMS;
        }
        return AIWorkerState.GET_RECIPE;
    }

    private boolean isStackLog(@Nullable ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d().func_203417_a((ITag)BlockTags.field_200031_h);
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepareForWoodcutting() {
        if (this.checkForToolOrWeapon(ToolType.AXE) || this.checkForToolOrWeapon(ToolType.HOE)) {
            return AIWorkerState.START_WORKING;
        }
        return AIWorkerState.LUMBERJACK_SEARCHING_TREE;
    }

    private IAIState waitBeforeCheckingAgain() {
        this.pathResult = null;
        if (this.hasNotDelayed(400)) {
            return this.getState();
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState findTrees() {
        if (((JobLumberjack)this.job).getTree() == null) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.searchingtree")});
            return this.findTree();
        }
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        return AIWorkerState.LUMBERJACK_CHOP_TREE;
    }

    private IAIState findTree() {
        BuildingLumberjack building = (BuildingLumberjack)this.getOwnBuilding();
        this.worker.getCitizenData().setVisibleStatus(SEARCH);
        if (this.pathResult != null && this.pathResult.isComputing()) {
            return this.getState();
        }
        if (this.pathResult == null) {
            if (building.shouldRestrict()) {
                BlockPos startPos = building.getStartRestriction();
                BlockPos endPos = building.getEndRestriction();
                this.pathResult = this.worker.getNavigation().moveToTree(startPos, endPos, 1.0, (List<ItemStorage>)building.getModuleMatching(ItemListModule.class, m -> m.getId().equals(SAPLINGS_LIST)).getList(), building.getSetting(BuildingLumberjack.DYNAMIC_TREES_SIZE).getValue(), this.worker.getCitizenColonyHandler().getColony());
            } else {
                this.pathResult = this.worker.getNavigation().moveToTree(50 + this.searchIncrement, 1.0, (List<ItemStorage>)building.getModuleMatching(ItemListModule.class, m -> m.getId().equals(SAPLINGS_LIST)).getList(), building.getSetting(BuildingLumberjack.DYNAMIC_TREES_SIZE).getValue(), this.worker.getCitizenColonyHandler().getColony());
            }
            return this.getState();
        }
        if (this.pathResult.isDone()) {
            return this.setNewTree(building);
        }
        return AIWorkerState.LUMBERJACK_NO_TREES_FOUND;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAIState setNewTree(BuildingLumberjack building) {
        if (this.pathResult.treeLocation == null) {
            if (building.shouldRestrict() || this.searchIncrement + 50 > 150) return AIWorkerState.LUMBERJACK_NO_TREES_FOUND;
            this.searchIncrement += 5;
            this.setDelay(20);
        } else {
            ((JobLumberjack)this.job).setTree(new Tree(this.world, this.pathResult.treeLocation, ((BuildingLumberjack)this.getOwnBuilding()).getColony()));
            if (((JobLumberjack)this.job).getTree().isTree()) {
                ((JobLumberjack)this.job).getTree().findLogs(this.world, ((BuildingLumberjack)this.getOwnBuilding()).getColony());
                return AIWorkerState.LUMBERJACK_CHOP_TREE;
            }
            ((JobLumberjack)this.job).setTree(null);
        }
        this.pathResult = null;
        return this.getState();
    }

    private IAIState chopWood() {
        if (this.checkForToolOrWeapon(ToolType.AXE)) {
            return AIWorkerState.IDLE;
        }
        if (((JobLumberjack)this.job).getTree() == null) {
            return AIWorkerState.LUMBERJACK_SEARCHING_TREE;
        }
        return this.chopTree();
    }

    private IAIState chopTree() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.chopping")});
        if ((((JobLumberjack)this.job).getTree().hasLogs() || ((JobLumberjack)this.job).getTree().hasLeaves() && ((JobLumberjack)this.job).getTree().isNetherTree() || this.checkedInHut) && !this.walkToTree(((JobLumberjack)this.job).getTree().getStumpLocations().get(0))) {
            if (this.checkIfStuck()) {
                this.tryUnstuck();
            }
            return this.getState();
        }
        if (!(((JobLumberjack)this.job).getTree().hasLogs() || ((JobLumberjack)this.job).getTree().isNetherTree() && ((JobLumberjack)this.job).getTree().hasLeaves())) {
            if (this.hasNotDelayed(50)) {
                return this.getState();
            }
            BuildingLumberjack building = (BuildingLumberjack)this.getOwnBuilding();
            if (building.shouldReplant()) {
                this.plantSapling();
            } else {
                ((JobLumberjack)this.job).setTree(null);
                this.checkedInHut = false;
            }
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            this.incrementActionsDoneAndDecSaturation();
            this.workFrom = null;
            this.setDelay(60);
            return AIWorkerState.LUMBERJACK_GATHERING;
        }
        if (this.isOnSapling()) {
            @Nullable BlockPos spawnPoint = Utils.scanForBlockNearPoint(this.world, this.workFrom, 1, 1, 1, 3, Blocks.field_150350_a, Blocks.field_201941_jj, Blocks.field_150433_aE, Blocks.field_196804_gh);
            WorkerUtil.setSpawnPoint(spawnPoint, this.worker);
        }
        if (((JobLumberjack)this.job).getTree().hasLogs()) {
            BlockPos log = ((JobLumberjack)this.job).getTree().peekNextLog();
            if (((JobLumberjack)this.job).getTree().isDynamicTree()) {
                if (!this.mineBlock(log, this.workFrom, false, false, Compatibility.getDynamicTreeBreakAction(this.world, log, this.worker.func_184586_b(Hand.MAIN_HAND), this.worker.func_233580_cy_()))) {
                    return this.getState();
                }
                for (int i = 0; i < 6; ++i) {
                    this.incrementActionsDone();
                }
                this.setDelay(100);
            } else if (!this.mineBlock(log, this.workFrom)) {
                return this.getState();
            }
            ((JobLumberjack)this.job).getTree().pollNextLog();
            this.worker.decreaseSaturationForContinuousAction();
        } else if (((JobLumberjack)this.job).getTree().hasLeaves() && ((JobLumberjack)this.job).getTree().isNetherTree()) {
            BlockPos leaf = ((JobLumberjack)this.job).getTree().peekNextLeaf();
            if (!this.mineBlock(leaf, this.workFrom)) {
                return this.getState();
            }
            ((JobLumberjack)this.job).getTree().pollNextLeaf();
        }
        return this.getState();
    }

    @Override
    protected List<ItemStack> increaseBlockDrops(List<ItemStack> drops) {
        ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            if (this.world.func_201674_k().nextInt(100) <= 95) continue;
            if (stack.func_77973_b() == Items.field_221960_gl) {
                newDrops.add(new ItemStack((IItemProvider)Items.field_234722_bw_, 1));
                continue;
            }
            if (stack.func_77973_b() != Items.field_234751_hk_) continue;
            newDrops.add(new ItemStack((IItemProvider)Items.field_234723_bx_, 1));
        }
        if (newDrops.isEmpty()) {
            return drops;
        }
        return newDrops;
    }

    public boolean walkToTree(BlockPos workAt) {
        if (this.workFrom == null || this.world.func_180495_p(this.workFrom.func_177984_a()).func_177230_c().func_203417_a((ITag)BlockTags.field_200030_g) || this.world.func_180495_p(this.workFrom).func_177230_c().func_203417_a((ITag)BlockTags.field_200030_g)) {
            this.workFrom = this.getWorkingPosition(workAt);
        }
        if (MathUtils.twoDimDistance(this.worker.func_233580_cy_(), this.workFrom) <= 2.0) {
            return true;
        }
        if (this.pathToTree == null || !this.pathToTree.isInProgress()) {
            this.pathToTree = ((MinecoloniesAdvancedPathNavigate)this.worker.getNavigation()).setPathJob(new PathJobMoveToWithPassable(this.world, AbstractPathJob.prepareStart((LivingEntity)this.worker), workAt, 50, (LivingEntity)this.worker, this::isPassable), workAt, 1.0, true);
        }
        return false;
    }

    private Boolean isPassable(BlockState blockState) {
        return blockState.func_185904_a() == Material.field_151584_j;
    }

    private boolean checkIfStuck() {
        if (!this.worker.getNavigation().func_75500_f()) {
            Path path = this.worker.getNavigation().func_75505_d();
            if (path != null) {
                if (path.func_75874_d() > path.func_75873_e()) {
                    return true;
                }
                return path.func_75874_d() == 0;
            }
            return true;
        }
        return false;
    }

    private void tryUnstuck() {
        Path path;
        if (!this.worker.getNavigation().func_75500_f() && (path = this.worker.getNavigation().func_75505_d()) != null) {
            int i;
            ArrayList<BlockPos> checkPositions = new ArrayList<BlockPos>();
            PathPoint next = path.func_75877_a(Math.min(path.func_75873_e() + 1, path.func_75874_d() - 1));
            for (i = 0; i < 2; ++i) {
                checkPositions.add(new BlockPos(next.field_75839_a, next.field_75837_b + i, next.field_75838_c));
            }
            if (next.field_75841_h != null) {
                next = next.field_75841_h;
                for (i = 0; i < 2; ++i) {
                    checkPositions.add(new BlockPos(next.field_75839_a, next.field_75837_b + i, next.field_75838_c));
                }
                if (next.field_75841_h != null) {
                    next = next.field_75841_h;
                    for (i = 0; i < 2; ++i) {
                        checkPositions.add(new BlockPos(next.field_75839_a, next.field_75837_b + i, next.field_75838_c));
                    }
                }
            }
            this.mineIfEqualsBlockTag(checkPositions, (ITag<Block>)BlockTags.field_206952_E);
            return;
        }
        ArrayList<BlockPos> checkPositions = new ArrayList<BlockPos>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            checkPositions.add(new BlockPos(this.worker.func_233580_cy_().func_177958_n(), this.worker.func_233580_cy_().func_177956_o(), this.worker.func_233580_cy_().func_177952_p()).func_177972_a(direction));
            checkPositions.add(new BlockPos(this.worker.func_233580_cy_().func_177958_n(), this.worker.func_233580_cy_().func_177956_o() + 1, this.worker.func_233580_cy_().func_177952_p()).func_177972_a(direction));
        }
        this.mineIfEqualsBlockTag(checkPositions, (ITag<Block>)BlockTags.field_206952_E);
    }

    private boolean mineIfEqualsBlockTag(List<BlockPos> blockPositions, ITag<Block> tag) {
        for (BlockPos currentPos : blockPositions) {
            if ((Integer)MineColonies.getConfig().getServer().pathfindingDebugVerbosity.get() > 0) {
                Log.getLogger().info(String.format("Check Leaves Pos(%d, %d, %d) is %s: %s", currentPos.func_177958_n(), currentPos.func_177956_o(), currentPos.func_177952_p(), tag.toString(), this.world.func_180495_p(currentPos).func_177230_c().func_203417_a(tag)));
            }
            if (!this.world.func_180495_p(currentPos).func_177230_c().func_203417_a(tag)) continue;
            this.mineBlock(currentPos);
            return true;
        }
        return false;
    }

    private void plantSapling() {
        if (this.plantSapling(((JobLumberjack)this.job).getTree().getLocation())) {
            ((JobLumberjack)this.job).setTree(null);
            this.checkedInHut = false;
        }
    }

    private boolean isOnSapling() {
        return this.world.func_180495_p(this.worker.func_233580_cy_()).func_177230_c().func_203417_a((ITag)BlockTags.field_200030_g) || this.world.func_180495_p(this.worker.func_233580_cy_().func_177984_a()).func_177230_c().func_203417_a((ITag)BlockTags.field_200030_g) || this.world.func_180495_p(this.worker.func_233580_cy_().func_177977_b()).func_177230_c().func_203417_a((ITag)BlockTags.field_200030_g);
    }

    private boolean plantSapling(@NotNull BlockPos location) {
        Block worldBlock = this.world.func_180495_p(location).func_177230_c();
        if (!(worldBlock instanceof AirBlock) && !worldBlock.func_203417_a((ITag)BlockTags.field_200030_g) && worldBlock != Blocks.field_150433_aE) {
            return true;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.planting")});
        int saplingSlot = this.findSaplingSlot();
        if (saplingSlot != -1) {
            ItemStack stack = this.getInventory().getStackInSlot(saplingSlot);
            this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, saplingSlot);
            if (((JobLumberjack)this.job).getTree().isDynamicTree() && Compatibility.isDynamicTreeSapling(stack)) {
                Compatibility.plantDynamicSapling(this.world, location, stack);
                this.getInventory().extractItem(saplingSlot, 1, false);
                this.worker.func_184609_a(this.worker.func_184600_cs());
                this.timeWaited = 0;
                this.incrementActionsDoneAndDecSaturation();
                this.setDelay(10);
                return true;
            }
            Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
            this.placeSaplings(saplingSlot, stack, block);
            SoundType soundType = block.getSoundType(this.world.func_180495_p(location), (IWorldReader)this.world, location, (Entity)this.worker);
            this.world.func_184133_a(null, this.worker.func_233580_cy_(), soundType.func_185841_e(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b());
            this.worker.func_184609_a(this.worker.func_184600_cs());
        }
        if (this.timeWaited >= 25 && !this.checkedInHut && !this.walkToBuilding()) {
            this.checkAndTransferFromHut(((JobLumberjack)this.job).getTree().getSapling());
            this.checkedInHut = true;
        }
        if (((JobLumberjack)this.job).getTree().getStumpLocations().isEmpty() || this.timeWaited >= 50) {
            this.timeWaited = 0;
            this.incrementActionsDoneAndDecSaturation();
            this.setDelay(10);
            return true;
        }
        this.timeWaited += 10;
        return false;
    }

    @Override
    public void fillItemsList() {
        if (((JobLumberjack)this.job).getTree() != null) {
            this.searchForItems(new AxisAlignedBB(((JobLumberjack)this.job).getTree().getLocation()).func_72321_a(5.0, 2.0, 5.0).func_72321_a(-5.0, -2.0, -5.0));
        } else {
            this.searchForItems(this.worker.func_174813_aQ().func_72321_a(5.0, 2.0, 5.0).func_72321_a(-5.0, -2.0, -5.0));
        }
    }

    private int findSaplingSlot() {
        for (int slot = 0; slot < this.getInventory().getSlots(); ++slot) {
            ItemStack stack = this.getInventory().getStackInSlot(slot);
            if (!this.isCorrectSapling(stack)) continue;
            return slot;
        }
        return -1;
    }

    private void placeSaplings(int saplingSlot, @NotNull ItemStack stack, @NotNull Block block) {
        while (!((JobLumberjack)this.job).getTree().getStumpLocations().isEmpty()) {
            BlockPos pos = ((JobLumberjack)this.job).getTree().getStumpLocations().get(0);
            Item sapling = this.getInventory().getStackInSlot(saplingSlot).func_77973_b();
            if (sapling.func_206844_a(ModTags.fungi)) {
                Block new_block = sapling == Items.field_234723_bx_ ? Blocks.field_235372_ml_ : Blocks.field_235381_mu_;
                if (this.world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof NetherrackBlock) {
                    this.world.func_175656_a(pos.func_177977_b(), new_block.func_176223_P());
                    ((BuildingLumberjack)this.getOwnBuilding()).addNetherTree(pos);
                }
            }
            if (!(block instanceof IPlantable) || !block.canSustainPlant(this.world.func_180495_p(pos.func_177977_b()), (IBlockReader)this.world, pos.func_177977_b(), Direction.UP, (IPlantable)block) || Objects.equals(this.world.func_180495_p(pos), block.func_176223_P())) {
                ((JobLumberjack)this.job).getTree().removeStump(pos);
                continue;
            }
            if (this.world.func_175656_a(pos, block.func_176223_P()) && !ItemStackUtils.isEmpty(this.getInventory().getStackInSlot(saplingSlot)).booleanValue()) {
                this.getInventory().extractItem(saplingSlot, 1, false);
                ((JobLumberjack)this.job).getTree().removeStump(pos);
                continue;
            }
            return;
        }
    }

    private boolean isCorrectSapling(ItemStack stack) {
        if (!ItemStackUtils.isStackSapling(stack)) {
            return false;
        }
        if (ItemStackUtils.isEmpty(((JobLumberjack)this.job).getTree().getSapling()).booleanValue()) {
            return false;
        }
        return ((JobLumberjack)this.job).getTree().getSapling().func_77969_a(stack);
    }

    private IAIState gathering() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.gathering")});
        if (this.getItemsForPickUp() == null) {
            this.fillItemsList();
        }
        if (this.getItemsForPickUp() != null && !this.getItemsForPickUp().isEmpty()) {
            this.gatherItems();
            return this.getState();
        }
        this.resetGatheringItems();
        return AIWorkerState.LUMBERJACK_SEARCHING_TREE;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 32;
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.hasLogs() ? RENDER_META_LOGS : "");
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        return this.getWorkingPosition(2, targetPosition, 0);
    }

    private boolean hasLogs() {
        return InventoryUtils.hasItemInItemHandler((IItemHandler)this.getInventory(), this::isStackLog);
    }
}

