/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingShepherd;
import com.minecolonies.coremod.colony.jobs.JobShepherd;
import com.minecolonies.coremod.entity.ai.citizen.herders.AbstractEntityAIHerder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkShepherd
extends AbstractEntityAIHerder<JobShepherd, BuildingShepherd, SheepEntity> {
    private static final int MAX_ANIMALS_PER_LEVEL = 2;
    private static final int HUNDRED_PERCENT_CHANCE = 100;
    private static final int NUMBER_OF_DYE_POSSIBILITIES = 15;

    public EntityAIWorkShepherd(@NotNull JobShepherd job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.SHEPHERD_SHEAR, this::shearSheep, 20));
    }

    @Override
    @NotNull
    public List<ToolType> getExtraToolsNeeded() {
        List<ToolType> toolsNeeded = super.getExtraToolsNeeded();
        if (((BuildingShepherd)this.getOwnBuilding()).getSetting(BuildingShepherd.SHEARING).getValue()) {
            toolsNeeded.add(ToolType.SHEARS);
        }
        return toolsNeeded;
    }

    @Override
    public Class<BuildingShepherd> getExpectedBuildingClass() {
        return BuildingShepherd.class;
    }

    @Override
    public ItemStack getBreedingItem() {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151015_O);
        stack.func_190920_e(2);
        return stack;
    }

    @Override
    public int getMaxAnimalMultiplier() {
        return 2;
    }

    @Override
    public IAIState decideWhatToDo() {
        IAIState result = super.decideWhatToDo();
        ArrayList animals = new ArrayList(this.searchForAnimals());
        SheepEntity shearingSheep = animals.stream().filter(sheepie -> !sheepie.func_70892_o() && !sheepie.func_70631_g_()).findFirst().orElse(null);
        if (((BuildingShepherd)this.getOwnBuilding()).getSetting(BuildingShepherd.SHEARING).getValue() && result.equals(AIWorkerState.START_WORKING) && shearingSheep != null) {
            return AIWorkerState.SHEPHERD_SHEAR;
        }
        return result;
    }

    @Override
    public double getButcheringAttackDamage() {
        return Math.max(1.0, (double)this.getSecondarySkillLevel() / 10.0);
    }

    @Override
    public Class<SheepEntity> getAnimalClass() {
        return SheepEntity.class;
    }

    private IAIState shearSheep() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.shepherd.shearing")});
        List sheeps = this.searchForAnimals();
        if (sheeps.isEmpty()) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipTool(Hand.MAIN_HAND, ToolType.SHEARS)) {
            return AIWorkerState.PREPARING;
        }
        SheepEntity sheep = sheeps.stream().filter(sheepie -> !sheepie.func_70892_o() && !sheepie.func_70631_g_()).findFirst().orElse(null);
        if (this.worker.func_184614_ca() != null && sheep != null) {
            if (this.walkingToAnimal((AnimalEntity)sheep)) {
                return this.getState();
            }
            int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)this.worker.func_184614_ca());
            enchantmentLevel = (int)((double)enchantmentLevel * Math.max(1.0, (double)this.getPrimarySkillLevel() / 5.0));
            this.worker.func_184609_a(Hand.MAIN_HAND);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (!this.world.field_72995_K) {
                sheep.func_70893_e(true);
                int qty = 1 + this.worker.func_70681_au().nextInt(enchantmentLevel + 1);
                for (int j = 0; j < qty; ++j) {
                    items.add(new ItemStack((IItemProvider)SheepEntity.field_200206_bz.get(sheep.func_175509_cj())));
                }
            }
            sheep.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
            this.dyeSheepChance(sheep);
            this.worker.getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            this.incrementActionsDoneAndDecSaturation();
            for (ItemStack item : items) {
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(item, (IItemHandler)this.worker.getInventoryCitizen());
            }
        }
        return AIWorkerState.DECIDE;
    }

    private void dyeSheepChance(SheepEntity sheep) {
        if (this.worker.getCitizenColonyHandler().getWorkBuilding() != null && ((BuildingShepherd)this.getOwnBuilding()).getSetting(BuildingShepherd.DYEING).getValue()) {
            int chanceToDye = this.worker.getCitizenColonyHandler().getWorkBuilding().getBuildingLevel();
            int rand = this.world.field_73012_v.nextInt(100);
            if (rand <= chanceToDye) {
                int dyeInt = this.world.field_73012_v.nextInt(15);
                sheep.func_175512_b(DyeColor.func_196056_a((int)dyeInt));
            }
        }
    }
}

