/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCowboy;
import com.minecolonies.coremod.colony.jobs.JobCowboy;
import com.minecolonies.coremod.entity.ai.citizen.herders.AbstractEntityAIHerder;
import java.util.List;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCowboy
extends AbstractEntityAIHerder<JobCowboy, BuildingCowboy, CowEntity> {
    private static final int MAX_ANIMALS_PER_LEVEL = 2;
    private static final VisibleCitizenStatus HERD_COW = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/cowboy.png"), "com.minecolonies.gui.visiblestatus.cowboy");

    public EntityAIWorkCowboy(@NotNull JobCowboy job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.COWBOY_MILK, this::milkCows, 1));
    }

    @Override
    public Class<BuildingCowboy> getExpectedBuildingClass() {
        return BuildingCowboy.class;
    }

    @Override
    public ItemStack getBreedingItem() {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151015_O);
        stack.func_190920_e(2);
        return stack;
    }

    @Override
    public int getMaxAnimalMultiplier() {
        return 2;
    }

    @Override
    public Class<CowEntity> getAnimalClass() {
        return CowEntity.class;
    }

    @Override
    public IAIState decideWhatToDo() {
        IAIState result = super.decideWhatToDo();
        BuildingCowboy building = (BuildingCowboy)this.getOwnBuilding();
        boolean hasBucket = InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.field_151133_ar);
        if (building != null && ((BuildingCowboy)this.getOwnBuilding()).getSetting(BuildingCowboy.MILKING).getValue() && result.equals(AIWorkerState.START_WORKING) && hasBucket) {
            return AIWorkerState.COWBOY_MILK;
        }
        return result;
    }

    @Override
    @NotNull
    public List<ItemStack> getExtraItemsNeeded() {
        List<ItemStack> list = super.getExtraItemsNeeded();
        if (((BuildingCowboy)this.getOwnBuilding()).getSetting(BuildingCowboy.MILKING).getValue()) {
            list.add(new ItemStack((IItemProvider)Items.field_151133_ar));
        }
        return list;
    }

    private IAIState milkCows() {
        CowEntity cow;
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.cowboy.milking")});
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        if (!this.worker.getCitizenInventoryHandler().hasItemInInventory(this.getBreedingItem().func_77973_b()) && InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), new ItemStorage(new ItemStack((IItemProvider)Items.field_151133_ar, 1))) > 1) {
            if (!this.walkToBuilding()) {
                this.checkAndTransferFromHut(new ItemStack((IItemProvider)Items.field_151133_ar, 1));
            } else {
                return AIWorkerState.DECIDE;
            }
        }
        if ((cow = (CowEntity)this.searchForAnimals().stream().findFirst().orElse(null)) == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.walkingToAnimal((AnimalEntity)cow) && this.equipItem(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151133_ar, 1))) {
            if (InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((IItemProvider)Items.field_151117_aB))) {
                this.worker.getCitizenItemHandler().removeHeldItem();
                this.equipItem(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151117_aB));
                InventoryUtils.tryRemoveStackFromItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((IItemProvider)Items.field_151133_ar, 1));
            }
            this.incrementActionsDoneAndDecSaturation();
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
        }
        return AIWorkerState.DECIDE;
    }

    @Override
    public double getButcheringAttackDamage() {
        return Math.max(1.0, (double)this.getPrimarySkillLevel() / 10.0);
    }

    @Override
    protected IAIState breedAnimals() {
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        return super.breedAnimals();
    }

    @Override
    protected IAIState butcherAnimals() {
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        return super.butcherAnimals();
    }
}

