/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.compatibility.tinkers.TinkersToolHelper;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.combat.CombatAIStates;
import com.minecolonies.api.entity.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.combat.AttackMoveAI;
import com.minecolonies.coremod.entity.ai.combat.CombatUtils;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.util.NamedDamageSource;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;

public class KnightCombatAI
extends AttackMoveAI<EntityCitizen> {
    private static final VisibleCitizenStatus KNIGHT_COMBAT = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/knight_combat.png"), "com.minecolonies.gui.visiblestatus.knight_combat");
    private static final int KNOCKBACK_CHANCE = 5;
    private final AbstractEntityAIGuard parentAI;
    private long lastAoeUseTime = 0L;
    private final int KNOCKBACK_COOLDOWN = 240;
    private final int MIN_TIME_TO_ATTACK = 8;
    private static final double COMBAT_SPEED = 1.0;

    public KnightCombatAI(EntityCitizen owner, ITickRateStateMachine stateMachine, AbstractEntityAIGuard parentAI) {
        super(owner, stateMachine);
        this.parentAI = parentAI;
        stateMachine.addTransition(new TickingTransition<IAIState>(CombatAIStates.ATTACKING, () -> true, this::attackProtect, 8));
    }

    protected IAIState attackProtect() {
        int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), Items.field_185159_cQ);
        if (shieldSlot != -1 && this.target != null && this.target.func_70089_S() && this.nextAttackTime - ((EntityCitizen)this.user).field_70170_p.func_82737_E() >= 8L && ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SHIELD_USAGE) > 0.0) {
            ((EntityCitizen)this.user).getCitizenItemHandler().setHeldItem(Hand.OFF_HAND, shieldSlot);
            ((EntityCitizen)this.user).func_184598_c(Hand.OFF_HAND);
            ItemStack shieldStack = ((EntityCitizen)this.user).getInventoryCitizen().getHeldItem(Hand.OFF_HAND);
            CompoundNBT nbt = shieldStack.func_190925_c("BlockEntityTag");
            nbt.func_218657_a("Patterns", (INBT)((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getColonyFlag());
            ((EntityCitizen)this.user).func_70625_a((Entity)this.target, 180.0f, 180.0f);
            ((EntityCitizen)this.user).decreaseSaturationForContinuousAction();
        }
        return null;
    }

    @Override
    public boolean canAttack() {
        int weaponSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), ToolType.SWORD, 0, ((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getMaxToolLevel());
        if (weaponSlot != -1) {
            ((EntityCitizen)this.user).getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, weaponSlot);
            return true;
        }
        return false;
    }

    @Override
    protected void doAttack(LivingEntity target) {
        int fireLevel;
        if (((EntityCitizen)this.user).func_70032_d((Entity)target) > 1.0f) {
            this.moveInAttackPosition(target);
        }
        ((EntityCitizen)this.user).func_184609_a(Hand.MAIN_HAND);
        ((EntityCitizen)this.user).func_184185_a(SoundEvents.field_187730_dW, 1.0f, (float)SoundUtils.getRandomPitch(((EntityCitizen)this.user).func_70681_au()));
        double damageToBeDealt = this.getAttackDamage();
        NamedDamageSource source = new NamedDamageSource(((EntityCitizen)this.user).func_200200_C_().getString(), (Entity)this.user);
        if (((Boolean)MineColonies.getConfig().getServer().pvp_mode.get()).booleanValue() && target instanceof PlayerEntity) {
            source.func_76348_h();
        }
        if ((fireLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)((EntityCitizen)this.user).func_184586_b(Hand.MAIN_HAND))) > 0) {
            target.func_70015_d(fireLevel * 80);
        }
        if (((EntityCitizen)this.user).field_70170_p.func_82737_E() - this.lastAoeUseTime > 240L) {
            this.doAoeAttack((DamageSource)source, damageToBeDealt);
        }
        target.func_70097_a((DamageSource)source, (float)damageToBeDealt);
        target.func_70604_c(this.user);
        if (target instanceof MobEntity && ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.KNIGHT_TAUNT) > 0.0) {
            ((MobEntity)target).func_70624_b(this.user);
            if (target instanceof IThreatTableEntity) {
                ((IThreatTableEntity)target).getThreatTable().addThreat(this.user, 5);
            }
        }
        ((EntityCitizen)this.user).func_184602_cy();
        ((EntityCitizen)this.user).decreaseSaturationForContinuousAction();
        ((EntityCitizen)this.user).getCitizenData().setVisibleStatus(KNIGHT_COMBAT);
        ((EntityCitizen)this.user).getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
    }

    private void doAoeAttack(DamageSource source, double damageToBeDealt) {
        if (((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.KNIGHT_WHIRLWIND) > 0.0 && ((EntityCitizen)this.user).func_70681_au().nextInt(5) == 0) {
            List entities = ((EntityCitizen)this.user).field_70170_p.func_225317_b(LivingEntity.class, ((EntityCitizen)this.user).func_174813_aQ().func_72314_b(2.0, 0.5, 2.0));
            for (LivingEntity livingentity : entities) {
                if (livingentity == this.user || !this.isEntityValidTarget(livingentity) || livingentity instanceof ArmorStandEntity) continue;
                livingentity.func_233627_a_(2.0f, (double)MathHelper.func_76126_a((float)(livingentity.field_70177_z * (float)Math.PI)), (double)(-MathHelper.func_76134_b((float)(livingentity.field_70177_z * (float)Math.PI))));
                livingentity.func_70097_a(source, (float)(damageToBeDealt / (double)entities.size()));
            }
            ((EntityCitizen)this.user).field_70170_p.func_184148_a(null, ((EntityCitizen)this.user).func_226277_ct_(), ((EntityCitizen)this.user).func_226278_cu_(), ((EntityCitizen)this.user).func_226281_cx_(), SoundEvents.field_187730_dW, ((EntityCitizen)this.user).func_184176_by(), 1.0f, 1.0f);
            double d0 = -MathHelper.func_76126_a((float)(((EntityCitizen)this.user).field_70177_z * ((float)Math.PI / 180)));
            double d1 = MathHelper.func_76134_b((float)(((EntityCitizen)this.user).field_70177_z * ((float)Math.PI / 180)));
            if (((EntityCitizen)this.user).field_70170_p instanceof ServerWorld) {
                ((ServerWorld)((EntityCitizen)this.user).field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197603_N, ((EntityCitizen)this.user).func_226277_ct_() + d0, ((EntityCitizen)this.user).func_226283_e_(0.5), ((EntityCitizen)this.user).func_226281_cx_() + d1, 2, d0, 0.0, d1, 0.0);
            }
            this.lastAoeUseTime = ((EntityCitizen)this.user).field_70170_p.func_82737_E();
        }
    }

    private int getAttackDamage() {
        int addDmg = 0;
        ItemStack heldItem = ((EntityCitizen)this.user).func_184586_b(Hand.MAIN_HAND);
        if (ItemStackUtils.doesItemServeAsWeapon(heldItem)) {
            addDmg = heldItem.func_77973_b() instanceof SwordItem ? (int)((float)addDmg + (((SwordItem)heldItem.func_77973_b()).func_200894_d() + 3.0f)) : (int)((double)addDmg + TinkersToolHelper.getDamage(heldItem));
            addDmg = (int)((double)addDmg + (double)EnchantmentHelper.func_152377_a((ItemStack)heldItem, (CreatureAttribute)this.target.func_70668_bt()) / 2.5);
        }
        addDmg = (int)((double)addDmg + ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MELEE_DAMAGE));
        if ((double)((EntityCitizen)this.user).func_110143_aJ() <= (double)((EntityCitizen)this.user).func_110138_aP() * 0.2) {
            addDmg *= 2;
        }
        return (int)((double)addDmg * (Double)MineColonies.getConfig().getServer().knightDamageMult.get());
    }

    @Override
    protected double getAttackDistance() {
        return 2.0;
    }

    @Override
    protected int getAttackDelay() {
        int reload = 32 - ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) / 3;
        return Math.max(reload, 16);
    }

    @Override
    protected PathResult moveInAttackPosition(LivingEntity target) {
        return ((EntityCitizen)this.user).getNavigation().moveToXYZ(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), this.getCombatMovementSpeed());
    }

    protected double getCombatMovementSpeed() {
        double levelAdjustment = (double)((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) * 0.01;
        levelAdjustment += (double)(((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getBuildingLevel() - 1) * 0.01;
        levelAdjustment = Math.min(levelAdjustment, 0.3);
        return 1.0 + levelAdjustment;
    }

    @Override
    protected boolean isAttackableTarget(LivingEntity entity) {
        return AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, entity);
    }

    @Override
    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return this.parentAI.isWithinPersecutionDistance(target.func_233580_cy_(), this.getAttackDistance());
    }

    @Override
    protected boolean skipSearch(LivingEntity entity) {
        EntityCitizen citizen;
        if (entity instanceof EntityCitizen && (citizen = (EntityCitizen)entity).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && ((AbstractJobGuard)citizen.getCitizenJobHandler().getColonyJob()).isAsleep() && ((EntityCitizen)this.user).func_70635_at().func_75522_a((Entity)citizen)) {
            this.parentAI.setWakeCitizen(citizen);
            return true;
        }
        return false;
    }

    @Override
    protected void onTargetChange() {
        CombatUtils.notifyGuardsOfTarget((AbstractEntityCitizen)this.user, this.target, 1600);
    }

    @Override
    protected int getSearchRange() {
        return 0;
    }

    @Override
    protected void onTargetDied(LivingEntity entity) {
        this.parentAI.incrementActionsDoneAndDecSaturation();
        ((EntityCitizen)this.user).getCitizenExperienceHandler().addExperience(15.0);
    }
}

