/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.combat.CombatAIStates;
import com.minecolonies.api.entity.combat.threat.IThreatTableEntity;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.modules.EntityListModule;
import com.minecolonies.coremod.colony.buildings.modules.MinerLevelManagementModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIFight;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.SleepingParticleMessage;
import com.minecolonies.coremod.util.NamedDamageSource;
import com.minecolonies.coremod.util.TeleportHelper;
import java.lang.ref.WeakReference;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIGuard<J extends AbstractJobGuard<J>, B extends AbstractBuildingGuards>
extends AbstractEntityAIFight<J, B> {
    private static final int ACTIONS_UNTIL_DUMPING = 5;
    private static final int MAX_PATROL_DERIVATION = 80;
    public static final int PATROL_DEVIATION_RAID_POINT = 1600;
    private static final int MAX_FOLLOW_DERIVATION = 30;
    private static final int MAX_GUARD_DERIVATION = 10;
    protected static final int COMBAT_TIME = 600;
    protected LivingEntity target = null;
    private BlockPos currentPatrolPoint = null;
    protected final IGuardBuilding buildingGuards;
    private static final int PARTICLE_INTERVAL = 30;
    private static final int SHOULD_SLEEP_INTERVAL = 200;
    private static final int GUARD_TASK_INTERVAL = 100;
    private static final int GUARD_REGEN_INTERVAL = 40;
    private static final int ACTION_INCREASE_INTERVAL = 10;
    private int sleepTimer = 0;
    protected int wakeTimer = 0;
    protected int fighttimer = 0;
    protected WeakReference<EntityCitizen> sleepingGuard = new WeakReference<Object>(null);
    private Random randomGenerator = new Random();
    private int regularActionTimer = 0;
    private BlockPos lastGuardActionPos;

    public AbstractEntityAIGuard(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.DECIDE, CombatAIStates.NO_TARGET, 1), new AITarget(CombatAIStates.NO_TARGET, this::shouldSleep, () -> AIWorkerState.GUARD_SLEEP, 200), new AITarget((IAIState)AIWorkerState.GUARD_SLEEP, this::sleep, 1), new AITarget((IAIState)AIWorkerState.GUARD_SLEEP, this::sleepParticles, 30), new AITarget((IAIState)AIWorkerState.GUARD_REGEN, this::regen, 40), new AITarget(CombatAIStates.ATTACKING, this::shouldFlee, () -> AIWorkerState.GUARD_REGEN, 40), new AITarget((IAIState)CombatAIStates.NO_TARGET, this::decide, 100), new AITarget((IAIState)AIWorkerState.GUARD_WAKE, this::wakeUpGuard, 20), new AITarget((IAIState)CombatAIStates.ATTACKING, this::inCombat, 8));
        this.buildingGuards = (IGuardBuilding)this.getOwnBuilding();
        this.lastGuardActionPos = this.buildingGuards.getPosition();
    }

    private IAIState inCombat() {
        if (this.fighttimer <= 0) {
            this.onCombatEnter();
        }
        if (!this.hasTool()) {
            return AIWorkerState.PREPARING;
        }
        this.fighttimer = 600;
        return null;
    }

    private void onCombatEnter() {
        this.worker.setCanBeStuck(false);
        this.worker.getNavigation().getPathingOptions().setCanUseRails(false);
    }

    private void onCombatLeave() {
        this.worker.getNavigation().getPathingOptions().setCanUseRails(((EntityCitizen)this.worker).canPathOnRails());
        this.worker.setCanBeStuck(true);
    }

    private IAIState wakeUpGuard() {
        if (this.sleepingGuard.get() == null || !(((EntityCitizen)this.sleepingGuard.get()).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) || !((EntityCitizen)this.sleepingGuard.get()).getCitizenJobHandler().getColonyJob(AbstractJobGuard.class).isAsleep()) {
            return CombatAIStates.NO_TARGET;
        }
        ++this.wakeTimer;
        if (this.wakeTimer == 1) {
            return this.getState();
        }
        if (BlockPosUtil.getDistanceSquared(((EntityCitizen)this.sleepingGuard.get()).func_233580_cy_(), this.worker.func_233580_cy_()) <= 4L || this.wakeTimer > 10) {
            this.worker.func_184609_a(Hand.OFF_HAND);
            ((EntityCitizen)this.sleepingGuard.get()).func_70097_a(new NamedDamageSource("wakeywakey", (Entity)this.worker).func_76348_h(), 1.0f);
            ((EntityCitizen)this.sleepingGuard.get()).func_70604_c((LivingEntity)this.worker);
            return CombatAIStates.NO_TARGET;
        }
        this.worker.getNavigation().moveToLivingEntity((Entity)this.sleepingGuard.get(), 1.0);
        return this.getState();
    }

    private boolean shouldSleep() {
        if (this.worker.func_70643_av() != null || this.target != null || this.fighttimer > 0) {
            return false;
        }
        double chance = 1.0 - this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SLEEP_LESS);
        if (this.worker.func_70681_au().nextInt((int)((double)this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) * 0.5) + 20) == 1 && this.worker.func_70681_au().nextDouble() < chance) {
            this.sleepTimer = this.worker.func_70681_au().nextInt(500) + 2500;
            SittingEntity.sitDown(this.worker.func_233580_cy_(), (MobEntity)this.worker, this.sleepTimer);
            return true;
        }
        return false;
    }

    private IAIState sleepParticles() {
        Network.getNetwork().sendToTrackingEntity(new SleepingParticleMessage(this.worker.func_226277_ct_(), this.worker.func_226278_cu_() + 2.0, this.worker.func_226281_cx_()), (Entity)this.worker);
        if (this.worker.func_110143_aJ() < this.worker.func_110138_aP()) {
            this.worker.func_70606_j(this.worker.func_110143_aJ() + 0.5f);
        }
        return null;
    }

    private IAIState sleep() {
        if (this.worker.func_70643_av() != null || (this.sleepTimer -= this.getTickRate()) < 0) {
            this.stopSleeping();
            ((EntityCitizen)this.worker).getThreatTable().removeCurrentTarget();
            this.worker.func_70604_c(null);
            return CombatAIStates.NO_TARGET;
        }
        this.worker.func_70671_ap().func_75650_a(this.worker.func_226277_ct_() + (double)this.worker.func_174811_aO().func_82601_c(), this.worker.func_226278_cu_() + (double)this.worker.func_174811_aO().func_96559_d(), this.worker.func_226281_cx_() + (double)this.worker.func_174811_aO().func_82599_e(), 0.0f, 30.0f);
        return null;
    }

    private void stopSleeping() {
        if (this.getState() == AIWorkerState.GUARD_SLEEP) {
            this.worker.func_184210_p();
            this.worker.func_70107_b(this.worker.func_226277_ct_(), this.worker.func_226278_cu_() + 1.0, this.worker.func_226281_cx_());
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
        }
    }

    private boolean shouldFlee() {
        if (this.buildingGuards.shallRetrieveOnLowHealth() && (double)this.worker.func_110143_aJ() < (double)((int)this.worker.func_110138_aP()) * 0.2) {
            return this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RETREAT) > 0.0;
        }
        return false;
    }

    private IAIState regen() {
        double effect;
        if (!this.worker.func_70644_a(Effects.field_76424_c) && (effect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FLEEING_SPEED)) > 0.0) {
            this.worker.func_195064_c(new EffectInstance(Effects.field_76424_c, 200, (int)(0.0 + effect)));
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.GUARD_REGEN;
        }
        if ((double)this.worker.func_110143_aJ() < (double)((int)this.worker.func_110138_aP()) * 0.75 && this.buildingGuards.shallRetrieveOnLowHealth()) {
            if (!this.worker.func_70644_a(Effects.field_76428_l)) {
                this.worker.func_195064_c(new EffectInstance(Effects.field_76428_l, 200));
            }
            return AIWorkerState.GUARD_REGEN;
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState guard() {
        this.guardMovement();
        return this.getState();
    }

    public void guardMovement() {
        this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getGuardPos(), 3);
    }

    private IAIState follow() {
        if (BlockPosUtil.getDistance2D(this.worker.func_233580_cy_(), this.buildingGuards.getPositionToFollow()) > 30L) {
            TeleportHelper.teleportCitizen(this.worker, this.worker.func_130014_f_(), this.buildingGuards.getPositionToFollow());
            return null;
        }
        if (this.buildingGuards.isTightGrouping()) {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getPositionToFollow(), 6);
        } else {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getPositionToFollow(), 15);
        }
        return null;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 5 * ((AbstractBuildingGuards)this.getOwnBuilding()).getBuildingLevel();
    }

    private IAIState rally(ILocation location) {
        ICitizenData citizenData = this.worker.getCitizenData();
        if (!this.worker.isWorkerAtSiteWithMove(location.getInDimensionLocation().func_177982_a(this.randomGenerator.nextInt(6) - 3, 0, this.randomGenerator.nextInt(6) - 3), 6) && citizenData != null && !this.worker.func_70644_a(Effects.field_76424_c)) {
            this.worker.func_195064_c(new EffectInstance(Effects.field_76424_c, 100, MathHelper.func_76125_a((int)(citizenData.getCitizenSkillHandler().getLevel(Skill.Adaptability) / 20), (int)2, (int)5), false, false));
        }
        return null;
    }

    @Override
    protected IAIState startWorkingAtOwnBuilding() {
        ILocation rallyLocation = this.buildingGuards.getRallyLocation();
        if (rallyLocation != null && rallyLocation.isReachableFromLocation(this.worker.getLocation()) || !this.canBeInterrupted() || this.buildingGuards.getTask().equals("com.minecolonies.core.guard.setting.patrol_mine") && this.buildingGuards.getMinePos() != null) {
            return AIWorkerState.PREPARING;
        }
        return super.startWorkingAtOwnBuilding();
    }

    public IAIState patrol() {
        if (this.buildingGuards.requiresManualTarget()) {
            if (this.currentPatrolPoint == null || this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 3)) {
                this.currentPatrolPoint = this.worker.func_70681_au().nextInt(5) <= 1 ? this.buildingGuards.getColony().getBuildingManager().getRandomBuilding(b -> true) : this.findRandomPositionToWalkTo(20);
                if (this.currentPatrolPoint != null) {
                    this.setNextPatrolTarget(this.currentPatrolPoint);
                }
            }
        } else {
            if (this.currentPatrolPoint == null) {
                this.currentPatrolPoint = this.buildingGuards.getNextPatrolTarget(false);
            }
            if (this.currentPatrolPoint != null && this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 3)) {
                this.buildingGuards.arrivedAtPatrolPoint(this.worker);
            }
        }
        return null;
    }

    public IAIState patrolMine() {
        if (this.buildingGuards.getMinePos() == null) {
            return AIWorkerState.PREPARING;
        }
        if (this.currentPatrolPoint == null || this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 2)) {
            IBuilding building = this.buildingGuards.getColony().getBuildingManager().getBuilding(this.buildingGuards.getMinePos());
            if (building != null) {
                if (building instanceof BuildingMiner) {
                    BuildingMiner buildingMiner = (BuildingMiner)building;
                    Level level = buildingMiner.getFirstModuleOccurance(MinerLevelManagementModule.class).getCurrentLevel();
                    if (level == null) {
                        this.setNextPatrolTarget(buildingMiner.getPosition());
                    } else {
                        this.setNextPatrolTarget(level.getRandomCompletedNode(buildingMiner));
                    }
                } else {
                    this.buildingGuards.getFirstModuleOccurance(ISettingsModule.class).getSetting(AbstractBuildingGuards.GUARD_TASK).set("com.minecolonies.core.guard.setting.patrol");
                }
            } else {
                this.buildingGuards.getFirstModuleOccurance(ISettingsModule.class).getSetting(AbstractBuildingGuards.GUARD_TASK).set("com.minecolonies.core.guard.setting.patrol");
            }
        }
        return null;
    }

    public void setNextPatrolTarget(BlockPos target) {
        this.currentPatrolPoint = target;
        if (this.getState() == CombatAIStates.NO_TARGET) {
            this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 2);
        }
    }

    public boolean hasTool() {
        for (ToolType toolType : this.toolsNeeded) {
            if (InventoryUtils.hasItemHandlerToolWithLevel((IItemHandler)this.getInventory(), toolType, 0, this.buildingGuards.getMaxToolLevel())) continue;
            return false;
        }
        return true;
    }

    public void startHelpCitizen(LivingEntity attacker) {
        if (this.canHelp()) {
            ((IThreatTableEntity)((Object)this.worker)).getThreatTable().addThreat(attacker, 20);
            this.registerTarget(new AIOneTimeEventTarget(CombatAIStates.ATTACKING));
        }
    }

    public boolean canHelp() {
        if ((this.getState() == CombatAIStates.NO_TARGET || this.getState() == AIWorkerState.GUARD_SLEEP) && this.canBeInterrupted()) {
            this.stopSleeping();
            return true;
        }
        return false;
    }

    protected IAIState decide() {
        ILocation rallyLocation = this.buildingGuards.getRallyLocation();
        if (this.regularActionTimer++ > 10) {
            this.incrementActionsDone();
            this.regularActionTimer = 0;
        }
        if (!this.hasTool()) {
            return AIWorkerState.PREPARING;
        }
        if (this.fighttimer > 0) {
            this.fighttimer -= 100;
            if (this.fighttimer <= 0) {
                this.onCombatLeave();
            }
        } else {
            this.worker.func_184602_cy();
            this.lastGuardActionPos = this.worker.func_233580_cy_();
        }
        if (rallyLocation != null || this.buildingGuards.getTask().equals("com.minecolonies.core.guard.setting.follow")) {
            this.worker.func_195064_c(new EffectInstance(Constants.GLOW_EFFECT, 600, 20, false, false));
        } else {
            this.worker.func_184596_c(Constants.GLOW_EFFECT);
        }
        if (rallyLocation != null && rallyLocation.isReachableFromLocation(this.worker.getLocation())) {
            return this.rally(rallyLocation);
        }
        switch (this.buildingGuards.getTask()) {
            case "com.minecolonies.core.guard.setting.patrol": {
                return this.patrol();
            }
            case "com.minecolonies.core.guard.setting.guard": {
                return this.guard();
            }
            case "com.minecolonies.core.guard.setting.follow": {
                return this.follow();
            }
            case "com.minecolonies.core.guard.setting.patrol_mine": {
                return this.patrolMine();
            }
        }
        return AIWorkerState.PREPARING;
    }

    public boolean isWithinPersecutionDistance(BlockPos entityPos, double attackRange) {
        return (double)BlockPosUtil.getDistanceSquared(this.getTaskReferencePoint(), entityPos) <= Math.pow((double)this.getPersecutionDistance() + attackRange, 2.0);
    }

    private BlockPos getTaskReferencePoint() {
        ILocation location = this.buildingGuards.getRallyLocation();
        if (location != null) {
            return this.buildingGuards.getRallyLocation().getInDimensionLocation();
        }
        switch (this.buildingGuards.getTask()) {
            case "com.minecolonies.core.guard.setting.patrol": 
            case "com.minecolonies.core.guard.setting.patrol_mine": {
                return this.lastGuardActionPos;
            }
            case "com.minecolonies.core.guard.setting.follow": {
                return this.buildingGuards.getPositionToFollow();
            }
        }
        return this.buildingGuards.getGuardPos();
    }

    private int getPersecutionDistance() {
        if (this.buildingGuards.getRallyLocation() != null) {
            return 30;
        }
        switch (this.buildingGuards.getTask()) {
            case "com.minecolonies.core.guard.setting.patrol": 
            case "com.minecolonies.core.guard.setting.patrol_mine": {
                return 80;
            }
            case "com.minecolonies.core.guard.setting.follow": {
                return 30;
            }
        }
        return 10 + (this.getModuleForJob().getJobEntry() == ModJobs.knight ? 20 : 0);
    }

    @Override
    public boolean canBeInterrupted() {
        if (this.fighttimer > 0 || this.getState() == CombatAIStates.ATTACKING || this.buildingGuards.getRallyLocation() != null || this.buildingGuards.getTask().equals("com.minecolonies.core.guard.setting.follow")) {
            return false;
        }
        return super.canBeInterrupted();
    }

    public void setWakeCitizen(EntityCitizen citizen) {
        this.sleepingGuard = new WeakReference<EntityCitizen>(citizen);
        this.wakeTimer = 0;
        this.registerTarget(new AIOneTimeEventTarget(AIWorkerState.GUARD_WAKE));
    }

    @Override
    public Class<B> getExpectedBuildingClass() {
        return AbstractBuildingGuards.class;
    }

    public static boolean isAttackableTarget(AbstractEntityCitizen user, LivingEntity entity) {
        if (IColonyManager.getInstance().getCompatibilityManager().getAllMonsters().contains((Object)entity.func_200600_R().getRegistryName()) && !user.getCitizenData().getWorkBuilding().getModuleMatching(EntityListModule.class, m -> m.getId().equals("hostiles")).isEntityInList(entity.func_200600_R().getRegistryName())) {
            return true;
        }
        IColony colony = user.getCitizenColonyHandler().getColony();
        if (colony == null) {
            return false;
        }
        if (entity instanceof PlayerEntity && (colony.getPermissions().hasPermission((PlayerEntity)entity, Action.GUARDS_ATTACK) || colony.isValidAttackingPlayer((PlayerEntity)entity))) {
            return true;
        }
        return entity instanceof EntityCitizen && colony.isValidAttackingGuard((AbstractEntityCitizen)entity);
    }
}

