/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.Tag;
import com.minecolonies.api.colony.requestsystem.requestable.Tool;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.InventoryFunctions;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.interactionhandling.PosBasedInteraction;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.colony.requestsystem.resolvers.StationRequestResolver;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.pathfinding.EntityCitizenWalkToProxy;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIBasic<J extends AbstractJob<?, J>, B extends AbstractBuilding>
extends AbstractAISkeleton<J> {
    protected static final int STANDARD_DELAY = 5;
    protected static final int REQUEST_DELAY = 60;
    private static final int PICKUP_ATTEMPTS = 10;
    @Nullable
    protected BlockPos currentWorkingLocation = null;
    private int delay = 0;
    private boolean hasDelayed = false;
    private IWalkToProxy proxy;
    private int exceptionTimer = 1;
    private int slotAt = 0;
    private boolean hasDumpedItems = false;
    protected static final int WALK_DELAY = 20;
    protected Tuple<Predicate<ItemStack>, Integer> needsCurrently = null;
    protected BlockPos walkTo = null;
    private final List<ItemStorage> alreadyKept = new ArrayList<ItemStorage>();
    private int pickUpCounter = 0;

    protected AbstractEntityAIBasic(@NotNull J job) {
        super(job);
        super.registerTargets(new AIEventTarget<Object>(AIBlockingEventType.AI_BLOCKING, this::initSafetyChecks, 1), new AITarget((IAIState)AIWorkerState.INIT, this::getState, 1), new AIEventTarget<Supplier<Object>>(AIBlockingEventType.AI_BLOCKING, () -> true, this::updateVisualState, 20), new AIEventTarget<Supplier<Object>>(AIBlockingEventType.AI_BLOCKING, this::waitingForSomething, this::getState, 1), new AIEventTarget<AIWorkerState>(AIBlockingEventType.STATE_BLOCKING, this::inventoryNeedsDump, AIWorkerState.INVENTORY_FULL, 100), new AITarget((IAIState)AIWorkerState.INVENTORY_FULL, this::dumpInventory, 10), new AIEventTarget<AIWorkerState>(AIBlockingEventType.AI_BLOCKING, () -> this.getState() != AIWorkerState.INVENTORY_FULL && ((AbstractBuilding)this.getOwnBuilding()).hasOpenSyncRequest(this.worker.getCitizenData()) || ((AbstractBuilding)this.getOwnBuilding()).hasCitizenCompletedRequestsToPickup(this.worker.getCitizenData()), AIWorkerState.NEEDS_ITEM, 20), new AIEventTarget<AIWorkerState>(AIBlockingEventType.AI_BLOCKING, () -> ((AbstractBuilding)this.getOwnBuilding()).hasCitizenCompletedRequests(this.worker.getCitizenData()) && this.cleanAsync(), AIWorkerState.NEEDS_ITEM, 200), new AITarget((IAIState)AIWorkerState.NEEDS_ITEM, this::waitForRequests, 40), new AITarget((IAIState)AIWorkerState.GATHERING_REQUIRED_MATERIALS, this::getNeededItem, 20), new AIEventTarget<Supplier<Object>>(AIBlockingEventType.STATE_BLOCKING, this::shouldRestart, this::restart, 20), new AITarget(AIWorkerState.PAUSED, () -> !this.isPaused(), () -> AIWorkerState.IDLE, 20), new AITarget((IAIState)AIWorkerState.PAUSED, this::bePaused, 10), new AITarget((IAIState)AIWorkerState.WALK_TO, this::walkToState, 10), new AIEventTarget<AIWorkerState>(AIBlockingEventType.AI_BLOCKING, this::isStartingPaused, AIWorkerState.INVENTORY_FULL, 20));
    }

    public void setWalkTo(BlockPos walkto) {
        this.walkTo = walkto;
    }

    private IAIState walkToState() {
        if (this.walkToBlock(this.walkTo, 4)) {
            return this.getState();
        }
        return AIWorkerState.IDLE;
    }

    private IAIState getNeededItem() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.gathering")});
        if (this.walkTo == null && this.walkToBuilding()) {
            return this.getState();
        }
        if (this.needsCurrently == null) {
            return this.getStateAfterPickUp();
        }
        if (this.walkTo == null) {
            BlockPos pos = ((AbstractBuilding)this.getOwnBuilding()).getTileEntity().getPositionOfChestWithItemStack(this.needsCurrently.getA());
            if (pos == null) {
                return this.getStateAfterPickUp();
            }
            this.walkTo = pos;
        }
        if (this.walkToBlock(this.walkTo) && this.pickUpCounter++ < 10) {
            return this.getState();
        }
        this.pickUpCounter = 0;
        if (!this.tryTransferFromPosToWorkerIfNeeded(this.walkTo, this.needsCurrently)) {
            this.walkTo = null;
            return this.getState();
        }
        this.walkTo = null;
        return this.getStateAfterPickUp();
    }

    public IAIState getStateAfterPickUp() {
        return AIWorkerState.START_WORKING;
    }

    @NotNull
    public B getOwnBuilding() {
        return this.getOwnBuilding(this.getExpectedBuildingClass());
    }

    public abstract Class<B> getExpectedBuildingClass();

    @NotNull
    private B getOwnBuilding(@NotNull Class<B> type) {
        if (type.isInstance(this.worker.getCitizenColonyHandler().getWorkBuilding())) {
            return (B)((AbstractBuilding)this.worker.getCitizenColonyHandler().getWorkBuilding());
        }
        throw new IllegalStateException("Citizen " + this.worker.getCitizenData().getName() + " has lost its building unexpectedly, type does not match");
    }

    @Override
    protected void onException(RuntimeException e) {
        this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.worker.ai.exception"), ChatPriority.BLOCKING));
        try {
            int timeout = 100 * this.exceptionTimer;
            this.setDelay(FMLEnvironment.production ? timeout : 100);
            this.exceptionTimer *= 2;
            if (this.worker != null) {
                String name = this.worker.func_200200_C_().getString();
                BlockPos workerPosition = this.worker.func_233580_cy_();
                IJob<?> colonyJob = this.worker.getCitizenJobHandler().getColonyJob();
                String jobName = colonyJob == null ? "null" : colonyJob.getJobRegistryEntry().getTranslationKey();
                Log.getLogger().error("Pausing Entity " + name + " (" + jobName + ") at " + workerPosition + " for " + timeout + " Seconds because of error:");
            } else {
                Log.getLogger().error("Pausing Entity that is null for " + timeout + " Seconds because of error:");
            }
            e.printStackTrace();
        }
        catch (RuntimeException exp) {
            Log.getLogger().error("Welp reporting crashed:");
            exp.printStackTrace();
            Log.getLogger().error("Caused by ai exception:");
            e.printStackTrace();
        }
    }

    protected final void setDelay(int timeout) {
        this.delay = timeout;
    }

    protected boolean inventoryNeedsDump() {
        return this.getState() != AIWorkerState.INVENTORY_FULL && this.canBeInterrupted() && (this.worker.getCitizenInventoryHandler().isInventoryFull() || ((AbstractJob)this.job).getActionsDone() >= this.getActionsDoneUntilDumping() || this.wantInventoryDumped()) && !(this.job instanceof JobDeliveryman);
    }

    protected int getActionsDoneUntilDumping() {
        return 32;
    }

    protected boolean wantInventoryDumped() {
        return false;
    }

    @Nullable
    private IAIState initSafetyChecks() {
        if (null == this.worker.getCitizenJobHandler().getColonyJob() || this.worker.getCitizenColonyHandler().getWorkBuilding() == null || this.worker.getCitizenData() == null) {
            return AIWorkerState.INIT;
        }
        if (!this.getExpectedBuildingClass().isInstance(this.worker.getCitizenColonyHandler().getWorkBuilding())) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().setJob(null);
            }
            return AIWorkerState.INIT;
        }
        if (this.getState() == AIWorkerState.INIT) {
            return AIWorkerState.IDLE;
        }
        return null;
    }

    private IAIState updateVisualState() {
        ((AbstractJob)this.job).setNameTag(this.getState().toString());
        this.updateRenderMetaData();
        return null;
    }

    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata("");
    }

    private boolean waitingForSomething() {
        if (this.delay > 0) {
            if (this.delay % 5 == 0 && this.currentWorkingLocation != null && EntityUtils.isLivingAtSite((LivingEntity)this.worker, this.currentWorkingLocation.func_177958_n(), this.currentWorkingLocation.func_177956_o(), this.currentWorkingLocation.func_177952_p(), 4)) {
                this.worker.getCitizenItemHandler().hitBlockWithToolInHand(this.currentWorkingLocation);
            }
            this.delay -= this.getTickRate();
            if (this.delay <= 0) {
                this.clearWorkTarget();
            }
            return true;
        }
        return false;
    }

    private void clearWorkTarget() {
        this.currentWorkingLocation = null;
        this.delay = 0;
    }

    @NotNull
    private IAIState waitForRequests() {
        this.delay = 10;
        this.updateWorkerStatusFromRequests();
        return this.lookForRequests();
    }

    private void updateWorkerStatusFromRequests() {
        if (!((AbstractBuilding)this.getOwnBuilding()).hasWorkerOpenRequests(this.worker.getCitizenData().getId()) && !((AbstractBuilding)this.getOwnBuilding()).hasCitizenCompletedRequests(this.worker.getCitizenData())) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[0]);
            return;
        }
        Collection<IRequest<?>> requests = ((AbstractBuilding)this.getOwnBuilding()).getCompletedRequests(this.worker.getCitizenData());
        if (requests.isEmpty()) {
            requests = ((AbstractBuilding)this.getOwnBuilding()).getOpenRequests(this.worker.getCitizenData().getId());
        }
        if (!requests.isEmpty()) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.waiting"), requests.iterator().next().getShortDisplayString()});
        }
    }

    @NotNull
    private IAIState lookForRequests() {
        if (!((AbstractBuilding)this.getOwnBuilding()).hasOpenSyncRequest(this.worker.getCitizenData()) && !((AbstractBuilding)this.getOwnBuilding()).hasCitizenCompletedRequests(this.worker.getCitizenData())) {
            return this.afterRequestPickUp();
        }
        if (((AbstractBuilding)this.getOwnBuilding()).hasCitizenCompletedRequests(this.worker.getCitizenData())) {
            Collection<IRequest<?>> completedRequests = ((AbstractBuilding)this.getOwnBuilding()).getCompletedRequests(this.worker.getCitizenData());
            ArrayList deliverableRequests = new ArrayList();
            for (IRequest<?> req : completedRequests) {
                if (!req.canBeDelivered()) {
                    ((AbstractBuilding)this.getOwnBuilding()).markRequestAsAccepted(this.worker.getCitizenData(), (IToken<?>)req.getId());
                    continue;
                }
                deliverableRequests.add(req);
            }
            if (!deliverableRequests.isEmpty()) {
                ILocation pickupLocation;
                IRequest firstDeliverableRequest = (IRequest)deliverableRequests.get(0);
                IRequestResolver<?> resolver = ((AbstractSchematicProvider)this.getOwnBuilding()).getColony().getRequestManager().getResolverForRequest((IToken<?>)firstDeliverableRequest.getId());
                ILocation iLocation = pickupLocation = resolver instanceof StationRequestResolver ? resolver.getLocation() : ((AbstractBuilding)this.getOwnBuilding()).getLocation();
                if (this.walkToBlock(pickupLocation.getInDimensionLocation()) || !WorldUtil.isBlockLoaded((IWorld)this.world, pickupLocation.getInDimensionLocation())) {
                    return AIWorkerState.NEEDS_ITEM;
                }
                TileEntity blockEntity = this.world.func_175625_s(pickupLocation.getInDimensionLocation());
                if (blockEntity == null) {
                    return AIWorkerState.NEEDS_ITEM;
                }
                boolean async = false;
                if (this.worker.getCitizenData().isRequestAsync((IToken<?>)firstDeliverableRequest.getId())) {
                    async = true;
                    ((AbstractJob)this.job).getAsyncRequests().remove(firstDeliverableRequest.getId());
                }
                ((AbstractBuilding)this.getOwnBuilding()).markRequestAsAccepted(this.worker.getCitizenData(), (IToken<?>)firstDeliverableRequest.getId());
                ArrayList validHandlers = Lists.newArrayList();
                validHandlers.add(this.worker.getItemHandlerCitizen());
                validHandlers.addAll(InventoryUtils.getItemHandlersFromProvider((ICapabilityProvider)blockEntity));
                if (InventoryUtils.areAllItemsInItemHandlerList(firstDeliverableRequest.getDeliveries(), validHandlers)) {
                    List<ItemStack> niceToHave = this.itemsNiceToHave();
                    List<ItemStack> contained = InventoryUtils.getContainedFromItemHandler(firstDeliverableRequest.getDeliveries(), this.worker.getItemHandlerCitizen());
                    InventoryUtils.moveItemStacksWithPossibleSwap(this.worker.getItemHandlerCitizen(), InventoryUtils.getItemHandlersFromProvider((ICapabilityProvider)blockEntity), firstDeliverableRequest.getDeliveries(), itemStack -> contained.stream().anyMatch(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack)) || niceToHave.stream().anyMatch(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack)));
                    return AIWorkerState.NEEDS_ITEM;
                }
                if (async) {
                    this.worker.getCitizenData().createRequestAsync(firstDeliverableRequest.getRequest());
                } else {
                    this.worker.getCitizenData().createRequest(firstDeliverableRequest.getRequest());
                }
            }
        } else {
            this.walkToBuilding();
        }
        return AIWorkerState.NEEDS_ITEM;
    }

    protected int getPrimarySkillLevel() {
        return this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getPrimarySkill());
    }

    protected int getSecondarySkillLevel() {
        return this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getSecondarySkill());
    }

    protected WorkerBuildingModule getModuleForJob() {
        return ((AbstractBuilding)this.getOwnBuilding()).getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == ((AbstractJob)this.job).getJobRegistryEntry());
    }

    protected int getEffectiveSkillLevel(int rawSkillLevel) {
        return (int)((double)((rawSkillLevel + 1) * 2) - Math.pow((double)(rawSkillLevel + 1) / 10.0, 2.0));
    }

    private boolean cleanAsync() {
        Collection<IRequest<?>> completedRequests = ((AbstractBuilding)this.getOwnBuilding()).getCompletedRequests(this.worker.getCitizenData());
        for (IRequest<?> request : completedRequests) {
            if (!this.worker.getCitizenData().isRequestAsync((IToken<?>)request.getId())) continue;
            ((AbstractBuilding)this.getOwnBuilding()).markRequestAsAccepted(this.worker.getCitizenData(), (IToken<?>)request.getId());
        }
        return false;
    }

    public boolean isAfterDumpPickupAllowed() {
        return true;
    }

    public IAIState afterRequestPickUp() {
        return AIWorkerState.IDLE;
    }

    public int getTotalRequiredAmount(ItemStack deliveredItemStack) {
        return deliveredItemStack.func_190916_E();
    }

    protected final boolean walkToBuilding() {
        @Nullable B ownBuilding = this.getOwnBuilding();
        return ownBuilding == null || this.walkToBlock(ownBuilding.getPosition());
    }

    public boolean checkAndTransferFromHut(@Nullable ItemStack is) {
        @Nullable B building = this.getOwnBuilding();
        for (BlockPos pos : building.getContainers()) {
            TileEntity entity = this.world.func_175625_s(pos);
            if (!(entity instanceof TileEntityRack) || !((TileEntityRack)entity).hasItemStack(is, 1, false)) continue;
            entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(handler, stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(is, stack), (IItemHandler)this.getInventory()));
            return true;
        }
        return false;
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand) {
        return this.walkToBlock(stand, 4);
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand, int range) {
        if (this.proxy == null) {
            this.proxy = new EntityCitizenWalkToProxy(this.worker);
        }
        if (!this.proxy.walkToBlock(stand, range)) {
            this.workOnBlock(null, 10);
            return true;
        }
        return false;
    }

    private void workOnBlock(@Nullable BlockPos target, int timeout) {
        this.currentWorkingLocation = target;
    }

    public boolean retrieveToolInTileEntity(TileEntity entity, IToolType toolType, int minLevel, int maxLevel) {
        if (ToolType.NONE.equals(toolType)) {
            return false;
        }
        return InventoryFunctions.matchFirstInProviderWithAction((ICapabilityProvider)entity, stack -> ItemStackUtils.hasToolLevel(stack, toolType, minLevel, maxLevel), this::takeItemStackFromProvider);
    }

    public void takeItemStackFromProvider(@NotNull ICapabilityProvider provider, int slotIndex) {
        InventoryUtils.transferItemStackIntoNextBestSlotFromProvider(provider, slotIndex, (IItemHandler)this.worker.getInventoryCitizen());
    }

    public boolean checkForToolOrWeapon(@NotNull IToolType toolType) {
        boolean needTool = this.checkForToolOrWeapon(toolType, 0);
        this.worker.getCitizenData().setIdleAtJob(needTool);
        return needTool;
    }

    protected boolean checkForToolOrWeapon(@NotNull IToolType toolType, int minimalLevel) {
        ImmutableList openToolRequests = ((AbstractBuilding)this.getOwnBuilding()).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        ImmutableList completedToolRequests = ((AbstractBuilding)this.getOwnBuilding()).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        if (this.checkForNeededTool(toolType, minimalLevel)) {
            if (openToolRequests.isEmpty() && completedToolRequests.isEmpty()) {
                Tool request = new Tool(toolType, minimalLevel, this.getOwnBuilding().getMaxToolLevel() < minimalLevel ? minimalLevel : this.getOwnBuilding().getMaxToolLevel());
                this.worker.getCitizenData().createRequest(request);
            }
            this.delay = 0;
            return true;
        }
        return false;
    }

    protected void checkForToolorWeaponASync(@NotNull IToolType toolType, int minimalLevel, int maximalLevel) {
        ImmutableList openToolRequests = ((AbstractBuilding)this.getOwnBuilding()).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        ImmutableList completedToolRequests = ((AbstractBuilding)this.getOwnBuilding()).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        if (openToolRequests.isEmpty() && completedToolRequests.isEmpty() && !this.hasOpenToolRequest(toolType)) {
            Tool request = new Tool(toolType, minimalLevel, maximalLevel);
            this.worker.getCitizenData().createRequestAsync(request);
        }
    }

    protected void cancelAsynchRequestForArmor(IToolType armorType) {
        ImmutableList openRequests = ((AbstractBuilding)this.getOwnBuilding()).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.TOOL, iRequest -> ((Tool)iRequest.getRequest()).getToolClass() == armorType);
        for (IRequest token : openRequests) {
            this.worker.getCitizenColonyHandler().getColony().getRequestManager().updateRequestState((IToken<?>)token.getId(), RequestState.CANCELLED);
        }
    }

    private boolean hasOpenToolRequest(IToolType key) {
        return ((AbstractBuilding)this.getOwnBuilding()).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData().getId(), iRequest -> iRequest.getRequest() instanceof Tool && ((Tool)iRequest.getRequest()).getToolClass() == key);
    }

    private boolean checkForNeededTool(@NotNull IToolType toolType, int minimalLevel) {
        int maxToolLevel = this.worker.getCitizenColonyHandler().getWorkBuilding().getMaxToolLevel();
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        if (InventoryUtils.isToolInItemHandler((IItemHandler)inventory, toolType, minimalLevel, maxToolLevel)) {
            return false;
        }
        this.delay += 10;
        return this.walkToBuilding() || !this.retrieveToolInHut(toolType, minimalLevel);
    }

    public boolean retrieveToolInHut(IToolType toolType, int minimalLevel) {
        @Nullable B building = this.getOwnBuilding();
        if (building != null) {
            Predicate<ItemStack> toolPredicate = stack -> ItemStackUtils.hasToolLevel(stack, toolType, minimalLevel, this.getOwnBuilding().getMaxToolLevel());
            for (BlockPos pos : building.getContainers()) {
                TileEntity entity = this.world.func_175625_s(pos);
                if (entity instanceof TileEntityRack) {
                    if (ToolType.NONE.equals(toolType)) {
                        return false;
                    }
                    if (!((TileEntityRack)entity).hasItemStack(toolPredicate) || !InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler((IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null), toolPredicate, (IItemHandler)this.worker.getInventoryCitizen())) continue;
                    return true;
                }
                if (!(entity instanceof ChestTileEntity) || !this.retrieveToolInTileEntity(building.getTileEntity(), toolType, minimalLevel, this.getOwnBuilding().getMaxToolLevel())) continue;
                return true;
            }
        }
        return false;
    }

    protected IBuilding getBuildingToDump() {
        return this.getOwnBuilding();
    }

    @NotNull
    private IAIState dumpInventory() {
        IBuilding building = this.getBuildingToDump();
        if (building == null) {
            return this.afterDump();
        }
        if (!this.worker.isWorkerAtSiteWithMove(building.getPosition(), 4)) {
            this.setDelay(20);
            return AIWorkerState.INVENTORY_FULL;
        }
        if (InventoryUtils.isProviderFull(building)) {
            ICitizenData citizenData = this.worker.getCitizenData();
            if (citizenData != null) {
                citizenData.triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("entity.worker.inventoryfullchestfull"), ChatPriority.IMPORTANT));
            }
            if (building.getPickUpPriority() > 0) {
                building.createPickupRequest(AbstractDeliverymanRequestable.getMaxBuildingPriority(true));
                this.hasDumpedItems = false;
            }
            this.alreadyKept.clear();
            this.slotAt = 0;
            this.clearActionsDone();
            return this.afterDump();
        }
        if (this.dumpOneMoreSlot()) {
            return AIWorkerState.INVENTORY_FULL;
        }
        this.alreadyKept.clear();
        this.slotAt = 0;
        this.clearActionsDone();
        if (this.isAfterDumpPickupAllowed() && building.getPickUpPriority() > 0 && this.hasDumpedItems) {
            building.createPickupRequest(AbstractDeliverymanRequestable.scaledPriority(building.getPickUpPriority()));
            this.hasDumpedItems = false;
        }
        return this.afterDump();
    }

    public IAIState afterDump() {
        if (this.isPaused()) {
            ((AbstractBuilding)this.getOwnBuilding()).onCleanUp(this.worker.getCitizenData());
            return AIWorkerState.PAUSED;
        }
        return AIWorkerState.IDLE;
    }

    private boolean dumpOneMoreSlot() {
        long openSlots;
        if (this.walkToBlock(this.getBuildingToDump().getPosition())) {
            return true;
        }
        @Nullable B buildingWorker = this.getOwnBuilding();
        ItemStack stackToDump = this.worker.getInventoryCitizen().getStackInSlot(this.slotAt);
        int totalSize = this.worker.getInventoryCitizen().getSlots();
        while (stackToDump.func_190926_b()) {
            if (this.slotAt >= totalSize) {
                return false;
            }
            ++this.slotAt;
            stackToDump = this.worker.getInventoryCitizen().getStackInSlot(this.slotAt);
        }
        boolean dumpAnyway = false;
        if ((long)this.slotAt + 10L >= (long)totalSize && (openSlots = InventoryUtils.openSlotCount((IItemHandler)this.worker.getInventoryCitizen())) < 10L) {
            if (stackToDump.func_190916_E() < 16) {
                dumpAnyway = this.worker.func_70681_au().nextBoolean();
            } else {
                boolean bl = dumpAnyway = this.worker.func_70681_au().nextInt(stackToDump.func_190916_E()) < 8;
            }
        }
        if (buildingWorker != null && !ItemStackUtils.isEmpty(stackToDump).booleanValue()) {
            int amount;
            int n = amount = dumpAnyway ? stackToDump.func_190916_E() : buildingWorker.buildingRequiresCertainAmountOfItem(stackToDump, this.alreadyKept, true);
            if (amount > 0) {
                ItemStack activeStack = this.getInventory().extractItem(this.slotAt, amount, false);
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(activeStack, (IItemHandler)this.getBuildingToDump().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null));
                this.hasDumpedItems = true;
            }
        }
        ++this.slotAt;
        return this.slotAt < totalSize;
    }

    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        return new ArrayList<ItemStack>();
    }

    private void clearActionsDone() {
        ((AbstractJob)this.job).clearActionsDone();
    }

    @NotNull
    protected InventoryCitizen getInventory() {
        return this.worker.getInventoryCitizen();
    }

    public final boolean holdEfficientTool(@NotNull BlockState target, BlockPos pos) {
        int bestSlot = this.getMostEfficientTool(target, pos);
        if (bestSlot >= 0) {
            this.worker.getCitizenData().setIdleAtJob(false);
            this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, bestSlot);
            return true;
        }
        this.requestTool(target, pos);
        return false;
    }

    private void requestTool(@NotNull BlockState target, BlockPos pos) {
        IToolType toolType = WorkerUtil.getBestToolForBlock(target, target.func_185887_b((IBlockReader)this.world, pos));
        int required = WorkerUtil.getCorrectHarvestLevelForBlock(target);
        if (this.getOwnBuilding().getMaxToolLevel() < required && this.worker.getCitizenData() != null) {
            this.worker.getCitizenData().triggerInteraction(new PosBasedInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.request.toolow", new Object[]{new ItemStack((IItemProvider)target.func_177230_c()).func_200301_q(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}), ChatPriority.IMPORTANT, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.request.toolow"), pos));
        }
        this.updateToolFlag(toolType, required);
    }

    private void updateToolFlag(@NotNull IToolType toolType, int required) {
        if (ToolType.PICKAXE.equals(toolType)) {
            this.checkForToolOrWeapon(toolType, required);
        } else {
            this.checkForToolOrWeapon(toolType);
        }
    }

    protected int getMostEfficientTool(@NotNull BlockState target, BlockPos pos) {
        IToolType toolType = WorkerUtil.getBestToolForBlock(target, target.func_185887_b((IBlockReader)this.world, pos));
        int required = WorkerUtil.getCorrectHarvestLevelForBlock(target);
        if (toolType == ToolType.NONE) {
            int heldSlot = this.worker.getInventoryCitizen().getHeldItemSlot(Hand.MAIN_HAND);
            return heldSlot >= 0 ? heldSlot : 0;
        }
        int bestSlot = -1;
        int bestLevel = Integer.MAX_VALUE;
        @NotNull InventoryCitizen inventory = this.worker.getInventoryCitizen();
        int maxToolLevel = this.worker.getCitizenColonyHandler().getWorkBuilding().getMaxToolLevel();
        for (int i = 0; i < this.worker.getInventoryCitizen().getSlots(); ++i) {
            ItemStack item = inventory.getStackInSlot(i);
            int level = ItemStackUtils.getMiningLevel(item, toolType);
            if (level <= -1 || level < required || level >= bestLevel || !ItemStackUtils.verifyToolLevel(item, level, required, maxToolLevel)) continue;
            bestSlot = i;
            bestLevel = level;
        }
        return bestSlot;
    }

    protected final boolean hasNotDelayed(int time) {
        if (!this.hasDelayed) {
            this.setDelay(time);
            this.hasDelayed = true;
            return true;
        }
        this.hasDelayed = false;
        return false;
    }

    public final void incrementActionsDoneAndDecSaturation() {
        this.worker.decreaseSaturationForAction();
        this.incrementActionsDone();
    }

    protected final void incrementActionsDone() {
        ((AbstractJob)this.job).incrementActionsDone();
    }

    protected final void resetActionsDone() {
        ((AbstractJob)this.job).clearActionsDone();
    }

    protected final void incrementActionsDone(int numberOfActions) {
        ((AbstractJob)this.job).incrementActionsDone(numberOfActions);
    }

    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        return targetPosition;
    }

    public BlockPos getWorkingPosition(int distance, BlockPos targetPos, int offset) {
        Direction[] directions;
        if (offset > 25) {
            return targetPos;
        }
        for (Direction direction : directions = new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}) {
            @NotNull BlockPos positionInDirection = this.getPositionInDirection(direction, distance + offset, targetPos);
            if (!EntityUtils.checkForFreeSpace(this.world, positionInDirection) || !this.world.func_180495_p(positionInDirection.func_177984_a()).func_177230_c().func_203417_a((ITag)BlockTags.field_200030_g)) continue;
            return positionInDirection;
        }
        return this.getWorkingPosition(distance, targetPos, offset + 1);
    }

    @NotNull
    private BlockPos getPositionInDirection(Direction facing, int distance, BlockPos targetPos) {
        return BlockPosUtil.getFloor(targetPos.func_177967_a(facing, distance), this.world);
    }

    public boolean checkIfRequestForItemExistOrCreate(ItemStack ... stacks) {
        return this.checkIfRequestForItemExistOrCreate(Lists.newArrayList((Object[])stacks));
    }

    public boolean checkIfRequestForItemExistOrCreate(@NotNull Collection<ItemStack> stacks) {
        return stacks.stream().allMatch(this::checkIfRequestForItemExistOrCreate);
    }

    public boolean checkIfRequestForItemExistOrCreate(@NotNull ItemStack stack) {
        return this.checkIfRequestForItemExistOrCreate(stack, stack.func_190916_E(), stack.func_190916_E());
    }

    public boolean checkIfRequestForItemExistOrCreate(@NotNull ItemStack stack, int count, int minCount) {
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), s -> ItemStackUtils.compareItemStacksIgnoreStackSize(s, stack))) {
            return true;
        }
        if (((AbstractBuilding)this.getOwnBuilding()).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(stack)).isEmpty() && ((AbstractBuilding)this.getOwnBuilding()).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(stack)).isEmpty()) {
            Stack stackRequest = new Stack(stack, count, minCount);
            this.worker.getCitizenData().createRequest(stackRequest);
        }
        return false;
    }

    public boolean checkIfRequestForItemExistOrCreateAsynch(ItemStack ... stacks) {
        return this.checkIfRequestForItemExistOrCreateAsynch(Lists.newArrayList((Object[])stacks));
    }

    public boolean checkIfRequestForItemExistOrCreateAsynch(@NotNull Collection<ItemStack> stacks) {
        return stacks.stream().allMatch(this::checkIfRequestForItemExistOrCreateAsynch);
    }

    public boolean checkIfRequestForItemExistOrCreateAsynch(@NotNull ItemStack stack) {
        return this.checkIfRequestForItemExistOrCreateAsynch(stack, stack.func_190916_E(), stack.func_190916_E());
    }

    public boolean checkIfRequestForItemExistOrCreateAsynch(@NotNull ItemStack stack, int count, int minCount) {
        return this.checkIfRequestForItemExistOrCreateAsynch(stack, count, minCount, true);
    }

    public boolean checkIfRequestForItemExistOrCreateAsynch(@NotNull ItemStack stack, int count, int minCount, boolean matchNBT) {
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), s -> ItemStackUtils.compareItemStacksIgnoreStackSize(s, stack) != false && s.func_190916_E() >= stack.func_190916_E())) {
            return true;
        }
        if (InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, true, matchNBT)) >= minCount && InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.getOwnBuilding(), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, true, matchNBT), stack.func_190916_E(), (IItemHandler)this.worker.getInventoryCitizen())) {
            return true;
        }
        if (((AbstractBuilding)this.getOwnBuilding()).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(stack)).isEmpty() && ((AbstractBuilding)this.getOwnBuilding()).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(stack)).isEmpty()) {
            Stack stackRequest = new Stack(stack, count, minCount, matchNBT);
            this.worker.getCitizenData().createRequestAsync(stackRequest);
        }
        return false;
    }

    public boolean checkIfRequestForTagExistOrCreateAsynch(@NotNull ITag<Item> tag, int count) {
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> stack.func_77973_b().func_206844_a(tag) && stack.func_190916_E() >= count)) {
            return true;
        }
        if (InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), itemStack -> itemStack.func_77973_b().func_206844_a(tag)) >= count && InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.getOwnBuilding(), itemStack -> itemStack.func_77973_b().func_206844_a(tag), count, (IItemHandler)this.worker.getInventoryCitizen())) {
            return true;
        }
        if (((AbstractBuilding)this.getOwnBuilding()).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.TAG_REQUEST, r -> ((Tag)r.getRequest()).getTag().equals((Object)tag)).isEmpty() && ((AbstractBuilding)this.getOwnBuilding()).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.TAG_REQUEST, r -> ((Tag)r.getRequest()).getTag().equals((Object)tag)).isEmpty()) {
            Tag tagRequest = new Tag(tag, count);
            this.worker.getCitizenData().createRequestAsync(tagRequest);
        }
        return false;
    }

    private boolean tryTransferFromPosToWorkerIfNeeded(BlockPos pos, @NotNull Tuple<Predicate<ItemStack>, Integer> predicate) {
        TileEntity entity = this.world.func_175625_s(pos);
        if (entity == null) {
            return true;
        }
        int existingAmount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate.getA());
        if (predicate.getB() <= existingAmount) {
            return true;
        }
        int amount = predicate.getB() - existingAmount;
        InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandlerWithResult((ICapabilityProvider)entity, predicate.getA(), amount, (IItemHandler)this.worker.getInventoryCitizen());
        existingAmount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate.getA());
        return existingAmount >= predicate.getB();
    }

    private boolean isPaused() {
        return this.worker.getCitizenData().isPaused();
    }

    private boolean isStartingPaused() {
        return this.isPaused() && this.getState() != AIWorkerState.PAUSED && this.getState() != AIWorkerState.INVENTORY_FULL;
    }

    private IAIState bePaused() {
        if (!this.worker.getNavigation().func_75500_f()) {
            return null;
        }
        int percent = this.worker.func_70681_au().nextInt(100);
        if (percent < 8) {
            this.worker.getNavigation().tryMoveToBlockPos(((AbstractSchematicProvider)this.getOwnBuilding()).getPosition(), this.worker.func_70681_au().nextBoolean() ? 0.8999999999999999 : 1.32);
        } else if (percent < 35) {
            this.worker.getNavigation().moveToRandomPos(10.0, 0.6);
        }
        return null;
    }

    private boolean shouldRestart() {
        return this.worker.getCitizenData().shouldRestart() && this.isPaused();
    }

    private IAIState restart() {
        ((AbstractBuilding)this.getOwnBuilding()).onCleanUp(this.worker.getCitizenData());
        ((AbstractBuilding)this.getOwnBuilding()).onRestart(this.worker.getCitizenData());
        this.setDelay(20);
        this.worker.getCitizenData().restartDone();
        return AIWorkerState.INIT;
    }

    public int getExceptionTimer() {
        return this.exceptionTimer;
    }
}

