/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.coremod.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import com.minecolonies.coremod.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.RenderHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class HerderRecipeCategory
extends JobBasedRecipeCategory<HerdingRecipe> {
    private final AnimalHerdingModule herding;
    private final ITickTimer animalTimer;
    private static final int LOOT_SLOTS_X = 53;
    private static final int LOOT_SLOTS_W = 114;
    private static final int ANIMAL_W = 60;
    private static final int ANIMAL_H = 61;
    private static final int ANIMAL_X = 78;
    private static final int ANIMAL_Y = 26;

    public HerderRecipeCategory(@NotNull BuildingEntry building, @NotNull IJob<?> job, @NotNull AnimalHerdingModule herding, @NotNull IGuiHelper guiHelper) {
        super(job, job.getJobRegistryEntry().getRegistryName(), HerderRecipeCategory.getCatalyst(building), guiHelper);
        this.herding = herding;
        this.animalTimer = guiHelper.createTickTimer(200, 359, false);
    }

    @NotNull
    public Class<? extends HerdingRecipe> getRecipeClass() {
        return HerdingRecipe.class;
    }

    @Override
    @NotNull
    protected List<ITextComponent> generateInfoBlocks(@NotNull HerdingRecipe recipe) {
        return Collections.emptyList();
    }

    public void setIngredients(@NotNull HerdingRecipe recipe, @NotNull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getBreedingItems()));
        ingredients.setOutputLists(VanillaTypes.ITEM, new ArrayList(recipe.getDrops().stream().map(LootTableAnalyzer.LootDrop::getItemStacks).collect(Collectors.toList())));
    }

    public void setRecipe(@NotNull IRecipeLayout layout, @NotNull HerdingRecipe recipe, @NotNull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, true, 149, 26);
        guiItemStacks.setBackground(0, (IDrawable)this.slot);
        guiItemStacks.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        if (!recipe.getDrops().isEmpty()) {
            int startX;
            int initialColumns = 114 / this.slot.getWidth();
            int rows = (recipe.getDrops().size() + initialColumns - 1) / initialColumns;
            int columns = (recipe.getDrops().size() + rows - 1) / rows;
            int x = startX = 53 + (114 - columns * this.slot.getWidth()) / 2;
            int y = 117 - rows * this.slot.getHeight() + 1;
            int c = 0;
            int slot = 1;
            guiItemStacks.addTooltipCallback((ITooltipCallback)new JobBasedRecipeCategory.LootTableTooltipCallback(slot, recipe.getDrops()));
            for (LootTableAnalyzer.LootDrop drop : recipe.getDrops()) {
                guiItemStacks.init(slot, true, x, y);
                guiItemStacks.setBackground(slot, (IDrawable)this.chanceSlot);
                guiItemStacks.set(slot, drop.getItemStacks());
                ++slot;
                if (++c >= columns) {
                    c = 0;
                    x = startX;
                    y += this.slot.getHeight();
                    continue;
                }
                x += this.slot.getWidth();
            }
        }
    }

    @Override
    public void draw(@NotNull HerdingRecipe recipe, @NotNull MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw(recipe, matrixStack, mouseX, mouseY);
        LivingEntity animal = recipe.getAnimal();
        if (animal != null) {
            float scale = 25.416666f;
            int animal_cx = 108;
            int animal_cy = 56;
            int animal_by = 87;
            int offsetY = 16;
            float yaw = this.animalTimer.getValue();
            float headYaw = (float)Math.atan((108.0 - mouseX) / 40.0) * 40.0f + yaw;
            float pitch = (float)Math.atan((40.0 - mouseY) / 40.0) * 20.0f;
            RenderHelper.scissor(matrixStack, 78, 26, 60, 61);
            RenderHelper.renderEntity(matrixStack, 108, 71, 25.41666603088379, headYaw, yaw, pitch, animal);
            RenderHelper.stopScissor();
        }
    }

    @Override
    @NotNull
    public Collection<?> findRecipes(@NotNull Map<IRecipeType<?>, List<IGenericRecipe>> vanilla) {
        List<ItemStack> breedingItems = this.herding.getBreedingItems();
        List<LootTableAnalyzer.LootDrop> drops = this.herding.getExpectedLoot();
        drops.sort(Comparator.comparing(LootTableAnalyzer.LootDrop::getProbability).reversed());
        HerdingRecipe recipe = new HerdingRecipe(this.herding.getAnimalType(), breedingItems, drops);
        return Collections.singletonList(recipe);
    }

    public static class HerdingRecipe {
        @Nullable
        private final LivingEntity animal;
        @NotNull
        private final List<ItemStack> breedingItems;
        @NotNull
        private final List<LootTableAnalyzer.LootDrop> drops;

        public HerdingRecipe(@NotNull EntityType<?> animalType, @NotNull List<ItemStack> breedingItems, @NotNull List<LootTableAnalyzer.LootDrop> drops) {
            this.animal = (LivingEntity)animalType.func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
            this.breedingItems = breedingItems;
            this.drops = drops.size() > 18 ? LootTableAnalyzer.consolidate(drops) : drops;
        }

        @Nullable
        public LivingEntity getAnimal() {
            return this.animal;
        }

        @NotNull
        public List<ItemStack> getBreedingItems() {
            return this.breedingItems;
        }

        @NotNull
        public List<LootTableAnalyzer.LootDrop> getDrops() {
            return this.drops;
        }
    }
}

