/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.entity.pathfinding.Node;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.coremod.network.messages.client.SyncPathMessage;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class CommandCitizenTrack
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        Entity sender = ((CommandSource)context.getSource()).func_197022_f();
        if (!(sender instanceof PlayerEntity)) {
            return 1;
        }
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (RegistryKey<World>)(sender == null ? World.field_234918_g_ : ((CommandSource)context.getSource()).func_197023_e().func_234923_W_()));
        if (colony == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.notfound", (Object[])new Object[0]), true);
            return 0;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.notloaded", (Object[])new Object[0]), true);
            return 0;
        }
        AbstractEntityCitizen entityCitizen = optionalEntityCitizen.get();
        if (AbstractPathJob.trackingMap.getOrDefault((PlayerEntity)sender, UUID.randomUUID()).equals(entityCitizen.func_110124_au())) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizentrack.success.disable", (Object[])new Object[0]), true);
            AbstractPathJob.trackingMap.remove((PlayerEntity)sender);
            Network.getNetwork().sendToPlayer(new SyncPathMessage(new HashSet<Node>(), new HashSet<Node>(), new HashSet<Node>()), (ServerPlayerEntity)sender);
        } else {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizentrack.success.enable", (Object[])new Object[0]), true);
            AbstractPathJob.trackingMap.put((PlayerEntity)sender, entityCitizen.func_110124_au());
        }
        return 1;
    }

    @Override
    public String getName() {
        return "trackPath";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute)));
    }
}

