/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class CommandCitizenList
implements IMCColonyOfficerCommand {
    private static final String LIST_COMMAND_SUGGESTED = "/minecolonies citizens list %d %d";
    private static final String COMMAND_CITIZEN_INFO = "/minecolonies citizens info %d %d";
    private static final int CITIZENS_ON_PAGE = 9;

    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        return this.displayListFor(context, 1);
    }

    private int executeWithPage(CommandContext<CommandSource> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        return this.displayListFor(context, IntegerArgumentType.getInteger(context, (String)"startpage"));
    }

    private int displayListFor(CommandContext<CommandSource> context, int page) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (RegistryKey<World>)((CommandSource)context.getSource()).func_197023_e().func_234923_W_());
        if (colony == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        List<ICitizenData> citizens = colony.getCitizenManager().getCitizens();
        int citizenCount = citizens.size();
        int halfPage = citizenCount % 9 == 0 ? 0 : 1;
        int pageCount = citizenCount / 9 + halfPage;
        if (page < 1 || page > pageCount) {
            page = 1;
        }
        int pageStartIndex = 9 * (page - 1);
        int pageStopIndex = Math.min(9 * page, citizenCount);
        List<ICitizenData> citizensPage = this.getCitizensOnPage(citizens, citizenCount, pageStartIndex, pageStopIndex);
        IFormattableTextComponent headerLine = LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizenlist.pagetop", (Object[])new Object[]{page, pageCount});
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)headerLine, true);
        this.drawCitizens(context, citizensPage);
        CommandCitizenList.drawPageSwitcher(context, page, citizenCount, halfPage, colony.getID());
        return 1;
    }

    @NotNull
    private List<ICitizenData> getCitizensOnPage(List<ICitizenData> citizens, int citizenCount, int pageStartIndex, int pageStopIndex) {
        List<ICitizenData> citizensPage = pageStartIndex < 0 || pageStartIndex >= citizenCount ? new ArrayList<ICitizenData>() : citizens.subList(pageStartIndex, pageStopIndex);
        return citizensPage;
    }

    private void drawCitizens(@NotNull CommandContext<CommandSource> context, List<ICitizenData> citizensPage) {
        for (ICitizenData citizen : citizensPage) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.desc", (Object[])new Object[]{citizen.getId(), citizen.getName()}).func_230530_a_(Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(COMMAND_CITIZEN_INFO, citizen.getColony().getID(), citizen.getId())))), true);
            citizen.getEntity().ifPresent(entityCitizen -> {
                BlockPos position = entityCitizen.func_233580_cy_();
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.pos", (Object[])new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()}), true);
            });
        }
    }

    private static void drawPageSwitcher(@NotNull CommandContext<CommandSource> context, int page, int count, int halfPage, int colonyId) {
        int prevPage = Math.max(0, page - 1);
        int nextPage = Math.min(page + 1, count / 9 + halfPage);
        IFormattableTextComponent prevButton = LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizenlist.prev", (Object[])new Object[0]).func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.GOLD).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(LIST_COMMAND_SUGGESTED, colonyId, prevPage))));
        IFormattableTextComponent nextButton = LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizenlist.next", (Object[])new Object[0]).func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.GOLD).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(LIST_COMMAND_SUGGESTED, colonyId, nextPage))));
        IFormattableTextComponent beginLine = LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizenlist.pageline", (Object[])new Object[0]);
        IFormattableTextComponent endLine = LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizenlist.pageline", (Object[])new Object[0]);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)beginLine.func_230529_a_((ITextComponent)prevButton).func_230529_a_((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizenlist.pagestyle", (Object[])new Object[0])).func_230529_a_((ITextComponent)nextButton).func_230529_a_((ITextComponent)endLine), true);
    }

    @Override
    public String getName() {
        return "list";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(((RequiredArgumentBuilder)IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute)).then(IMCCommand.newArgument("startpage", IntegerArgumentType.integer((int)1)).executes(this::executeWithPage)));
    }
}

