/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class CommandCitizenInfo
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        Entity sender = ((CommandSource)context.getSource()).func_197022_f();
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (RegistryKey<World>)(sender == null ? World.field_234918_g_ : ((CommandSource)context.getSource()).func_197023_e().func_234923_W_()));
        if (colony == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.notfound", (Object[])new Object[0]), true);
            return 0;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.notloaded", (Object[])new Object[0]), true);
            return 0;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.desc", (Object[])new Object[]{citizenData.getId(), citizenData.getName()}), true);
        AbstractEntityCitizen entityCitizen = optionalEntityCitizen.get();
        BlockPos citizenPosition = entityCitizen.func_233580_cy_();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.pos", (Object[])new Object[]{citizenPosition.func_177958_n(), citizenPosition.func_177956_o(), citizenPosition.func_177952_p()}), true);
        BlockPos homePosition = entityCitizen.func_213384_dI();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.homepos", (Object[])new Object[]{homePosition.func_177958_n(), homePosition.func_177956_o(), homePosition.func_177952_p()}), true);
        if (entityCitizen.getCitizenColonyHandler().getWorkBuilding() == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.workposnull", (Object[])new Object[0]), true);
        } else {
            BlockPos workingPosition = entityCitizen.getCitizenColonyHandler().getWorkBuilding().getPosition();
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.workpos", (Object[])new Object[]{workingPosition.func_177958_n(), workingPosition.func_177956_o(), workingPosition.func_177952_p()}), true);
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.health", (Object[])new Object[]{Float.valueOf(entityCitizen.func_110143_aJ()), Float.valueOf(entityCitizen.func_110138_aP())}), true);
        Object[] skills = new Object[]{citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Athletics).func_76341_a(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Dexterity).func_76341_a(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Strength).func_76341_a(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Agility).func_76341_a(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Stamina).func_76341_a(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Mana).func_76341_a(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Adaptability).func_76341_a(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Focus).func_76341_a(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Creativity).func_76341_a(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Knowledge).func_76341_a(), citizenData.getCitizenSkillHandler().getSkills().get((Object)Skill.Intelligence).func_76341_a()};
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.skills", (Object[])skills), true);
        if (entityCitizen.getCitizenJobHandler().getColonyJob() == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.jobnull", (Object[])new Object[0]), true);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.noactivity", (Object[])new Object[0]), true);
        } else if (entityCitizen.getCitizenColonyHandler().getWorkBuilding() != null && entityCitizen.getCitizenColonyHandler().getWorkBuilding().hasModule(WorkerBuildingModule.class)) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.job", (Object[])new Object[]{entityCitizen.getCitizenColonyHandler().getWorkBuilding().getFirstModuleOccurance(WorkerBuildingModule.class).getJobEntry().getTranslationKey()}), true);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.activity", (Object[])new Object[]{entityCitizen.getDesiredActivity(), entityCitizen.getCitizenJobHandler().getColonyJob().getNameTagDescription(), ((PrioritizedGoal)entityCitizen.field_70714_bg.func_220888_c().findFirst().get()).func_220772_j().toString()}), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "info";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute)));
    }
}

