/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.resolvers.WarehouseConcreteRequestResolver;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class WarehouseConcreteRequestResolverFactory
implements IRequestResolverFactory<WarehouseConcreteRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";

    @Override
    @NotNull
    public TypeToken<? extends WarehouseConcreteRequestResolver> getFactoryOutputType() {
        return TypeToken.of(WarehouseConcreteRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public WarehouseConcreteRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) throws IllegalArgumentException {
        return new WarehouseConcreteRequestResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN));
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull WarehouseConcreteRequestResolver warehouseConcreteRequestResolver) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a(NBT_TOKEN, (INBT)controller.serialize(warehouseConcreteRequestResolver.getId()));
        compound.func_218657_a(NBT_LOCATION, (INBT)controller.serialize(warehouseConcreteRequestResolver.getLocation()));
        return compound;
    }

    @Override
    @NotNull
    public WarehouseConcreteRequestResolver deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        IToken token = (IToken)controller.deserialize(nbt.func_74775_l(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.func_74775_l(NBT_LOCATION));
        return new WarehouseConcreteRequestResolver(location, token);
    }

    @Override
    public void serialize(IFactoryController controller, WarehouseConcreteRequestResolver input, PacketBuffer packetBuffer) {
        controller.serialize(packetBuffer, input.getId());
        controller.serialize(packetBuffer, input.getLocation());
    }

    @Override
    public WarehouseConcreteRequestResolver deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
        IToken token = (IToken)controller.deserialize(buffer);
        ILocation location = (ILocation)controller.deserialize(buffer);
        return new WarehouseConcreteRequestResolver(location, token);
    }

    @Override
    public short getSerializationId() {
        return 18;
    }
}

