/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.permissions;

import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.OldRank;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.network.PacketUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Permissions
implements IPermissions {
    private static final String TAG_OWNERS = "owners";
    private static final String TAG_ID = "id";
    private static final String TAG_RANK = "rank";
    private static final String TAG_PERMISSIONS = "permissionMap";
    private static final String TAG_FLAGS = "flags";
    private static final String TAG_OWNER = "owner";
    private static final String TAG_OWNER_ID = "ownerid";
    private static final String TAG_FULLY_ABANDONED = "fully_abandoned";
    private static final String TAG_RANKS = "ranks";
    private static final String TAG_SUBSCRIBER = "is_subscriber";
    private static final String TAG_INITIAL = "is_initial";
    private static final String TAG_COLONY_MANAGER = "is_colony_manager";
    private static final String TAG_HOSTILE = "is_hostile";
    private static final String TAG_VERSION = "permissionVersion";
    private final Map<Integer, Rank> ranks = new LinkedHashMap<Integer, Rank>();
    private static int fullyAbandonedPermissionsFlag = 0;
    @NotNull
    private final Colony colony;
    @NotNull
    private final Map<UUID, Player> players = new HashMap<UUID, Player>();
    private boolean dirty = false;
    private String ownerName = "";
    private UUID ownerUUID = null;
    private boolean fullyAbandoned = false;
    private static final int permissionsVersion = 4;

    public Permissions(@NotNull Colony colony) {
        this.clearDirty();
        this.colony = colony;
        this.loadRanks();
    }

    private void loadRanks() {
        this.ranks.clear();
        block7: for (OldRank oldRank : OldRank.values()) {
            String name = oldRank.name();
            name = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1).toLowerCase(Locale.ENGLISH);
            Rank rank = new Rank(oldRank.ordinal(), name, oldRank.isSubscriber, true);
            this.ranks.put(rank.getId(), rank);
            switch (oldRank) {
                case OWNER: {
                    rank.addPermission(Action.EDIT_PERMISSIONS);
                    rank.addPermission(Action.MAP_BORDER);
                    rank.addPermission(Action.MAP_DEATHS);
                }
                case OFFICER: {
                    rank.addPermission(Action.PLACE_HUTS);
                    rank.addPermission(Action.BREAK_HUTS);
                    rank.addPermission(Action.MANAGE_HUTS);
                    rank.addPermission(Action.RECEIVE_MESSAGES);
                    rank.addPermission(Action.PLACE_BLOCKS);
                    rank.addPermission(Action.BREAK_BLOCKS);
                    rank.addPermission(Action.FILL_BUCKET);
                    rank.addPermission(Action.OPEN_CONTAINER);
                    rank.addPermission(Action.RECEIVE_MESSAGES_FAR_AWAY);
                    rank.addPermission(Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY);
                    rank.addPermission(Action.RALLY_GUARDS);
                    rank.addPermission(Action.MAP_BORDER);
                    rank.addPermission(Action.MAP_DEATHS);
                    rank.setColonyManager(true);
                }
                case FRIEND: {
                    rank.addPermission(Action.ACCESS_HUTS);
                    rank.addPermission(Action.USE_SCAN_TOOL);
                    rank.addPermission(Action.TOSS_ITEM);
                    rank.addPermission(Action.PICKUP_ITEM);
                    rank.addPermission(Action.RIGHTCLICK_BLOCK);
                    rank.addPermission(Action.RIGHTCLICK_ENTITY);
                    rank.addPermission(Action.THROW_POTION);
                    rank.addPermission(Action.SHOOT_ARROW);
                    rank.addPermission(Action.ATTACK_CITIZEN);
                    rank.addPermission(Action.ATTACK_ENTITY);
                    rank.addPermission(Action.TELEPORT_TO_COLONY);
                    rank.addPermission(Action.MAP_BORDER);
                }
                case NEUTRAL: {
                    rank.addPermission(Action.ACCESS_FREE_BLOCKS);
                    rank.addPermission(Action.MAP_BORDER);
                    continue block7;
                }
                case HOSTILE: {
                    rank.addPermission(Action.GUARDS_ATTACK);
                    rank.addPermission(Action.HURT_CITIZEN);
                    rank.addPermission(Action.HURT_VISITOR);
                    rank.addPermission(Action.MAP_BORDER);
                    rank.setHostile(true);
                    continue block7;
                }
            }
        }
    }

    private void upgradePermissions(int version, Rank rank) {
        if (version < 4) {
            if (rank.isHostile()) {
                this.setPermission(rank, Action.HURT_CITIZEN, true);
                this.setPermission(rank, Action.HURT_VISITOR, true);
            }
            if (rank.isColonyManager()) {
                this.setPermission(rank, Action.MAP_DEATHS, true);
            }
            this.setPermission(rank, Action.MAP_BORDER, true);
        }
        if (rank == this.getRankOwner()) {
            rank.addPermission(Action.EDIT_PERMISSIONS);
            rank.addPermission(Action.ACCESS_HUTS);
            rank.addPermission(Action.MANAGE_HUTS);
        }
    }

    @Override
    public final boolean setPermission(Rank rank, @NotNull Action action, boolean enable) {
        boolean changed = enable ? rank.addPermission(action) : rank.removePermission(action);
        if (changed) {
            this.markDirty();
        }
        return changed;
    }

    private void markDirty() {
        this.dirty = true;
        if (this.colony != null) {
            this.colony.markDirty();
        }
    }

    @Override
    public boolean alterPermission(Rank actor, Rank rank, @NotNull Action action, boolean enable) {
        if (!this.canAlterPermission(actor, rank, action)) {
            return false;
        }
        return this.setPermission(rank, action, enable);
    }

    @Override
    public boolean canAlterPermission(Rank actor, Rank rank, @NotNull Action action) {
        if (rank == this.getRankOwner() && actor != this.getRankOwner()) {
            return false;
        }
        return this.hasPermission(actor, Action.EDIT_PERMISSIONS) && (actor != rank || action != Action.EDIT_PERMISSIONS && action != Action.MANAGE_HUTS && action != Action.ACCESS_HUTS);
    }

    public void loadPermissions(@NotNull CompoundNBT compound) {
        String name;
        int version = compound.func_74762_e(TAG_VERSION);
        if (compound.func_74764_b(TAG_RANKS)) {
            this.ranks.clear();
            ListNBT rankTagList = compound.func_150295_c(TAG_RANKS, 10);
            for (int i = 0; i < rankTagList.size(); ++i) {
                CompoundNBT rankCompound = rankTagList.func_150305_b(i);
                int id = rankCompound.func_74762_e(TAG_ID);
                name = rankCompound.func_74779_i("name");
                boolean isSubscriber = rankCompound.func_74767_n(TAG_SUBSCRIBER);
                boolean isInitial = rankCompound.func_74767_n(TAG_INITIAL);
                boolean isColonyManager = rankCompound.func_74767_n(TAG_COLONY_MANAGER);
                boolean isHostile = rankCompound.func_74767_n(TAG_HOSTILE);
                Rank rank = new Rank(id, 0L, name, isSubscriber, isInitial, isColonyManager, isHostile);
                this.ranks.put(id, rank);
                this.upgradePermissions(version, rank);
            }
            ListNBT permissionsTagList = compound.func_150295_c(TAG_PERMISSIONS, 10);
            for (int i = 0; i < permissionsTagList.size(); ++i) {
                CompoundNBT permissionsCompound = permissionsTagList.func_150305_b(i);
                Rank rank = this.ranks.get(permissionsCompound.func_74762_e(TAG_RANK));
                if (rank == null) continue;
                ListNBT flagsTagList = permissionsCompound.func_150295_c(TAG_FLAGS, 8);
                for (int j = 0; j < flagsTagList.size(); ++j) {
                    String flag = flagsTagList.func_150307_f(j);
                    try {
                        rank.addPermission(Action.valueOf(flag));
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        } else {
            this.loadRanks();
        }
        this.players.clear();
        ListNBT ownerTagList = compound.func_150295_c(TAG_OWNERS, 10);
        for (int i = 0; i < ownerTagList.size(); ++i) {
            Rank rank;
            CompoundNBT ownerCompound = ownerTagList.func_150305_b(i);
            @NotNull UUID id = UUID.fromString(ownerCompound.func_74779_i(TAG_ID));
            name = "";
            if (ownerCompound.func_150296_c().contains("name")) {
                name = ownerCompound.func_74779_i("name");
            }
            if (version >= 3) {
                rank = this.ranks.get(ownerCompound.func_74762_e(TAG_RANK));
            } else {
                OldRank oldRank = OldRank.valueOf(ownerCompound.func_74779_i(TAG_RANK));
                rank = this.ranks.get(oldRank.ordinal());
            }
            GameProfile player = ServerLifecycleHooks.getCurrentServer().func_152358_ax().func_152652_a(id);
            if (player != null && rank != null) {
                this.players.put(id, new Player(id, player.getName(), rank));
                continue;
            }
            if (name.isEmpty() || rank == null) continue;
            this.players.put(id, new Player(id, name, rank));
        }
        if (compound.func_74764_b(TAG_OWNER)) {
            this.ownerName = compound.func_74779_i(TAG_OWNER);
        }
        if (compound.func_74764_b(TAG_OWNER_ID)) {
            try {
                this.ownerUUID = UUID.fromString(compound.func_74779_i(TAG_OWNER_ID));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (compound.func_74764_b(TAG_FULLY_ABANDONED)) {
            this.fullyAbandoned = compound.func_74767_n(TAG_FULLY_ABANDONED);
        } else {
            this.checkFullyAbandoned();
        }
        this.restoreOwnerIfNull();
    }

    @Override
    public void restoreOwnerIfNull() {
        GameProfile player;
        Map.Entry<UUID, Player> owner = this.getOwnerEntry();
        if (owner == null && this.ownerUUID != null && (player = ServerLifecycleHooks.getCurrentServer().func_152358_ax().func_152652_a(this.ownerUUID)) != null) {
            this.players.put(this.ownerUUID, new Player(this.ownerUUID, player.getName(), this.ranks.get(0)));
        }
    }

    @Override
    @Nullable
    public Map.Entry<UUID, Player> getOwnerEntry() {
        for (Map.Entry<UUID, Player> entry : this.players.entrySet()) {
            if (entry.getValue().getRank().getId() != 0) continue;
            return entry;
        }
        return null;
    }

    @Override
    public boolean setOwner(PlayerEntity player) {
        this.players.remove(this.getOwner());
        this.ownerName = player.func_200200_C_().getString();
        this.ownerUUID = player.func_110124_au();
        this.players.put(this.ownerUUID, new Player(this.ownerUUID, player.func_200200_C_().getString(), this.ranks.get(0)));
        this.fullyAbandoned = false;
        this.markDirty();
        return true;
    }

    @Override
    public void setOwnerAbandoned() {
        this.players.remove(this.getOwner());
        this.ownerName = "[abandoned]";
        this.ownerUUID = UUID.randomUUID();
        this.players.put(this.ownerUUID, new Player(this.ownerUUID, this.ownerName, this.ranks.get(0)));
        this.checkFullyAbandoned();
        this.markDirty();
    }

    @Override
    @NotNull
    public UUID getOwner() {
        if (this.ownerUUID == null) {
            Map.Entry<UUID, Player> owner = this.getOwnerEntry();
            if (owner != null) {
                this.ownerUUID = owner.getKey();
            } else {
                this.restoreOwnerIfNull();
            }
        }
        return this.ownerUUID;
    }

    public void savePermissions(@NotNull CompoundNBT compound) {
        @NotNull ListNBT rankTagList = new ListNBT();
        for (Rank rank : this.ranks.values()) {
            @NotNull CompoundNBT rankCompound = new CompoundNBT();
            rankCompound.func_74768_a(TAG_ID, rank.getId());
            rankCompound.func_74778_a("name", rank.getName());
            rankCompound.func_74757_a(TAG_SUBSCRIBER, rank.isSubscriber());
            rankCompound.func_74757_a(TAG_INITIAL, rank.isInitial());
            rankCompound.func_74757_a(TAG_COLONY_MANAGER, rank.isColonyManager());
            rankCompound.func_74757_a(TAG_HOSTILE, rank.isHostile());
            rankTagList.add((Object)rankCompound);
        }
        compound.func_218657_a(TAG_RANKS, (INBT)rankTagList);
        @NotNull ListNBT ownerTagList = new ListNBT();
        for (Player player : this.players.values()) {
            @NotNull CompoundNBT ownersCompound = new CompoundNBT();
            ownersCompound.func_74778_a(TAG_ID, player.getID().toString());
            ownersCompound.func_74778_a("name", player.getName());
            ownersCompound.func_74768_a(TAG_RANK, player.getRank().getId());
            ownerTagList.add((Object)ownersCompound);
        }
        compound.func_218657_a(TAG_OWNERS, (INBT)ownerTagList);
        @NotNull ListNBT listNBT = new ListNBT();
        for (Rank rank : this.ranks.values()) {
            @NotNull CompoundNBT permissionsCompound = new CompoundNBT();
            permissionsCompound.func_74768_a(TAG_RANK, rank.getId());
            @NotNull ListNBT flagsTagList = new ListNBT();
            for (Action action : Action.values()) {
                if (!Utils.testFlag(rank.getPermissions(), action.getFlag())) continue;
                flagsTagList.add((Object)StringNBT.func_229705_a_((String)action.name()));
            }
            permissionsCompound.func_218657_a(TAG_FLAGS, (INBT)flagsTagList);
            listNBT.add((Object)permissionsCompound);
        }
        compound.func_218657_a(TAG_PERMISSIONS, (INBT)listNBT);
        if (!this.ownerName.isEmpty()) {
            compound.func_74778_a(TAG_OWNER, this.ownerName);
        }
        if (this.ownerUUID != null) {
            compound.func_74778_a(TAG_OWNER_ID, this.ownerUUID.toString());
        }
        compound.func_74757_a(TAG_FULLY_ABANDONED, this.fullyAbandoned);
        compound.func_74768_a(TAG_VERSION, 4);
    }

    @Override
    @NotNull
    public Map<UUID, Player> getPlayers() {
        return Collections.unmodifiableMap(this.players);
    }

    @Override
    public boolean hasPermission(Rank rank, @NotNull Action action) {
        return Utils.testFlag(rank.getPermissions(), action.getFlag()) || this.fullyAbandoned && Utils.testFlag(fullyAbandonedPermissionsFlag, action.getFlag());
    }

    @Override
    public Set<Player> getPlayersByRank(Rank rank) {
        return this.players.values().stream().filter(player -> player.getRank() != null && player.getRank().equals(rank)).collect(Collectors.toSet());
    }

    @Override
    public Set<Player> getPlayersByRank(@NotNull Set<Rank> ranks) {
        return this.players.values().stream().filter(player -> ranks.contains(player.getRank())).collect(Collectors.toSet());
    }

    @Override
    public Set<Player> getFilteredPlayers(@NotNull Predicate<Rank> predicate) {
        return this.players.values().stream().filter(player -> predicate.test(player.getRank())).collect(Collectors.toSet());
    }

    @Override
    public boolean hasPermission(@NotNull PlayerEntity player, @NotNull Action action) {
        return this.hasPermission(this.getRank(player), action);
    }

    @Override
    public Rank getRank(@NotNull PlayerEntity player) {
        return this.getRank(player.func_146103_bH().getId());
    }

    @Override
    public boolean setPlayerRank(UUID id, Rank rank, World world) {
        Player player = this.getPlayers().get(id);
        if (player != null) {
            player.setRank(rank);
            if (rank.isColonyManager()) {
                this.fullyAbandoned = false;
            } else {
                this.checkFullyAbandoned();
            }
        } else {
            GameProfile gameprofile = world.func_73046_m().func_152358_ax().func_152652_a(id);
            return gameprofile != null && this.addPlayer(gameprofile, rank);
        }
        this.markDirty();
        return true;
    }

    @Override
    public boolean addPlayer(@NotNull UUID id, String name, Rank rank) {
        @NotNull Player p = new Player(id, name, rank);
        this.players.remove(p.getID());
        this.players.put(p.getID(), p);
        if (rank.getId() == 0 || rank.getId() == 1) {
            this.fullyAbandoned = false;
        }
        this.markDirty();
        return true;
    }

    @Override
    @NotNull
    public Rank getRank(UUID id) {
        Player player = this.players.get(id);
        return player != null ? player.getRank() : this.ranks.get(3);
    }

    @Override
    public boolean addPlayer(@NotNull String player, Rank rank, World world) {
        ServerPlayerEntity playerEntity;
        if (player.isEmpty()) {
            return false;
        }
        GameProfile gameprofile = world.func_73046_m().func_152358_ax().func_152655_a(player);
        if (!world.func_201670_d() && gameprofile != null && (playerEntity = (ServerPlayerEntity)world.func_217371_b(gameprofile.getId())) != null) {
            if (rank.getId() == 1) {
                this.colony.getPackageManager().addImportantColonyPlayer(playerEntity);
                this.colony.getPackageManager().updateSubscribers();
                this.fullyAbandoned = false;
            } else if (rank.getId() == 0) {
                this.fullyAbandoned = false;
            } else {
                Chunk chunk = world.func_212866_a_(playerEntity.field_70176_ah, playerEntity.field_70164_aj);
                IColonyTagCapability colonyCap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
                if (colonyCap != null && colonyCap.getOwningColony() == this.colony.getID() && world.func_234923_W_() == this.colony.getDimension()) {
                    this.colony.getPackageManager().addCloseSubscriber(playerEntity);
                    this.colony.getPackageManager().updateSubscribers();
                }
            }
        }
        return gameprofile != null && !this.ownerUUID.equals(gameprofile.getId()) && this.addPlayer(gameprofile, rank);
    }

    @Override
    public boolean addPlayer(@NotNull GameProfile gameprofile, Rank rank) {
        @NotNull Player p = new Player(gameprofile.getId(), gameprofile.getName(), rank);
        this.players.remove(p.getID());
        this.players.put(p.getID(), p);
        if (rank.getId() == 0 || rank.getId() == 1) {
            this.fullyAbandoned = false;
        }
        this.markDirty();
        return true;
    }

    @Override
    public boolean removePlayer(UUID id) {
        Player player = this.players.get(id);
        if (player != null && player.getRank().getId() != 0 && this.players.remove(id) != null) {
            this.checkFullyAbandoned();
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getOwnerName() {
        Map.Entry<UUID, Player> owner;
        if (this.ownerName.isEmpty() && (owner = this.getOwnerEntry()) != null) {
            this.ownerName = owner.getValue().getName();
        }
        return this.ownerName;
    }

    @Override
    public boolean isSubscriber(@NotNull PlayerEntity player) {
        return this.isSubscriber(player.func_146103_bH().getId());
    }

    private boolean isSubscriber(UUID player) {
        return this.getRank(player).isSubscriber();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public void serializeViewNetworkData(@NotNull PacketBuffer buf, @NotNull Rank viewerRank) {
        buf.func_150787_b(this.ranks.size());
        for (Rank rank : this.ranks.values()) {
            buf.func_150787_b(rank.getId());
            buf.writeLong(rank.getPermissions());
            buf.func_180714_a(rank.getName());
            buf.writeBoolean(rank.isSubscriber());
            buf.writeBoolean(rank.isInitial());
            buf.writeBoolean(rank.isColonyManager());
            buf.writeBoolean(rank.isHostile());
        }
        buf.func_150787_b(viewerRank.getId());
        buf.func_150787_b(this.players.size());
        for (Map.Entry entry : this.players.entrySet()) {
            PacketUtils.writeUUID(buf, (UUID)entry.getKey());
            buf.func_180714_a(((Player)entry.getValue()).getName());
            buf.func_150787_b(((Player)entry.getValue()).getRank().getId());
        }
    }

    @Override
    public boolean isColonyMember(@NotNull PlayerEntity player) {
        return this.players.containsKey(player.func_146103_bH().getId());
    }

    private void checkFullyAbandoned() {
        if (this.getOwnerName().equals("[abandoned]") && this.getPlayersByRank(this.ranks.get(1)).isEmpty()) {
            this.fullyAbandoned = true;
        }
    }

    @Override
    public Rank getRankOwner() {
        return this.ranks.get(0);
    }

    @Override
    public Rank getRankOfficer() {
        return this.ranks.get(1);
    }

    @Override
    public Rank getRankHostile() {
        return this.ranks.get(4);
    }

    @Override
    public Rank getRankFriend() {
        return this.ranks.get(2);
    }

    @Override
    public Rank getRankNeutral() {
        return this.ranks.get(3);
    }

    @Override
    public Rank getRank(int id) {
        return this.ranks.get(id);
    }

    @Override
    public Map<Integer, Rank> getRanks() {
        return this.ranks;
    }

    @Override
    public void addRank(String name) {
        int id = 5;
        for (int i = 4; i <= this.ranks.size() + 1; ++i) {
            if (this.ranks.get(i) != null) continue;
            id = i;
            break;
        }
        Rank rank = new Rank(id, name, false, false);
        this.ranks.put(id, rank);
        this.markDirty();
    }

    @Override
    public void removeRank(Rank rank) {
        if (rank.isInitial()) {
            return;
        }
        for (Player player : this.getPlayersByRank(rank)) {
            player.setRank(this.getRankNeutral());
        }
        this.ranks.remove(rank.getId());
        this.markDirty();
    }

    static {
        for (Action a : Action.values()) {
            if (a == Action.GUARDS_ATTACK || a == Action.EDIT_PERMISSIONS || a == Action.MANAGE_HUTS || a == Action.TELEPORT_TO_COLONY || a == Action.EXPLODE || a == Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY || a == Action.RALLY_GUARDS) continue;
            fullyAbandonedPermissionsFlag = (int)((long)fullyAbandonedPermissionsFlag | a.getFlag());
        }
    }
}

