/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.IResearchManager;
import com.minecolonies.api.research.ResearchBranchType;
import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.effects.IResearchEffectManager;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.research.LocalResearch;
import com.minecolonies.coremod.research.LocalResearchTree;
import com.minecolonies.coremod.research.ResearchEffectManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class ResearchManager
implements IResearchManager {
    private final LocalResearchTree tree = new LocalResearchTree();
    private final IResearchEffectManager effects = new ResearchEffectManager();
    private final List<IGlobalResearch> autoStartResearch = new ArrayList<IGlobalResearch>();
    private final IColony colony;

    @Override
    public void readFromNBT(@NotNull CompoundNBT compound) {
        this.tree.readFromNBT(compound, this.effects);
    }

    @Override
    public void writeToNBT(@NotNull CompoundNBT compound) {
        this.tree.writeToNBT(compound);
    }

    public ResearchManager(IColony colony) {
        this.colony = colony;
        this.autoStartResearch.addAll(MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getAutostartResearches());
    }

    @Override
    public LocalResearchTree getResearchTree() {
        return this.tree;
    }

    @Override
    public IResearchEffectManager getResearchEffects() {
        return this.effects;
    }

    @Override
    public ResourceLocation getResearchEffectIdFrom(Block block) {
        return new ResourceLocation(block.getRegistryName().func_110624_b(), "effects/" + block.getRegistryName().func_110623_a());
    }

    @Override
    public void checkAutoStartResearch() {
        if (this.colony == null || !(this.colony instanceof Colony)) {
            return;
        }
        ArrayList<IGlobalResearch> removes = new ArrayList<IGlobalResearch>();
        for (IGlobalResearch research : this.autoStartResearch) {
            if (!IGlobalResearchTree.getInstance().isResearchRequirementsFulfilled(research.getResearchRequirement(), this.colony)) continue;
            if (IGlobalResearchTree.getInstance().getBranchData(research.getBranch()).getType() != ResearchBranchType.UNLOCKABLES) {
                int level = 0;
                Map<BlockPos, IBuilding> buildings = this.colony.getBuildingManager().getBuildings();
                for (Map.Entry<BlockPos, IBuilding> building : buildings.entrySet()) {
                    if (building.getValue().getBuildingType() != ModBuildings.university || building.getValue().getBuildingLevel() <= level) continue;
                    level = building.getValue().getBuildingLevel();
                }
                if (level < research.getDepth()) continue;
            }
            boolean researchAlreadyRun = false;
            for (ILocalResearch progressResearch : this.colony.getResearchManager().getResearchTree().getResearchInProgress()) {
                if (!progressResearch.getId().equals((Object)research.getId())) continue;
                researchAlreadyRun = true;
                break;
            }
            if (researchAlreadyRun || this.colony.getResearchManager().getResearchTree().hasCompletedResearch(research.getId())) {
                removes.add(research);
                continue;
            }
            if (!research.getCostList().isEmpty()) {
                for (PlayerEntity player : this.colony.getMessagePlayerEntities()) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.available", new Object[]{research.getName()}), player.func_110124_au());
                    SoundUtils.playSuccessSound(player, player.func_233580_cy_());
                }
            } else {
                this.startCostlessResearch(research);
            }
            removes.add(research);
        }
        this.autoStartResearch.removeAll(removes);
    }

    private void startCostlessResearch(IGlobalResearch research) {
        boolean creativePlayer = false;
        for (PlayerEntity playerEntity : this.colony.getMessagePlayerEntities()) {
            if (!playerEntity.func_184812_l_()) continue;
            creativePlayer = true;
        }
        this.tree.addResearch(research.getBranch(), new LocalResearch(research.getId(), research.getBranch(), research.getDepth()));
        if (research.isInstant() || creativePlayer && ((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchCreativeCompletion.get()).booleanValue()) {
            ILocalResearch localResearch = this.tree.getResearch(research.getBranch(), research.getId());
            localResearch.setProgress(IGlobalResearchTree.getInstance().getBranchData(research.getBranch()).getBaseTime(research.getDepth()));
            localResearch.setState(ResearchState.FINISHED);
            this.tree.finishResearch(research.getId());
            for (IResearchEffect<?> iResearchEffect : IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getEffects()) {
                this.effects.applyEffect(iResearchEffect);
            }
            for (ICitizenData iCitizenData : this.colony.getCitizenManager().getCitizens()) {
                iCitizenData.applyResearchEffects();
            }
            TranslationTextComponent translationTextComponent = new TranslationTextComponent("com.minecolonies.coremod.university.researchconcluded." + ThreadLocalRandom.current().nextInt(3), new Object[]{IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getName()});
            for (PlayerEntity player : this.colony.getMessagePlayerEntities()) {
                player.func_145747_a((ITextComponent)translationTextComponent, player.func_110124_au());
                SoundUtils.playSuccessSound(player, player.func_233580_cy_());
            }
        } else {
            for (PlayerEntity playerEntity : this.colony.getMessagePlayerEntities()) {
                playerEntity.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.available", new Object[]{research.getName()}).func_230529_a_((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.started", new Object[]{research.getName()})), playerEntity.func_110124_au());
                SoundUtils.playSuccessSound(playerEntity, playerEntity.func_233580_cy_());
            }
        }
    }
}

