/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingGuardTower;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.AbstractShipRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.HordeRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.amazonevent.AmazonRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.barbarianEvent.BarbarianRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.barbarianEvent.Horde;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.egyptianevent.EgyptianRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.norsemenevent.NorsemenRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.norsemenevent.NorsemenShipRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.PirateGroundRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.PirateRaidEvent;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipBasedRaiderUtils;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipSize;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobRaiderPathing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class RaidManager
implements IRaiderManager {
    public static final double SPAWN_MODIFIER = 60.0;
    private static final int MIN_BUILDING_SPAWN_DIST = 35;
    private static final String DESERT_BIOME_ID = "desert";
    private static final String JUNGLE_BIOME_ID = "jungle";
    private static final String TAIGA_BIOME_ID = "taiga";
    private static final double LOST_CITIZEN_DIFF_REDUCE_PCT = 0.15;
    private static final double LOST_CITIZEN_DIFF_INCREASE_PCT = 0.05;
    private static final int MIN_RAID_DIFFICULTY = 1;
    private static final int MAX_RAID_DIFFICULTY = 14;
    private static final double MIN_DIFFICULTY_MODIFIER = 0.2;
    private static final String TAG_RAID_DIFFICULTY = "difficulty";
    private static final String TAG_LOST_CITIZENS = "lostCitizens";
    private static final int MIN_REQUIRED_RAIDLEVEL = 75;
    private static final int MIN_RAID_BLOCK_DIST_CENTER_SQ = 6400;
    private static final int RAID_SPAWN_SEARCH_CHUNKS = 10;
    private static final double INCREASE_PER_PLAYER = 0.05;
    private static final int IGNORE_BIOME_CHANCE = 2;
    private static final int INITIAL_RAID_DIFFICULTY = 5;
    private int raidDifficulty = 5;
    private boolean raidTonight = false;
    private static boolean INITIAL_CAN_HAVE_BARB_EVENTS = true;
    private boolean haveBarbEvents = INITIAL_CAN_HAVE_BARB_EVENTS;
    private static final int INITIAL_NIGHTS_SINCE_LAST_RAID = 0;
    private int nightsSinceLastRaid = 0;
    private final List<BlockPos> lastSpawnPoints = new ArrayList<BlockPos>();
    private final Colony colony;
    private boolean spiesEnabled;
    private BlockPos lastBuilding;
    private int buildingPosUsage = 0;
    private static final int INITIAL_LOST_CITIZENS = 0;
    private int lostCitizens = 0;
    private static final String INITIAL_NEXT_RAID_TYPE = "";
    private String nextForcedType = "";

    public RaidManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public boolean canHaveRaiderEvents() {
        return this.haveBarbEvents;
    }

    @Override
    public boolean willRaidTonight() {
        return this.raidTonight;
    }

    @Override
    public void setCanHaveRaiderEvents(boolean canHave) {
        this.haveBarbEvents = canHave;
    }

    @Override
    public void addRaiderSpawnPoint(BlockPos pos) {
        this.lastSpawnPoints.add(pos);
    }

    @Override
    public void setRaidNextNight(boolean willRaid) {
        this.raidTonight = willRaid;
    }

    @Override
    public void setRaidNextNight(boolean willRaid, String raidType) {
        this.raidTonight = true;
        this.nextForcedType = raidType;
    }

    @Override
    public boolean areSpiesEnabled() {
        return this.spiesEnabled;
    }

    @Override
    public void setSpiesEnabled(boolean enabled) {
        if (this.spiesEnabled != enabled) {
            this.colony.markDirty();
        }
        this.spiesEnabled = enabled;
    }

    @Override
    public void raiderEvent() {
        this.raiderEvent(INITIAL_NEXT_RAID_TYPE);
    }

    @Override
    public void raiderEvent(String raidType) {
        if (this.colony.getWorld() == null || !this.canRaid() || raidType == null) {
            return;
        }
        int raidLevel = this.getColonyRaidLevel();
        int amount = this.calculateRaiderAmount(raidLevel);
        if (amount <= 0 || raidLevel < 75) {
            return;
        }
        int raidCount = Math.max(1, amount / 20);
        HashSet<BlockPos> spawnPoints = new HashSet<BlockPos>();
        for (int i = 0; i < raidCount; ++i) {
            BlockPos targetSpawnPoint = this.calculateSpawnLocation();
            if (targetSpawnPoint == null || targetSpawnPoint.equals((Object)this.colony.getCenter()) || targetSpawnPoint.func_177956_o() > (Integer)MineColonies.getConfig().getServer().maxYForBarbarians.get() || !this.colony.getWorld().func_175723_af().func_177746_a(targetSpawnPoint)) continue;
            spawnPoints.add(targetSpawnPoint);
        }
        if (spawnPoints.isEmpty()) {
            return;
        }
        this.nightsSinceLastRaid = 0;
        this.raidTonight = false;
        amount = (int)Math.ceil((float)amount / (float)spawnPoints.size());
        for (BlockPos targetSpawnPoint : spawnPoints) {
            AbstractShipRaidEvent event;
            if (((Boolean)MineColonies.getConfig().getServer().enableInDevelopmentFeatures.get()).booleanValue()) {
                LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)("Horde Spawn Point: " + targetSpawnPoint), (Object[])new Object[0]);
            }
            if (this.colony.getWorld().func_180495_p(targetSpawnPoint).func_185904_a() == Material.field_151579_a && this.colony.getWorld().func_180495_p(targetSpawnPoint.func_177977_b()).func_185904_a() == Material.field_151579_a) {
                raidType = PirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.func_110623_a();
            }
            int shipRotation = new Random().nextInt(3);
            String homeBiomePath = this.colony.getWorld().func_226691_t_(this.colony.getCenter()).func_201856_r().func_222352_a();
            int rand = this.colony.getWorld().field_73012_v.nextInt(100);
            if ((raidType.isEmpty() && (homeBiomePath.contains(TAIGA_BIOME_ID) || rand < 2) || raidType.equals(NorsemenRaidEvent.NORSEMEN_RAID_EVENT_TYPE_ID.func_110623_a())) && ShipBasedRaiderUtils.canSpawnShipAt(this.colony, targetSpawnPoint, amount, shipRotation, "norsemen_ship")) {
                event = new NorsemenShipRaidEvent(this.colony);
                event.setSpawnPoint(targetSpawnPoint);
                event.setShipSize(ShipSize.getShipForRaiderAmount(amount));
                event.setShipRotation(shipRotation);
                event.setSpawnPath(this.createSpawnPath(targetSpawnPoint));
                this.colony.getEventManager().addEvent(event);
            } else if (ShipBasedRaiderUtils.canSpawnShipAt(this.colony, targetSpawnPoint, amount, shipRotation, "pirate_ship") && (raidType.isEmpty() || raidType.equals(PirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.func_110623_a()))) {
                event = new PirateRaidEvent(this.colony);
                event.setSpawnPoint(targetSpawnPoint);
                event.setShipSize(ShipSize.getShipForRaiderAmount(amount));
                event.setShipRotation(shipRotation);
                event.setSpawnPath(this.createSpawnPath(targetSpawnPoint));
                this.colony.getEventManager().addEvent(event);
            } else {
                String biomePath = this.colony.getWorld().func_226691_t_(targetSpawnPoint).func_201856_r().func_222352_a().toLowerCase();
                HordeRaidEvent event2 = (biomePath.contains(DESERT_BIOME_ID) || rand > 2 && rand < 4) && raidType.isEmpty() || raidType.equals(EgyptianRaidEvent.EGYPTIAN_RAID_EVENT_TYPE_ID.func_110623_a()) ? new EgyptianRaidEvent(this.colony) : (biomePath.contains(JUNGLE_BIOME_ID) || rand > 4 && rand < 6 && raidType.isEmpty() || raidType.equals(AmazonRaidEvent.AMAZON_RAID_EVENT_TYPE_ID.func_110623_a()) ? new AmazonRaidEvent(this.colony) : ((biomePath.contains(TAIGA_BIOME_ID) || rand > 6 && rand < 8) && raidType.isEmpty() || raidType.equals(NorsemenRaidEvent.NORSEMEN_RAID_EVENT_TYPE_ID.func_110623_a()) ? new NorsemenRaidEvent(this.colony) : (raidType.equals(PirateRaidEvent.PIRATE_RAID_EVENT_TYPE_ID.func_110623_a()) ? new PirateGroundRaidEvent(this.colony) : new BarbarianRaidEvent(this.colony))));
                event2.setSpawnPoint(targetSpawnPoint);
                event2.setHorde(new Horde(amount));
                event2.setSpawnPath(this.createSpawnPath(targetSpawnPoint));
                this.colony.getEventManager().addEvent(event2);
            }
            this.addRaiderSpawnPoint(targetSpawnPoint);
        }
        this.colony.markDirty();
    }

    private PathResult createSpawnPath(BlockPos targetSpawnPoint) {
        BlockPos closestBuildingPos = this.colony.getBuildingManager().getBestBuilding(targetSpawnPoint, IBuilding.class);
        PathJobRaiderPathing job = new PathJobRaiderPathing(new ArrayList<IBuilding>(this.colony.getBuildingManager().getBuildings().values()), this.colony.getWorld(), closestBuildingPos, targetSpawnPoint, 200);
        job.getResult().startJob(Pathfinding.getExecutor());
        return job.getResult();
    }

    @Override
    public BlockPos calculateSpawnLocation() {
        BlockPos locationSum = new BlockPos(0, 0, 0);
        int amount = 0;
        for (IBuilding building : this.colony.getBuildingManager().getBuildings().values()) {
            if (!WorldUtil.isEntityBlockLoaded((IWorld)this.colony.getWorld(), building.getPosition())) continue;
            ++amount;
            locationSum = locationSum.func_177971_a((Vector3i)building.getPosition());
        }
        if (amount == 0) {
            Log.getLogger().info("Trying to spawn raid on colony with no loaded buildings, aborting!");
            return null;
        }
        BlockPos calcCenter = new BlockPos(locationSum.func_177958_n() / amount, locationSum.func_177956_o() / amount, locationSum.func_177952_p() / amount);
        int degree = this.colony.getWorld().field_73012_v.nextInt(360);
        int x = (int)Math.round(500.0 * Math.cos(Math.toRadians(degree)));
        int z = (int)Math.round(500.0 * Math.sin(Math.toRadians(degree)));
        BlockPos advanceTowards = calcCenter.func_177982_a(x, 0, z);
        BlockPos spawnPos = null;
        BlockPos closestBuilding = this.colony.getBuildingManager().getBestBuilding(advanceTowards, IBuilding.class);
        if (closestBuilding == null) {
            return null;
        }
        for (int i = 0; i < 8 && (spawnPos = this.findSpawnPointInDirections(new BlockPos(closestBuilding.func_177958_n(), calcCenter.func_177956_o(), closestBuilding.func_177952_p()), advanceTowards)) == null; ++i) {
        }
        if (spawnPos == null) {
            return null;
        }
        spawnPos = BlockPosUtil.findAround(this.colony.getWorld(), BlockPosUtil.getFloor(spawnPos, this.colony.getWorld()), 3, 30, BlockPosUtil.SOLID_AIR_POS_SELECTOR);
        if (spawnPos == null && ((Boolean)MineColonies.getConfig().getServer().skyRaiders.get()).booleanValue()) {
            spawnPos = BlockPosUtil.findAround(this.colony.getWorld(), BlockPosUtil.getFloor(spawnPos, this.colony.getWorld()), 10, 15, BlockPosUtil.DOUBLE_AIR_POS_SELECTOR);
        }
        return spawnPos;
    }

    private BlockPos findSpawnPointInDirections(BlockPos start, BlockPos advancePos) {
        BlockPos spawnPos = new BlockPos((Vector3i)start);
        BlockPos tempPos = new BlockPos((Vector3i)spawnPos);
        Collection<IBuilding> buildings = this.colony.getBuildingManager().getBuildings().values();
        int xDiff = start.func_177958_n() - advancePos.func_177958_n();
        int zDiff = start.func_177952_p() - advancePos.func_177952_p();
        Vector3d rates = new Vector3d(1.0, 1.0, 1.0);
        rates = xDiff > zDiff ? new Vector3d((double)xDiff / (double)zDiff, 1.0, start.func_177952_p() < advancePos.func_177952_p() ? 1.0 : -1.0) : new Vector3d(start.func_177958_n() < advancePos.func_177958_n() ? 1.0 : -1.0, 1.0, (double)zDiff / (double)xDiff);
        int validChunkCount = 0;
        for (int i = 0; i < 10 && WorldUtil.isEntityBlockLoaded((IWorld)this.colony.getWorld(), tempPos); ++i) {
            tempPos = tempPos.func_177963_a(16.0 * rates.field_72450_a, 0.0, 16.0 * rates.field_72449_c);
            if (!WorldUtil.isEntityBlockLoaded((IWorld)this.colony.getWorld(), tempPos)) break;
            if (!RaidManager.isValidSpawnPoint(buildings, tempPos)) continue;
            spawnPos = tempPos;
            if (++validChunkCount <= 5) continue;
            return spawnPos;
        }
        if (!spawnPos.equals((Object)start)) {
            return spawnPos;
        }
        return null;
    }

    public static boolean isValidSpawnPoint(Collection<IBuilding> buildings, BlockPos spawnPos) {
        for (IBuilding building : buildings) {
            if (building.getBuildingLevel() == 0) continue;
            int minDist = 35;
            minDist = building instanceof BuildingGuardTower ? (minDist += building.getBuildingLevel() * 7) : (building.hasModule(LivingBuildingModule.class) ? (minDist += building.getBuildingLevel() * 4) : (building instanceof BuildingTownHall ? (minDist += building.getBuildingLevel() * 8) : (minDist += building.getBuildingLevel() * 2)));
            if (BlockPosUtil.getDistance2D(building.getPosition(), spawnPos) >= (long)minDist) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<BlockPos> getLastSpawnPoints() {
        return new ArrayList<BlockPos>(this.lastSpawnPoints);
    }

    @Override
    public int calculateRaiderAmount(int raidLevel) {
        return 1 + Math.min((Integer)MineColonies.getConfig().getServer().maxBarbarianSize.get(), (int)((double)raidLevel / 60.0 * this.getRaidDifficultyModifier() * (1.0 + (double)this.colony.getMessagePlayerEntities().size() * 0.05) * (this.colony.getWorld().field_73012_v.nextDouble() * 0.5 + 0.75)));
    }

    @Override
    public boolean isRaided() {
        for (IColonyEvent event : this.colony.getEventManager().getEvents().values()) {
            if (!(event instanceof IColonyRaidEvent) || event.getStatus() != EventStatus.PROGRESSING && event.getStatus() != EventStatus.PREPARING) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onNightFall() {
        if (!this.isRaided()) {
            if (this.nightsSinceLastRaid == 0) {
                double lostPct = (double)this.lostCitizens / (double)this.colony.getCitizenManager().getMaxCitizens();
                if (lostPct > 0.15) {
                    this.raidDifficulty = Math.max(1, this.raidDifficulty - (int)(lostPct / 0.15));
                } else if (lostPct < 0.05) {
                    this.raidDifficulty = Math.min(14, this.raidDifficulty + 1);
                }
            }
            ++this.nightsSinceLastRaid;
            this.lostCitizens = 0;
        } else {
            this.nightsSinceLastRaid = 0;
        }
        if (this.raidTonight) {
            this.raidTonight = false;
            this.raiderEvent(this.nextForcedType);
            this.nextForcedType = INITIAL_NEXT_RAID_TYPE;
        } else {
            this.determineRaidForNextDay();
        }
    }

    @Override
    public int getNightsSinceLastRaid() {
        return this.nightsSinceLastRaid;
    }

    @Override
    public void setNightsSinceLastRaid(int nightsSinceLastRaid) {
        this.nightsSinceLastRaid = nightsSinceLastRaid;
    }

    @Override
    public boolean canRaid() {
        return !WorldUtil.isPeaceful(this.colony.getWorld()) && (Boolean)MineColonies.getConfig().getServer().doBarbariansSpawn.get() != false && this.colony.getRaiderManager().canHaveRaiderEvents() && !this.colony.getPackageManager().getImportantColonyPlayers().isEmpty();
    }

    private void determineRaidForNextDay() {
        boolean raid;
        boolean bl = raid = this.canRaid() && (this.raidThisNight(this.colony.getWorld(), this.colony) || this.colony.getWorld().func_226691_t_(this.colony.getCenter()).func_201856_r().func_222352_a().contains(DESERT_BIOME_ID) && this.colony.getWorld().func_72896_J());
        if (((Boolean)MineColonies.getConfig().getServer().enableInDevelopmentFeatures.get()).booleanValue()) {
            LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)("Will raid tomorrow: " + raid), (Object[])new Object[0]);
        }
        this.setRaidNextNight(raid);
    }

    @Override
    public int getColonyRaidLevel() {
        int levels = this.colony.getCitizenManager().getCitizens().size() * 10;
        for (IBuilding building : this.colony.getBuildingManager().getBuildings().values()) {
            levels += building.getBuildingLevel() * 2;
        }
        return levels;
    }

    private boolean raidThisNight(World world, IColony colony) {
        if (this.nightsSinceLastRaid < (Integer)MineColonies.getConfig().getServer().minimumNumberOfNightsBetweenRaids.get()) {
            return false;
        }
        if (this.nightsSinceLastRaid > (Integer)MineColonies.getConfig().getServer().averageNumberOfNightsBetweenRaids.get() + 2) {
            return true;
        }
        return world.field_73012_v.nextDouble() < 1.0 / (double)((Integer)MineColonies.getConfig().getServer().averageNumberOfNightsBetweenRaids.get() - (Integer)MineColonies.getConfig().getServer().minimumNumberOfNightsBetweenRaids.get());
    }

    @Override
    @NotNull
    public BlockPos getRandomBuilding() {
        ++this.buildingPosUsage;
        if (this.buildingPosUsage > 3 || this.lastBuilding == null) {
            this.buildingPosUsage = 0;
            Collection<IBuilding> buildingList = this.colony.getBuildingManager().getBuildings().values();
            Object[] buildingArray = buildingList.toArray();
            if (buildingArray.length != 0) {
                int rand = this.colony.getWorld().field_73012_v.nextInt(buildingArray.length);
                IBuilding building = (IBuilding)buildingArray[rand];
                this.lastBuilding = building.getPosition();
            } else {
                this.lastBuilding = this.colony.getCenter();
            }
        }
        return this.lastBuilding;
    }

    @Override
    public double getRaidDifficultyModifier() {
        return ((double)this.raidDifficulty / 10.0 + 0.2) * ((double)((Integer)MinecoloniesAPIProxy.getInstance().getConfig().getServer().barbarianHordeDifficulty.get()).intValue() / 5.0) * ((double)this.colony.getWorld().func_175659_aa().func_151525_a() / 2.0);
    }

    @Override
    public void onLostCitizen(ICitizenData citizen) {
        if (!this.isRaided()) {
            return;
        }
        this.lostCitizens = citizen.getJob() instanceof AbstractJobGuard ? ++this.lostCitizens : (this.lostCitizens += 2);
        if ((double)this.lostCitizens / (double)this.colony.getCitizenManager().getMaxCitizens() > 0.5) {
            for (IColonyEvent event : this.colony.getEventManager().getEvents().values()) {
                event.setStatus(EventStatus.DONE);
            }
        }
    }

    @Override
    public void write(CompoundNBT compound) {
        compound.func_74757_a("raidable", this.canHaveRaiderEvents());
        compound.func_74768_a("nightsRaid", this.getNightsSinceLastRaid());
        compound.func_74768_a(TAG_RAID_DIFFICULTY, this.raidDifficulty);
        compound.func_74768_a(TAG_LOST_CITIZENS, this.lostCitizens);
    }

    @Override
    public void read(CompoundNBT compound) {
        if (compound.func_150296_c().contains("raidable")) {
            this.setCanHaveRaiderEvents(compound.func_74767_n("raidable"));
        } else {
            this.setCanHaveRaiderEvents(true);
        }
        if (compound.func_74764_b("nightsRaid")) {
            this.setNightsSinceLastRaid(compound.func_74762_e("nightsRaid"));
        }
        this.raidDifficulty = MathHelper.func_76125_a((int)compound.func_74762_e(TAG_RAID_DIFFICULTY), (int)1, (int)14);
        this.lostCitizens = compound.func_74762_e(TAG_LOST_CITIZENS);
    }

    @Override
    public int getLostCitizen() {
        return this.lostCitizens;
    }
}

