/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.GraveData;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.managers.interfaces.IGraveManager;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.tileentities.TileEntityGrave;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.blocks.BlockMinecoloniesGrave;
import com.minecolonies.coremod.colony.Colony;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class GraveManager
implements IGraveManager {
    @NotNull
    private final Map<BlockPos, Boolean> graves = new HashMap<BlockPos, Boolean>();
    private final Colony colony;

    public GraveManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void read(@NotNull CompoundNBT compound) {
        this.graves.clear();
        ListNBT gravesTagList = compound.func_150295_c("graves", 10);
        for (int i = 0; i < gravesTagList.size(); ++i) {
            CompoundNBT graveCompound = gravesTagList.func_150305_b(i);
            if (!graveCompound.func_74764_b("pos") || !graveCompound.func_74764_b("reserved")) continue;
            this.graves.put(BlockPosUtil.read(graveCompound, "pos"), graveCompound.func_74767_n("reserved"));
        }
    }

    @Override
    public void write(@NotNull CompoundNBT compound) {
        @NotNull ListNBT gravesTagList = new ListNBT();
        for (BlockPos blockPos : this.graves.keySet()) {
            @NotNull CompoundNBT graveCompound = new CompoundNBT();
            BlockPosUtil.write(graveCompound, "pos", blockPos);
            graveCompound.func_74757_a("reserved", this.graves.get(blockPos).booleanValue());
            gravesTagList.add((Object)graveCompound);
        }
        compound.func_218657_a("graves", (INBT)gravesTagList);
    }

    @Override
    public void onColonyTick(IColony colony) {
        Iterator<BlockPos> iterator = this.graves.keySet().iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            if (!WorldUtil.isBlockLoaded((IWorld)colony.getWorld(), pos)) continue;
            TileEntity graveEntity = colony.getWorld().func_175625_s(pos);
            if (!(graveEntity instanceof TileEntityGrave)) {
                iterator.remove();
                colony.markDirty();
                continue;
            }
            if (((TileEntityGrave)graveEntity).onColonyTick(500.0)) continue;
            iterator.remove();
            colony.markDirty();
        }
    }

    @Override
    @NotNull
    public Map<BlockPos, Boolean> getGraves() {
        return this.graves;
    }

    @Override
    public boolean addNewGrave(@NotNull BlockPos pos) {
        TileEntityGrave graveEntity = (TileEntityGrave)this.colony.getWorld().func_175625_s(pos);
        if (graveEntity == null) {
            return false;
        }
        if (this.graves.containsKey(pos)) {
            return true;
        }
        this.graves.put(pos, false);
        this.colony.markDirty();
        return true;
    }

    @Override
    public void removeGrave(@NotNull BlockPos pos) {
        this.graves.remove(pos);
        this.colony.markDirty();
    }

    @Override
    public boolean reserveGrave(@NotNull BlockPos pos) {
        if (!this.graves.containsKey(pos) || this.graves.get(pos).booleanValue()) {
            return false;
        }
        this.graves.put(pos, true);
        this.colony.markDirty();
        return true;
    }

    @Override
    public void unReserveGrave(@NotNull BlockPos pos) {
        if (this.graves.containsKey(pos) && this.graves.get(pos).booleanValue()) {
            this.graves.put(pos, false);
            this.colony.markDirty();
        }
    }

    @Override
    public BlockPos reserveNextFreeGrave() {
        for (BlockPos pos : this.graves.keySet()) {
            TileEntityGrave graveEntity;
            if (!WorldUtil.isBlockLoaded((IWorld)this.colony.getWorld(), pos) || (graveEntity = (TileEntityGrave)this.colony.getWorld().func_175625_s(pos)) == null || !this.reserveGrave(pos)) continue;
            return pos;
        }
        return null;
    }

    @Override
    public void createCitizenGrave(World world, BlockPos pos, ICitizenData citizenData) {
        BlockPos firstValidPosition = BlockPosUtil.findAround(world, pos, 15, 10, (blockAccess, current) -> blockAccess.func_180495_p(current).func_185904_a() == Material.field_151579_a && blockAccess.func_180495_p(current.func_177977_b()).func_185904_a().func_76220_a());
        if (firstValidPosition != null) {
            world.func_175656_a(firstValidPosition, BlockMinecoloniesGrave.getPlacementState(ModBlocks.blockGrave.func_176223_P(), new TileEntityGrave(), firstValidPosition));
            TileEntityGrave graveEntity = (TileEntityGrave)world.func_175625_s(firstValidPosition);
            if (!InventoryUtils.transferAllItemHandler((IItemHandler)citizenData.getInventory(), (IItemHandler)graveEntity.getInventory())) {
                InventoryUtils.dropItemHandler((IItemHandler)citizenData.getInventory(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            graveEntity.delayDecayTimer(this.colony.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.GRAVE_DECAY_BONUS));
            GraveData graveData = new GraveData();
            graveData.setCitizenName(citizenData.getName());
            if (citizenData.getJob() != null) {
                TranslationTextComponent jobName = new TranslationTextComponent(citizenData.getJob().getJobRegistryEntry().getTranslationKey().toLowerCase());
                graveData.setCitizenJobName(jobName.getString());
            }
            graveData.setCitizenDataNBT((CompoundNBT)citizenData.serializeNBT());
            graveEntity.setGraveData(graveData);
            this.colony.getGraveManager().addNewGrave(firstValidPosition);
            LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.gravespawned", (Object[])new Object[0]);
        } else {
            InventoryUtils.dropItemHandler((IItemHandler)citizenData.getInventory(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }
}

