/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataManager;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.coremod.colony.buildings.modules.BedHandlingModule;
import com.minecolonies.coremod.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.WorkAtHomeBuildingModule;
import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.CitizenSpawnedEvent;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobUndertaker;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewCitizenViewMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewRemoveCitizenMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenManager
implements ICitizenManager {
    @NotNull
    private final Map<Integer, ICitizenData> citizens = new HashMap<Integer, ICitizenData>();
    private boolean isCitizensDirty = false;
    private int topCitizenId = 0;
    private int maxCitizens = 0;
    private int potentialMaxCitizens;
    private final Colony colony;
    private int respawnInterval = 600;
    private Random random = new Random();
    private boolean areCitizensSleeping;

    public CitizenManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void registerCivilian(AbstractCivilianEntity entity) {
        if (entity.getCivilianID() == 0 || this.citizens.get(entity.getCivilianID()) == null) {
            entity.func_70106_y();
            return;
        }
        ICitizenData data = this.citizens.get(entity.getCivilianID());
        Optional<AbstractEntityCitizen> existingCitizen = data.getEntity();
        if (!existingCitizen.isPresent()) {
            data.setEntity(entity);
            entity.field_70170_p.func_96441_U().func_197901_a(entity.func_195047_I_(), this.colony.getTeam());
            return;
        }
        if (existingCitizen.get() == entity) {
            entity.field_70170_p.func_96441_U().func_197901_a(entity.func_195047_I_(), this.colony.getTeam());
            return;
        }
        if (entity.func_70089_S()) {
            existingCitizen.get().func_70106_y();
            data.setEntity(entity);
            entity.setCivilianData(data);
            entity.field_70170_p.func_96441_U().func_197901_a(entity.func_195047_I_(), this.colony.getTeam());
            return;
        }
        entity.func_70106_y();
    }

    @Override
    public void unregisterCivilian(AbstractCivilianEntity entity) {
        ICitizenData data = this.citizens.get(entity.getCivilianID());
        if (data != null && data.getEntity().isPresent() && data.getEntity().get() == entity) {
            try {
                if (this.colony.getWorld().func_96441_U().func_96509_i(entity.func_195047_I_()) == this.colony.getTeam()) {
                    this.colony.getWorld().func_96441_U().func_96512_b(entity.func_195047_I_(), this.colony.getTeam());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.citizens.get(entity.getCivilianID()).setEntity(null);
        }
    }

    @Override
    public void read(@NotNull CompoundNBT compound) {
        this.citizens.forEach((id, citizen) -> citizen.getEntity().ifPresent(Entity::func_70106_y));
        this.citizens.clear();
        this.citizens.putAll(NBTUtils.streamCompound(compound.func_150295_c("citizens", 10)).map(this::deserializeCitizen).collect(Collectors.toMap(ICitizen::getId, Function.identity())));
        this.colony.updateHasChilds();
    }

    private ICitizenData deserializeCitizen(@NotNull CompoundNBT compound) {
        ICitizenData data = ICitizenDataManager.getInstance().createFromNBT(compound, this.colony);
        this.topCitizenId = Math.max(this.topCitizenId, data.getId());
        return data;
    }

    @Override
    public void write(@NotNull CompoundNBT compoundNBT) {
        @NotNull ListNBT citizenTagList = this.citizens.values().stream().map(citizen -> (CompoundNBT)citizen.serializeNBT()).collect(NBTUtils.toListNBT());
        compoundNBT.func_218657_a("citizens", (INBT)citizenTagList);
    }

    @Override
    public void sendPackets(@NotNull Set<ServerPlayerEntity> closeSubscribers, @NotNull Set<ServerPlayerEntity> newSubscribers) {
        if (this.isCitizensDirty || !newSubscribers.isEmpty()) {
            HashSet<ServerPlayerEntity> players = new HashSet<ServerPlayerEntity>();
            if (this.isCitizensDirty) {
                players.addAll(closeSubscribers);
            }
            players.addAll(newSubscribers);
            for (ICitizenData citizen : this.citizens.values()) {
                if (!citizen.isDirty() && newSubscribers.isEmpty()) continue;
                players.forEach(player -> Network.getNetwork().sendToPlayer(new ColonyViewCitizenViewMessage(this.colony, citizen), (ServerPlayerEntity)player));
            }
        }
    }

    public ICitizenData spawnOrCreateCivilian(@Nullable ICivilianData data, World world, BlockPos spawnPos, boolean force) {
        if (!this.colony.getBuildingManager().hasTownHall() || !this.colony.canMoveIn() && !force) {
            return (ICitizenData)data;
        }
        BlockPos spawnLocation = spawnPos;
        if (this.colony.hasTownHall() && (spawnLocation == null || spawnLocation.equals((Object)BlockPos.field_177992_a))) {
            spawnLocation = this.colony.getBuildingManager().getTownHall().getPosition();
        }
        if (WorldUtil.isEntityBlockLoaded((IWorld)world, spawnLocation)) {
            BlockPos calculatedSpawn = EntityUtils.getSpawnPoint(world, spawnLocation);
            if (calculatedSpawn != null) {
                return this.spawnCitizenOnPosition((ICitizenData)data, world, force, calculatedSpawn);
            }
            if (this.colony.hasTownHall() && (calculatedSpawn = EntityUtils.getSpawnPoint(world, this.colony.getBuildingManager().getTownHall().getID())) != null) {
                return this.spawnCitizenOnPosition((ICitizenData)data, world, force, calculatedSpawn);
            }
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.citizens.nospace", (Object[])new Object[]{spawnLocation.func_177958_n(), spawnLocation.func_177956_o(), spawnLocation.func_177952_p()});
        }
        return (ICitizenData)data;
    }

    @NotNull
    private ICitizenData spawnCitizenOnPosition(@Nullable ICitizenData data, @NotNull World world, boolean force, BlockPos spawnPoint) {
        ICitizenData citizenData = data;
        if (citizenData == null) {
            citizenData = this.createAndRegisterCivilianData();
            if (this.getMaxCitizens() >= this.getCurrentCitizenCount() && !force) {
                if (this.maxCitizensFromResearch() <= (double)this.getCurrentCitizenCount()) {
                    LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"block.blockhuttownhall.messagemaxsize.research", (Object[])new Object[]{this.colony.getName()});
                } else {
                    LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"block.blockhuttownhall.messagemaxsize.config", (Object[])new Object[]{this.colony.getName()});
                }
            }
            this.colony.getEventDescriptionManager().addEventDescription(new CitizenSpawnedEvent(spawnPoint, citizenData.getName()));
        }
        EntityCitizen entity = (EntityCitizen)ModEntities.CITIZEN.func_200721_a(world);
        entity.func_70107_b((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o() + 0.1, (double)spawnPoint.func_177952_p() + 0.5);
        world.func_217376_c((Entity)entity);
        entity.getCitizenColonyHandler().registerWithColony(citizenData.getColony().getID(), citizenData.getId());
        this.colony.getProgressManager().progressCitizenSpawn(this.citizens.size(), this.citizens.values().stream().filter(tempDate -> tempDate.getJob() != null).collect(Collectors.toList()).size());
        this.markDirty();
        return citizenData;
    }

    @Override
    public ICitizenData createAndRegisterCivilianData() {
        for (int i = 1; i <= this.getCurrentCitizenCount() + 1; ++i) {
            if (this.getCivilian(i) != null) continue;
            this.topCitizenId = i;
            break;
        }
        CitizenData citizenData = new CitizenData(this.topCitizenId, this.colony);
        citizenData.initForNewCivilian();
        this.citizens.put(citizenData.getId(), citizenData);
        return citizenData;
    }

    @Override
    public ICitizenData resurrectCivilianData(@NotNull CompoundNBT compoundNBT, boolean resetId, @NotNull World world, BlockPos spawnPos) {
        for (int i = 1; i <= this.getCurrentCitizenCount() + 1; ++i) {
            if (this.getCivilian(i) != null) continue;
            this.topCitizenId = i;
            break;
        }
        if (resetId) {
            compoundNBT.func_74768_a("id", this.topCitizenId);
        }
        ICitizenData citizenData = this.deserializeCitizen(compoundNBT);
        citizenData.onResurrect();
        this.citizens.put(citizenData.getId(), citizenData);
        this.spawnOrCreateCitizen(citizenData, world, spawnPos);
        return citizenData;
    }

    @Override
    public void removeCivilian(@NotNull ICivilianData citizen) {
        if (!(citizen instanceof ICitizenData)) {
            return;
        }
        this.citizens.remove(citizen.getId());
        for (IBuilding building : this.colony.getBuildingManager().getBuildings().values()) {
            for (AbstractAssignedCitizenModule assignedCitizenModule : building.getModules(AbstractAssignedCitizenModule.class)) {
                assignedCitizenModule.removeCitizen((ICitizenData)citizen);
            }
        }
        this.colony.getWorkManager().clearWorkForCitizen((ICitizenData)citizen);
        for (ServerPlayerEntity player : this.colony.getPackageManager().getCloseSubscribers()) {
            Network.getNetwork().sendToPlayer(new ColonyViewRemoveCitizenMessage(this.colony, citizen.getId()), player);
        }
        this.calculateMaxCitizens();
        this.markDirty();
        this.colony.markDirty();
    }

    @Override
    public ICitizenData getJoblessCitizen() {
        for (ICitizenData citizen : this.citizens.values()) {
            if (citizen.getWorkBuilding() != null || citizen.isChild()) continue;
            return citizen;
        }
        return null;
    }

    @Override
    public void calculateMaxCitizens() {
        int newMaxCitizens = 0;
        int potentialMax = 0;
        for (IBuilding b : this.colony.getBuildingManager().getBuildings().values()) {
            if (b.getBuildingLevel() <= 0) continue;
            if (b.hasModule(BedHandlingModule.class) && b.hasModule(WorkAtHomeBuildingModule.class)) {
                WorkAtHomeBuildingModule module = b.getFirstModuleOccurance(WorkAtHomeBuildingModule.class);
                newMaxCitizens += b.getAllAssignedCitizen().size();
                potentialMax += module.getModuleMax() - b.getAllAssignedCitizen().size();
                continue;
            }
            if (!b.hasModule(LivingBuildingModule.class)) continue;
            newMaxCitizens += b.getFirstModuleOccurance(LivingBuildingModule.class).getModuleMax();
        }
        if (this.getMaxCitizens() != newMaxCitizens) {
            this.setMaxCitizens(newMaxCitizens);
            this.setPotentialMaxCitizens(potentialMax + newMaxCitizens);
            this.colony.markDirty();
        }
    }

    @Override
    public void spawnOrCreateCitizen() {
        this.spawnOrCreateCitizen(null, this.colony.getWorld(), null);
    }

    @Override
    @NotNull
    public Map<Integer, ICivilianData> getCivilianDataMap() {
        return Collections.unmodifiableMap(this.citizens);
    }

    @Override
    public void markDirty() {
        this.colony.markDirty();
        this.isCitizensDirty = true;
    }

    @Override
    public ICitizenData getCivilian(int citizenId) {
        return this.citizens.get(citizenId);
    }

    @Override
    public void clearDirty() {
        this.isCitizensDirty = false;
        this.citizens.values().forEach(ICivilianData::clearDirty);
    }

    @Override
    public List<ICitizenData> getCitizens() {
        return new ArrayList<ICitizenData>(this.citizens.values());
    }

    @Override
    public int getMaxCitizens() {
        return (int)Math.max(1.0, Math.min((double)this.maxCitizens, Math.min(this.maxCitizensFromResearch(), (double)((Integer)MineColonies.getConfig().getServer().maxCitizenPerColony.get()).intValue())));
    }

    @Override
    public int getPotentialMaxCitizens() {
        return (int)Math.max(1.0, Math.min((double)this.potentialMaxCitizens, Math.min(this.maxCitizensFromResearch(), (double)((Integer)MineColonies.getConfig().getServer().maxCitizenPerColony.get()).intValue())));
    }

    @Override
    public double maxCitizensFromResearch() {
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().hasResearchEffect(ResearchConstants.CITIZEN_CAP)) {
            double max = 25.0 + this.colony.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.CITIZEN_CAP);
            return Math.min(max, (double)((Integer)MineColonies.getConfig().getServer().maxCitizenPerColony.get()).intValue());
        }
        return ((Integer)MineColonies.getConfig().getServer().maxCitizenPerColony.get()).intValue();
    }

    @Override
    public int getCurrentCitizenCount() {
        return this.citizens.size() + this.colony.getGraveManager().getGraves().size();
    }

    @Override
    public void setMaxCitizens(int newMaxCitizens) {
        this.maxCitizens = newMaxCitizens;
    }

    @Override
    public void setPotentialMaxCitizens(int newPotentialMax) {
        this.potentialMaxCitizens = newPotentialMax;
    }

    @Override
    public void updateModifier(String id) {
        for (ICitizenData citizenData : this.citizens.values()) {
            citizenData.getCitizenHappinessHandler().getModifier(id).reset();
        }
    }

    @Override
    public void checkCitizensForHappiness() {
        for (ICitizenData citizenData : this.citizens.values()) {
            citizenData.getCitizenHappinessHandler().processDailyHappiness(citizenData);
        }
    }

    @Override
    public void tickCitizenData() {
        this.getCitizens().forEach(ICivilianData::tick);
    }

    @Override
    public void onColonyTick(IColony colony) {
        if (colony.hasTownHall()) {
            this.getCitizens().stream().filter(Objects::nonNull).forEach(ICivilianData::updateEntityIfNecessary);
        }
        if (colony.canMoveIn() && colony.hasTownHall() && this.getCitizens().size() < (Integer)MineColonies.getConfig().getServer().initialCitizenAmount.get()) {
            this.respawnInterval -= 500 + 60 * colony.getBuildingManager().getTownHall().getBuildingLevel();
            if (this.respawnInterval <= 0) {
                this.respawnInterval = (Integer)MineColonies.getConfig().getServer().citizenRespawnInterval.get() * 20;
                int femaleCount = 0;
                for (ICitizenData citizens : this.getCitizens()) {
                    femaleCount += citizens.isFemale() ? 1 : 0;
                }
                ICitizenData newCitizen = this.createAndRegisterCivilianData();
                if (this.getCitizens().size() == 1) {
                    newCitizen.setGenderAndGenerateName(this.random.nextBoolean());
                } else if ((double)femaleCount < (double)(this.getCitizens().size() - 1) / 2.0) {
                    newCitizen.setGenderAndGenerateName(true);
                } else {
                    newCitizen.setGenderAndGenerateName(false);
                }
                this.spawnOrCreateCivilian(newCitizen, colony.getWorld(), (BlockPos)null, true);
                colony.getEventDescriptionManager().addEventDescription(new CitizenSpawnedEvent(colony.getBuildingManager().getTownHall().getPosition(), newCitizen.getName()));
            }
        }
    }

    @Override
    public void updateCitizenMourn(ICitizenData data, boolean mourn) {
        if (mourn) {
            LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.mourning", (Object[])new Object[]{this.colony.getName(), data.getName()});
        }
        for (ICitizenData citizen : this.getCitizens()) {
            if (mourn) {
                if (citizen.getJob() instanceof AbstractJobGuard || citizen.getJob() instanceof JobUndertaker || !citizen.isRelatedTo(data) && !citizen.doesLiveWith(data)) continue;
                citizen.getCitizenMournHandler().addDeceasedCitizen(data.getName());
                continue;
            }
            citizen.getCitizenMournHandler().removeDeceasedCitizen(data.getName());
        }
    }

    @Override
    public ICitizenData getRandomCitizen() {
        return (ICitizenData)this.citizens.values().toArray()[this.random.nextInt(this.citizens.values().size())];
    }

    @Override
    public void updateCitizenSleep(boolean sleep) {
        this.areCitizensSleeping = sleep;
    }

    @Override
    public void onCitizenSleep() {
        for (ICitizenData citizenData : this.citizens.values()) {
            if (citizenData.isAsleep() || citizenData.getJob() instanceof AbstractJobGuard) continue;
            return;
        }
        if (!this.areCitizensSleeping) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.entity.citizen.sleep", (Object[])new Object[0]);
        }
        this.areCitizensSleeping = true;
    }

    @Override
    public void onWakeUp() {
        for (ICitizenData citizenData : this.citizens.values()) {
            if (citizenData.getCitizenMournHandler().isMourning()) {
                citizenData.getCitizenMournHandler().clearDeceasedCitizen();
                citizenData.getCitizenMournHandler().setMourning(false);
                continue;
            }
            if (!citizenData.getCitizenMournHandler().shouldMourn()) continue;
            citizenData.getCitizenMournHandler().setMourning(true);
        }
    }
}

