/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.EntityAIWorkLumberjack;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.Tree;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobLumberjack
extends AbstractJobCrafter<EntityAIWorkLumberjack, JobLumberjack> {
    public static final double BONUS_SPEED_PER_LEVEL = 0.003;
    @Nullable
    private Tree tree;

    public JobLumberjack(ICitizenData entity) {
        super(entity);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        @NotNull CompoundNBT treeTag = new CompoundNBT();
        if (this.tree != null) {
            this.tree.write(treeTag);
        }
        compound.func_218657_a("Tree", (INBT)treeTag);
        return compound;
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.LUMBERJACK_ID;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_74764_b("Tree")) {
            this.tree = Tree.read(compound.func_74775_l("Tree"));
            if (!this.tree.isTree()) {
                this.tree = null;
            }
        }
    }

    @Override
    public void onLevelUp() {
        if (this.getCitizen().getEntity().isPresent()) {
            AbstractEntityCitizen worker = this.getCitizen().getEntity().get();
            AttributeModifier speedModifier = new AttributeModifier("SkillSpeedBonus", (double)this.getCitizen().getCitizenSkillHandler().getLevel(this.getCitizen().getWorkBuilding().getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.getJobRegistryEntry()).getSecondarySkill()) / 2.0 * 0.003, AttributeModifier.Operation.ADDITION);
            AttributeModifierUtils.addModifier((LivingEntity)worker, speedModifier, Attributes.field_233821_d_);
        }
    }

    @Nullable
    public Tree getTree() {
        return this.tree;
    }

    public void setTree(@Nullable Tree tree) {
        this.tree = tree;
    }

    @Override
    @NotNull
    public EntityAIWorkLumberjack generateAI() {
        return new EntityAIWorkLumberjack(this);
    }
}

