/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.DamageSource;

public abstract class AbstractJobGuard<J extends AbstractJobGuard<J>>
extends AbstractJob<AbstractEntityAIGuard<J, ? extends AbstractBuildingGuards>, J> {
    public AbstractJobGuard(ICitizenData entity) {
        super(entity);
    }

    protected abstract AbstractEntityAIGuard<J, ? extends AbstractBuildingGuards> generateGuardAI();

    @Override
    public AbstractEntityAIGuard<J, ? extends AbstractBuildingGuards> generateAI() {
        return this.generateGuardAI();
    }

    @Override
    public void triggerDeathAchievement(DamageSource source, AbstractEntityCitizen citizen) {
        super.triggerDeathAchievement(source, citizen);
    }

    @Override
    public boolean allowsAvoidance() {
        return false;
    }

    public boolean isAsleep() {
        return this.getWorkerAI() != null && ((AbstractEntityAIGuard)this.getWorkerAI()).getState() == AIWorkerState.GUARD_SLEEP;
    }

    @Override
    public void initEntityValues(AbstractEntityCitizen citizen) {
        super.initEntityValues(citizen);
        IBuilding workBuilding = citizen.getCitizenData().getWorkBuilding();
        if (workBuilding instanceof AbstractBuildingGuards) {
            AttributeModifierUtils.addHealthModifier((LivingEntity)citizen, new AttributeModifier("MinecoloniesGuardBuildingHP", (double)((AbstractBuildingGuards)workBuilding).getBonusHealth(), AttributeModifier.Operation.ADDITION));
            AttributeModifierUtils.addHealthModifier((LivingEntity)citizen, new AttributeModifier("MinecoloniesGuardConfigHP", (Double)MineColonies.getConfig().getServer().guardHealthMult.get() - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }
}

