/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecolonies.api.util.Log;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LootTableAnalyzer {
    private static final Gson GSON = LootSerializers.func_237388_c_().create();

    private LootTableAnalyzer() {
    }

    public static List<LootDrop> toDrops(@NotNull LootTableManager lootTableManager, @NotNull ResourceLocation lootTableId) {
        return LootTableAnalyzer.toDrops(lootTableManager, lootTableManager.func_186521_a(lootTableId));
    }

    public static List<LootDrop> toDrops(@Nullable LootTableManager lootTableManager, @NotNull LootTable lootTable) {
        try {
            JsonObject lootTableJson = LootTableManager.func_215301_a((LootTable)lootTable).getAsJsonObject();
            return LootTableAnalyzer.toDrops(lootTableManager, lootTableJson);
        }
        catch (JsonParseException ex) {
            Log.getLogger().error(String.format("Failed to parse loot table from %s", lootTable.getLootTableId()), (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public static List<LootDrop> toDrops(@Nullable LootTableManager lootTableManager, @NotNull JsonObject lootTableJson) {
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        if (!lootTableJson.has("pools")) {
            return drops;
        }
        JsonArray pools = JSONUtils.func_151214_t((JsonObject)lootTableJson, (String)"pools");
        for (JsonElement pool : pools) {
            JsonArray entries = JSONUtils.func_151213_a((JsonObject)pool.getAsJsonObject(), (String)"entries", (JsonArray)new JsonArray());
            float totalWeight = StreamSupport.stream(entries.spliterator(), false).filter(entry -> {
                String type = JSONUtils.func_151200_h((JsonObject)entry.getAsJsonObject(), (String)"type");
                return type.equals("minecraft:empty") || type.equals("minecraft:item") || type.equals("minecraft:tag") || type.equals("minecraft:loot_table");
            }).mapToInt(entry -> JSONUtils.func_151208_a((JsonObject)entry.getAsJsonObject(), (String)"weight", (int)1)).sum();
            for (JsonElement ej : entries) {
                boolean conditional;
                JsonObject entryJson = ej.getAsJsonObject();
                String type = JSONUtils.func_151200_h((JsonObject)entryJson, (String)"type");
                if (type.equals("minecraft:item")) {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)entryJson, (String)"name")));
                    float weight = JSONUtils.func_151221_a((JsonObject)entryJson, (String)"weight", (float)1.0f);
                    float quality = JSONUtils.func_151221_a((JsonObject)entryJson, (String)"quality", (float)0.0f);
                    float modifier = 1.0f;
                    conditional = JSONUtils.func_151213_a((JsonObject)entryJson, (String)"conditions", (JsonArray)new JsonArray()).size() > 0;
                    ItemStack stack = new ItemStack((IItemProvider)item);
                    if (entryJson.has("functions")) {
                        Tuple<ItemStack, Float> result = LootTableAnalyzer.processFunctions(stack, JSONUtils.func_151214_t((JsonObject)entryJson, (String)"functions"));
                        stack = (ItemStack)result.func_76341_a();
                        modifier = ((Float)result.func_76340_b()).floatValue();
                    }
                    drops.add(new LootDrop(Collections.singletonList(stack), weight / totalWeight * modifier, quality, conditional));
                    continue;
                }
                if (!type.equals("minecraft:loot_table") || lootTableManager == null) continue;
                ResourceLocation table = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)entryJson, (String)"name"));
                List<LootDrop> tableDrops = LootTableAnalyzer.toDrops(lootTableManager, table);
                float weight = JSONUtils.func_151221_a((JsonObject)entryJson, (String)"weight", (float)1.0f);
                float quality = JSONUtils.func_151221_a((JsonObject)entryJson, (String)"quality", (float)0.0f);
                conditional = JSONUtils.func_151213_a((JsonObject)entryJson, (String)"conditions", (JsonArray)new JsonArray()).size() > 0;
                for (LootDrop drop : tableDrops) {
                    drops.add(new LootDrop(drop.getItemStacks(), drop.getProbability() * (weight / totalWeight), drop.getQuality() + quality, drop.getConditional() || conditional));
                }
            }
        }
        drops.sort(Comparator.comparing(LootDrop::getProbability).reversed());
        return drops;
    }

    @NotNull
    public static List<LootDrop> consolidate(@NotNull List<LootDrop> input) {
        return input.stream().collect(Collectors.groupingBy(LootDrop::hashCode)).values().stream().map(LootDrop::new).sorted(Comparator.comparing(LootDrop::getProbability).reversed()).collect(Collectors.toList());
    }

    private static Tuple<ItemStack, Float> processFunctions(@NotNull ItemStack stack, @NotNull JsonArray functions) {
        float modifier = 1.0f;
        block18: for (JsonElement je : functions) {
            String name;
            JsonObject function = je.getAsJsonObject();
            switch (name = JSONUtils.func_151219_a((JsonObject)function, (String)"function", (String)"")) {
                case "minecraft:set_count": {
                    Tuple<Integer, Float> result = LootTableAnalyzer.processCount(function.get("count"));
                    stack.func_190920_e(((Integer)result.func_76341_a()).intValue());
                    modifier *= ((Float)result.func_76340_b()).floatValue();
                    continue block18;
                }
                case "minecraft:set_damage": {
                    if (!stack.func_77984_f()) continue block18;
                    float damage = 1.0f - LootTableAnalyzer.processNumber(function.get("damage"), 0.0f);
                    stack.func_196085_b(MathHelper.func_76141_d((float)(damage * (float)stack.func_77958_k())));
                    continue block18;
                }
                case "minecraft:set_nbt": {
                    try {
                        stack.func_77982_d(JsonToNBT.func_180713_a((String)JSONUtils.func_151200_h((JsonObject)function, (String)"tag")));
                    }
                    catch (CommandSyntaxException e) {
                        Log.getLogger().error("Failed to parse set_nbt in loot table", (Throwable)e);
                    }
                    continue block18;
                }
                case "minecraft:enchant_with_levels": {
                    int levels = LootTableAnalyzer.processNumber(function.get("levels"), 1);
                    boolean treasure = JSONUtils.func_151209_a((JsonObject)function, (String)"treasure", (boolean)false);
                    stack = EnchantmentHelper.func_77504_a((Random)ThreadLocalRandom.current(), (ItemStack)stack, (int)levels, (boolean)treasure);
                    continue block18;
                }
                case "minecraft:looting_enchant": {
                    continue block18;
                }
                case "minecraft:furnace_smelt": {
                    continue block18;
                }
            }
            Log.getLogger().warn("Unhandled modifier in loot table: " + name);
        }
        return new Tuple((Object)stack, (Object)Float.valueOf(modifier));
    }

    private static Tuple<Integer, Float> processCount(@Nullable JsonElement json) {
        if (json == null) {
            return new Tuple((Object)1, (Object)Float.valueOf(1.0f));
        }
        RandomValueRange range = (RandomValueRange)GSON.fromJson(json, RandomValueRange.class);
        if (range.func_186509_a() > 0.0f) {
            return new Tuple((Object)range.func_186511_a((Random)ThreadLocalRandom.current()), (Object)Float.valueOf(1.0f));
        }
        return new Tuple((Object)((int)range.func_186512_b()), (Object)Float.valueOf(range.func_186512_b() / (range.func_186512_b() + 1.0f)));
    }

    private static int processNumber(@Nullable JsonElement json, int defaultValue) {
        if (json == null) {
            return defaultValue;
        }
        RandomValueRange range = (RandomValueRange)GSON.fromJson(json, RandomValueRange.class);
        return range.func_186511_a((Random)ThreadLocalRandom.current());
    }

    private static float processNumber(@Nullable JsonElement json, float defaultValue) {
        if (json == null) {
            return defaultValue;
        }
        RandomValueRange range = (RandomValueRange)GSON.fromJson(json, RandomValueRange.class);
        return range.func_186507_b((Random)ThreadLocalRandom.current());
    }

    public static class LootDrop {
        private final List<ItemStack> stacks;
        private final float probability;
        private final float quality;
        private final boolean conditional;

        public LootDrop(@NotNull List<ItemStack> stacks, float probability, float quality, boolean conditional) {
            this.stacks = stacks;
            this.probability = probability;
            this.quality = quality;
            this.conditional = conditional;
        }

        public LootDrop(@NotNull List<LootDrop> drops) {
            this.stacks = drops.stream().flatMap(d -> d.getItemStacks().stream()).collect(Collectors.toList());
            this.probability = drops.get(0).getProbability();
            this.quality = drops.get(0).getQuality();
            this.conditional = drops.get(0).getConditional();
        }

        @NotNull
        public List<ItemStack> getItemStacks() {
            return this.stacks;
        }

        public float getProbability() {
            return this.probability;
        }

        public float getQuality() {
            return this.quality;
        }

        public boolean getConditional() {
            return this.conditional;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.probability), Float.valueOf(this.quality), this.conditional);
        }

        public void serialize(@NotNull PacketBuffer buffer) {
            buffer.func_150787_b(this.stacks.size());
            for (ItemStack stack : this.stacks) {
                buffer.func_150788_a(stack);
            }
            buffer.writeFloat(this.probability);
            buffer.writeFloat(this.quality);
            buffer.writeBoolean(this.conditional);
        }

        public static LootDrop deserialize(@NotNull PacketBuffer buffer) {
            int size = buffer.func_150792_a();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(size);
            for (int i = 0; i < size; ++i) {
                stacks.add(buffer.func_150791_c());
            }
            float probability = buffer.readFloat();
            float quality = buffer.readFloat();
            boolean conditional = buffer.readBoolean();
            return new LootDrop(stacks, probability, quality, conditional);
        }
    }
}

