/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents.barbarianEvent;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.HordeRaidEvent;
import com.minecolonies.coremod.entity.mobs.barbarians.EntityArcherBarbarian;
import com.minecolonies.coremod.entity.mobs.barbarians.EntityBarbarian;
import com.minecolonies.coremod.entity.mobs.barbarians.EntityChiefBarbarian;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;

public class BarbarianRaidEvent
extends HordeRaidEvent {
    public static final ResourceLocation BARBARIAN_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "barbarian_raid");

    public BarbarianRaidEvent(IColony colony) {
        super(colony);
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return BARBARIAN_RAID_EVENT_TYPE_ID;
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob) || !entity.func_70089_S()) {
            entity.func_70106_y();
            return;
        }
        if (entity instanceof EntityChiefBarbarian && this.boss.keySet().size() < this.horde.numberOfBosses) {
            this.boss.put(entity, entity.func_110124_au());
            return;
        }
        if (entity instanceof EntityArcherBarbarian && this.archers.keySet().size() < this.horde.numberOfArchers) {
            this.archers.put(entity, entity.func_110124_au());
            return;
        }
        if (entity instanceof EntityBarbarian && this.normal.keySet().size() < this.horde.numberOfRaiders) {
            this.normal.put(entity, entity.func_110124_au());
            return;
        }
        entity.func_70106_y();
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob)) {
            return;
        }
        if (entity instanceof EntityChiefBarbarian) {
            this.boss.remove(entity);
            --this.horde.numberOfBosses;
        }
        if (entity instanceof EntityArcherBarbarian) {
            this.archers.remove(entity);
            --this.horde.numberOfArchers;
        }
        if (entity instanceof EntityBarbarian) {
            this.normal.remove(entity);
            --this.horde.numberOfRaiders;
        }
        --this.horde.hordeSize;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        this.sendHordeMessage();
    }

    public static BarbarianRaidEvent loadFromNBT(IColony colony, CompoundNBT compound) {
        BarbarianRaidEvent event = new BarbarianRaidEvent(colony);
        event.deserializeNBT(compound);
        return event;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.BARBARIAN;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.ARCHERBARBARIAN;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.CHIEFBARBARIAN;
    }

    @Override
    protected IFormattableTextComponent getDisplayName() {
        return new StringTextComponent(LanguageHandler.format((String)"com.minecolonies.coremod.raid.barbarian.name", (Object[])new Object[0]));
    }
}

