/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ColonyState;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyCampFireRaidEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.sounds.RaidSounds;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.barbarianEvent.Horde;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipBasedRaiderUtils;
import com.minecolonies.coremod.network.messages.client.PlayAudioMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.pathfinding.Path;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerBossInfo;
import org.jetbrains.annotations.NotNull;

public abstract class HordeRaidEvent
implements IColonyRaidEvent,
IColonyCampFireRaidEvent {
    private static final int WAYPOINT_SPACING = 20;
    public static int MAX_SPAWN_DEVIATION = 300;
    public static int MAX_RESPAWN_DEVIATION = 160;
    public static int MIN_CENTER_DISTANCE = 100;
    protected Horde horde;
    protected final ServerBossInfo raidBar = new ServerBossInfo((ITextComponent)new StringTextComponent("Colony Raid"), BossInfo.Color.RED, BossInfo.Overlay.NOTCHED_10);
    protected Map<Entity, UUID> normal = new WeakHashMap<Entity, UUID>();
    protected Map<Entity, UUID> archers = new WeakHashMap<Entity, UUID>();
    protected Map<Entity, UUID> boss = new WeakHashMap<Entity, UUID>();
    private List<Tuple<EntityType<?>, BlockPos>> respawns = new ArrayList();
    private List<BlockPos> campFires = new ArrayList<BlockPos>();
    private IColony colony;
    private int id;
    private BlockPos spawnPoint;
    protected EventStatus status = EventStatus.STARTING;
    private int daysToGo = 3;
    private int campFireTime = 0;
    private PathResult spawnPathResult;
    private List<BlockPos> wayPoints = new ArrayList<BlockPos>();

    public HordeRaidEvent(IColony colony) {
        this.colony = colony;
        this.id = colony.getEventManager().getAndTakeNextEventID();
    }

    @Override
    public void setSpawnPoint(BlockPos spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    @Override
    public BlockPos getSpawnPos() {
        return this.spawnPoint;
    }

    @Override
    public List<Entity> getEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        entities.addAll(this.archers.keySet());
        entities.addAll(this.boss.keySet());
        entities.addAll(this.normal.keySet());
        return entities;
    }

    @Override
    public EventStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(EventStatus status) {
        this.status = status;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setColony(@NotNull IColony colony) {
        this.colony = colony;
    }

    @Override
    public void unregisterEntity(Entity entity) {
        if (!this.archers.containsKey(entity) && !this.boss.containsKey(entity) && !this.normal.containsKey(entity) || this.status != EventStatus.PROGRESSING || this.colony.getState() != ColonyState.ACTIVE) {
            return;
        }
        this.archers.remove(entity);
        this.boss.remove(entity);
        this.normal.remove(entity);
        this.respawns.add(new Tuple<EntityType, BlockPos>(entity.func_200600_R(), new BlockPos(entity.func_213303_ch())));
    }

    protected void spawnHorde(BlockPos spawnPos, IColony colony, int id, int numberOfBosses, int numberOfArchers, int numberOfRaiders) {
        RaiderMobUtils.spawn(this.getNormalRaiderType(), numberOfRaiders, spawnPos, colony.getWorld(), colony, id);
        RaiderMobUtils.spawn(this.getBossRaiderType(), numberOfBosses, spawnPos, colony.getWorld(), colony, id);
        RaiderMobUtils.spawn(this.getArcherRaiderType(), numberOfArchers, spawnPos, colony.getWorld(), colony, id);
    }

    private void prepareEvent() {
        if (--this.campFireTime <= 0) {
            this.status = EventStatus.PROGRESSING;
        }
    }

    private void spawnCampFires(BlockPos pos) {
        int fireCount = Math.max(1, this.horde.hordeSize / 5);
        block0: for (int i = 0; i < fireCount; ++i) {
            for (int tries = 0; tries < 3; ++tries) {
                BlockPos spawn = BlockPosUtil.getRandomPosition(this.colony.getWorld(), pos, BlockPos.field_177992_a, 3, 7);
                if (spawn == BlockPos.field_177992_a) continue;
                this.colony.getWorld().func_175656_a(spawn, Blocks.field_222433_lV.func_176223_P());
                this.campFires.add(spawn);
                continue block0;
            }
        }
    }

    @Override
    public void onFinish() {
        for (Entity entity : this.getEntities()) {
            entity.func_70106_y();
        }
        for (BlockPos pos : this.campFires) {
            this.colony.getWorld().func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        this.raidBar.func_186758_d(false);
        this.raidBar.func_201360_b();
        if (this.horde.hordeSize > 0) {
            LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.barbarians.killed", (Object[])new Object[]{this.colony.getName()});
        }
    }

    @Override
    public void onNightFall() {
        --this.daysToGo;
        if (this.daysToGo < 0) {
            this.status = EventStatus.DONE;
        }
    }

    public void setHorde(Horde horde) {
        this.horde = horde;
    }

    public BlockPos getRandomCampfire() {
        if (this.campFires.isEmpty()) {
            return null;
        }
        return this.campFires.get(this.colony.getWorld().field_73012_v.nextInt(this.campFires.size()));
    }

    @Override
    public void onStart() {
        BlockPos spawnPos;
        if (this.spawnPathResult.isDone()) {
            Path path = this.spawnPathResult.getPath();
            if (path != null && path.func_224771_h()) {
                this.spawnPoint = path.func_75870_c().func_224759_a();
            }
            this.wayPoints = ShipBasedRaiderUtils.createWaypoints(this.colony.getWorld(), path, 20);
        }
        if ((spawnPos = ShipBasedRaiderUtils.getLoadedPositionTowardsCenter(this.spawnPoint, this.colony, MAX_SPAWN_DEVIATION, this.spawnPoint, MIN_CENTER_DISTANCE, 10)) == null) {
            this.status = EventStatus.CANCELED;
            return;
        }
        this.status = EventStatus.PREPARING;
        this.spawnCampFires(spawnPos);
        double dist = this.colony.getCenter().func_177951_i((Vector3i)spawnPos);
        this.campFireTime = dist < (double)(MIN_CENTER_DISTANCE * MIN_CENTER_DISTANCE) ? 6 : 3;
        this.spawnHorde(spawnPos, this.colony, this.id, this.horde.numberOfBosses, this.horde.numberOfArchers, this.horde.numberOfRaiders);
        this.updateRaidBar();
        LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)("event.minecolonies.raidmessage" + this.horde.getMessageID()), (Object[])new Object[]{BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint), this.colony.getName()});
        PlayAudioMessage audio = new PlayAudioMessage(this.horde.initialSize <= 5 ? RaidSounds.WARNING_EARLY : RaidSounds.WARNING, SoundCategory.RECORDS);
        PlayAudioMessage.sendToAll(this.getColony(), false, false, audio);
    }

    public IColony getColony() {
        return this.colony;
    }

    protected void updateRaidBar() {
        String directionName = BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint);
        this.raidBar.func_186739_a((ITextComponent)this.getDisplayName().func_230529_a_((ITextComponent)new StringTextComponent(" - " + directionName)));
        for (PlayerEntity playerEntity : this.colony.getPackageManager().getCloseSubscribers()) {
            this.raidBar.func_186760_a((ServerPlayerEntity)playerEntity);
        }
        this.raidBar.func_186758_d(true);
    }

    protected abstract IFormattableTextComponent getDisplayName();

    @Override
    public void onUpdate() {
        BlockPos spawnPos;
        if (this.status == EventStatus.PREPARING) {
            this.prepareEvent();
        }
        this.updateRaidBar();
        this.colony.getRaiderManager().setNightsSinceLastRaid(0);
        if (this.horde.hordeSize <= 0) {
            this.status = EventStatus.DONE;
        }
        if (!this.respawns.isEmpty()) {
            for (Tuple<EntityType<?>, BlockPos> entry : this.respawns) {
                BlockPos spawnPos2 = ShipBasedRaiderUtils.getLoadedPositionTowardsCenter(entry.getB(), this.colony, MAX_RESPAWN_DEVIATION, this.spawnPoint, MIN_CENTER_DISTANCE, 10);
                if (spawnPos2 == null) continue;
                RaiderMobUtils.spawn(entry.getA(), 1, spawnPos2, this.colony.getWorld(), this.colony, this.id);
            }
            this.respawns.clear();
            return;
        }
        if (this.boss.size() + this.archers.size() + this.normal.size() < this.horde.numberOfBosses + this.horde.numberOfRaiders + this.horde.numberOfArchers && (spawnPos = ShipBasedRaiderUtils.getLoadedPositionTowardsCenter(this.spawnPoint, this.colony, MAX_RESPAWN_DEVIATION, this.spawnPoint, MIN_CENTER_DISTANCE, 10)) != null) {
            this.spawnHorde(spawnPos, this.colony, this.id, this.horde.numberOfBosses - this.boss.size(), this.horde.numberOfArchers - this.archers.size(), this.horde.numberOfRaiders - this.normal.size());
        }
        if ((long)(this.horde.numberOfBosses + this.horde.numberOfRaiders + this.horde.numberOfArchers) < Math.round((double)this.horde.initialSize * 0.05)) {
            this.status = EventStatus.DONE;
        }
        for (Entity entity : this.getEntities()) {
            if (!entity.func_70089_S() || !WorldUtil.isEntityBlockLoaded((IWorld)this.colony.getWorld(), new BlockPos(entity.func_213303_ch()))) {
                entity.func_70106_y();
                this.respawns.add(new Tuple<EntityType, BlockPos>(entity.func_200600_R(), new BlockPos(entity.func_213303_ch())));
                continue;
            }
            if (!this.colony.getRaiderManager().areSpiesEnabled()) continue;
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_188423_x, 550));
        }
    }

    protected void sendHordeMessage() {
        int total = 0;
        for (IColonyEvent event : this.colony.getEventManager().getEvents().values()) {
            if (!(event instanceof HordeRaidEvent)) continue;
            total += ((HordeRaidEvent)event).horde.hordeSize;
        }
        this.raidBar.func_186735_a((float)this.horde.hordeSize / (float)this.horde.initialSize);
        if (total == 0) {
            LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)LanguageHandler.translateKey((String)"com.minecolonies.coremod.barbarians.killed"), (Object[])new Object[]{this.colony.getName()});
            PlayAudioMessage audio = new PlayAudioMessage(this.horde.initialSize <= 5 ? RaidSounds.VICTORY_EARLY : RaidSounds.VICTORY, SoundCategory.RECORDS);
            PlayAudioMessage.sendToAll(this.getColony(), false, true, audio);
            if (this.colony.getRaiderManager().getLostCitizen() == 0) {
                this.colony.getCitizenManager().updateModifier("raidwithoutdeath");
            }
        } else if (total > 0 && total <= 5) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.barbarians.left", (Object[])new Object[]{total});
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("mc_event_id", this.id);
        BlockPosUtil.write(compound, "spawnPos", this.spawnPoint);
        ListNBT campFiresNBT = new ListNBT();
        for (BlockPos pos : this.campFires) {
            campFiresNBT.add((Object)BlockPosUtil.write(new CompoundNBT(), "pos", pos));
        }
        compound.func_218657_a("campfirelist", (INBT)campFiresNBT);
        compound.func_74768_a("eventStatus", this.status.ordinal());
        compound.func_74768_a("pirateDaysLeft", this.daysToGo);
        this.horde.writeToNbt(compound);
        BlockPosUtil.writePosListToNBT(compound, "waypoints", this.wayPoints);
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.id = compound.func_74762_e("mc_event_id");
        this.setHorde(Horde.loadFromNbt(compound));
        this.spawnPoint = BlockPosUtil.read(compound, "spawnPos");
        for (INBT posCompound : compound.func_150295_c("campfirelist", 10)) {
            this.campFires.add(BlockPosUtil.read((CompoundNBT)posCompound, "pos"));
        }
        this.status = EventStatus.values()[compound.func_74762_e("eventStatus")];
        this.daysToGo = compound.func_74762_e("pirateDaysLeft");
        this.wayPoints = BlockPosUtil.readPosListFromNBT(compound, "waypoints");
    }

    @Override
    public void setCampFireTime(int time) {
        this.campFireTime = time;
    }

    @Override
    public void addSpawner(BlockPos pos) {
    }

    @Override
    public List<BlockPos> getWayPoints() {
        return this.wayPoints;
    }

    public void setSpawnPath(PathResult result) {
        this.spawnPathResult = result;
    }
}

