/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.AbstractTileEntityWareHouse;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.client.gui.WindowHutMinPlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.CourierAssignmentModule;
import com.minecolonies.coremod.colony.buildings.modules.WarehouseModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.requestsystem.resolvers.DeliveryRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PickupRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.WarehouseConcreteRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.WarehouseRequestResolver;
import com.minecolonies.coremod.tileentities.TileEntityWareHouse;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingWareHouse
extends AbstractBuilding
implements IWareHouse {
    private static final String WAREHOUSE = "warehouse";
    private static final int MAX_LEVEL = 5;
    public static final int MAX_STORAGE_UPGRADE = 3;

    public BuildingWareHouse(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void requestRepair(BlockPos builder) {
        for (BlockPos pos : this.containerList) {
            TileEntity entity;
            if (this.getColony().getWorld() == null || !((entity = this.getColony().getWorld().func_175625_s(pos)) instanceof TileEntityRack)) continue;
            ((AbstractTileEntityRack)entity).setInWarehouse(true);
        }
        super.requestRepair(builder);
    }

    @Override
    public boolean canAccessWareHouse(ICitizenData citizenData) {
        return this.getFirstModuleOccurance(CourierAssignmentModule.class).hasAssignedCitizen(citizenData);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return WAREHOUSE;
    }

    @Override
    public AbstractTileEntityWareHouse getTileEntity() {
        AbstractTileEntityColonyBuilding entity = super.getTileEntity();
        return !(entity instanceof TileEntityWareHouse) ? null : (AbstractTileEntityWareHouse)entity;
    }

    @Override
    public boolean hasContainerPosition(BlockPos inDimensionLocation) {
        return this.containerList.contains(inDimensionLocation) || this.getLocation().getInDimensionLocation().equals((Object)inDimensionLocation);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block instanceof BlockMinecoloniesRack) {
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof ChestTileEntity) {
                BuildingWareHouse.handleBuildingOverChest(pos, (ChestTileEntity)entity, world, null);
            }
            if (entity instanceof TileEntityRack) {
                ((AbstractTileEntityRack)entity).setInWarehouse(true);
            }
        }
        super.registerBlockPosition(block, pos, world);
    }

    public static void handleBuildingOverChest(@NotNull BlockPos pos, ChestTileEntity chest, World world, @Nullable CompoundNBT tileEntityData) {
        TileEntity entity;
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        int size = chest.func_70302_i_();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack = chest.func_70301_a(slot);
            if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
                inventory.add(stack.func_77946_l());
            }
            chest.func_70304_b(slot);
        }
        world.func_180501_a(pos, ModBlocks.blockRack.func_176223_P(), 3);
        if (tileEntityData != null) {
            PlacementHandlers.handleTileEntityPlacement((CompoundNBT)tileEntityData, (World)world, (BlockPos)pos);
        }
        if ((entity = world.func_175625_s(pos)) instanceof TileEntityRack) {
            ((AbstractTileEntityRack)entity).setInWarehouse(true);
            for (ItemStack stack : inventory) {
                if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                InventoryUtils.addItemStackToItemHandler((IItemHandler)((AbstractTileEntityRack)entity).getInventory(), stack);
            }
        }
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        ImmutableCollection<IRequestResolver<?>> supers = super.createResolvers();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(supers);
        builder.add((Object[])new IRequestResolver[]{new WarehouseRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)), new WarehouseConcreteRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN))});
        builder.add((Object)new DeliveryRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        builder.add((Object)new PickupRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    public void upgradeContainers(World world) {
        if (this.getFirstModuleOccurance(WarehouseModule.class).getStorageUpgrade() < 3) {
            for (BlockPos pos : this.getContainers()) {
                TileEntity entity = world.func_175625_s(pos);
                if (!(entity instanceof TileEntityRack) || entity instanceof TileEntityColonyBuilding) continue;
                ((AbstractTileEntityRack)entity).upgradeItemStorage();
            }
            this.getFirstModuleOccurance(WarehouseModule.class).incrementStorageUpgrade();
        }
        this.markDirty();
    }

    @Override
    public boolean canBeGathered() {
        return false;
    }

    public static class View
    extends AbstractBuildingView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutMinPlaceholder<View>(this);
        }
    }
}

