/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingUniversity
extends AbstractBuilding {
    private static final String UNIVERSITY = "university";
    private static final int OFFLINE_PROCESSING_LEVEL_CAP = 3;
    private final List<BlockPos> bookCases = new ArrayList<BlockPos>();
    private final Random random = new Random();

    public BuildingUniversity(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return UNIVERSITY;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT furnaceTagList = compound.func_150295_c("bookcase", 10);
        for (int i = 0; i < furnaceTagList.size(); ++i) {
            this.bookCases.add(NBTUtil.func_186861_c((CompoundNBT)furnaceTagList.func_150305_b(i).func_74775_l("pos")));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        @NotNull ListNBT bookcaseTagList = new ListNBT();
        for (BlockPos entry : this.bookCases) {
            @NotNull CompoundNBT bookCompound = new CompoundNBT();
            bookCompound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            bookcaseTagList.add((Object)bookCompound);
        }
        compound.func_218657_a("bookcase", (INBT)bookcaseTagList);
        return compound;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(block, pos, world);
        if (block == Blocks.field_150342_X) {
            this.bookCases.add(pos);
        }
    }

    public BlockPos getRandomBookShelf() {
        if (this.bookCases.isEmpty()) {
            return this.getPosition();
        }
        BlockPos returnPos = this.bookCases.get(this.random.nextInt(this.bookCases.size()));
        if (this.colony.getWorld().func_180495_p(returnPos).func_177230_c() == Blocks.field_150342_X) {
            return returnPos;
        }
        this.bookCases.remove(returnPos);
        return this.getPosition();
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        List<ILocalResearch> inProgress = colony.getResearchManager().getResearchTree().getResearchInProgress();
        WorkerBuildingModule module = this.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == ModJobs.researcher);
        int i = 1;
        for (ILocalResearch research : inProgress) {
            if (i > module.getAssignedCitizen().size()) {
                return;
            }
            for (ICitizenData data : this.getAllAssignedCitizen()) {
                data.getCitizenSkillHandler().addXpToSkill(module.getSecondarySkill(), 25.0, data);
            }
            if (colony.getResearchManager().getResearchTree().getResearch(research.getBranch(), research.getId()).research(colony.getResearchManager().getResearchEffects(), colony.getResearchManager().getResearchTree())) {
                this.onSuccess(research);
            }
            ++i;
        }
    }

    public void onSuccess(ILocalResearch research) {
        for (ICitizenData citizen : this.colony.getCitizenManager().getCitizens()) {
            citizen.applyResearchEffects();
        }
        TranslationTextComponent message = new TranslationTextComponent("com.minecolonies.coremod.university.researchconcluded." + ThreadLocalRandom.current().nextInt(3), new Object[]{IGlobalResearchTree.getInstance().getResearch(research.getBranch(), research.getId()).getName()});
        for (PlayerEntity player : this.colony.getMessagePlayerEntities()) {
            player.func_145747_a((ITextComponent)message, player.func_110124_au());
        }
        this.colony.getResearchManager().checkAutoStartResearch();
        this.markDirty();
    }

    @Override
    public void processOfflineTime(long time) {
        if (this.getBuildingLevel() >= 3 && time > 0L) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.researcher.moreknowledge", (Object[])new Object[0]);
            for (ICitizenData citizenData : this.getAllAssignedCitizen()) {
                if (citizenData.getJob() == null) continue;
                citizenData.getJob().processOfflineTime(time);
            }
        }
    }
}

