/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingStoneSmeltery
extends AbstractBuilding {
    private static final String STONE_SMELTERY = "stonesmeltery";

    public BuildingStoneSmeltery(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return STONE_SMELTERY;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class SmeltingModule
    extends AbstractCraftingBuildingModule.Smelting {
        public SmeltingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(BuildingStoneSmeltery.STONE_SMELTERY).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingStoneSmeltery.STONE_SMELTERY).orElse(false);
        }
    }
}

