/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.PlantationSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingPlantation
extends AbstractBuilding {
    public static final ISettingKey<PlantationSetting> MODE = new SettingKey<PlantationSetting>(PlantationSetting.class, new ResourceLocation("minecolonies", "mode"));
    private static final String PLANTATION = "plantation";
    private final List<BlockPos> sand = new ArrayList<BlockPos>();
    private Item currentPhase = Items.field_222065_kN;
    private final List<Item> settings = Arrays.asList(Items.field_222065_kN, Items.field_221774_cw, Items.field_222068_kQ);

    public BuildingPlantation(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return PLANTATION;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        Block down;
        super.registerBlockPosition(block, pos, world);
        if (block == Blocks.field_150354_m && ((down = world.func_180495_p(pos.func_177977_b()).func_177230_c()) == Blocks.field_150347_e || down == Blocks.field_196696_di)) {
            this.sand.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT sandPos = compound.func_150295_c("plantGround", 10);
        for (int i = 0; i < sandPos.size(); ++i) {
            this.sand.add(NBTUtil.func_186861_c((CompoundNBT)sandPos.func_150305_b(i).func_74775_l("pos")));
        }
        this.currentPhase = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("currentPhase")).func_77973_b();
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        @NotNull ListNBT sandCompoundList = new ListNBT();
        for (BlockPos entry : this.sand) {
            @NotNull CompoundNBT sandCompound = new CompoundNBT();
            sandCompound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            sandCompoundList.add((Object)sandCompound);
        }
        compound.func_218657_a("plantGround", (INBT)sandCompoundList);
        compound.func_218657_a("currentPhase", (INBT)new ItemStack((IItemProvider)this.currentPhase).func_77955_b(new CompoundNBT()));
        return compound;
    }

    public List<BlockPos> getPosForPhase() {
        ArrayList<BlockPos> filtered = new ArrayList<BlockPos>();
        if (this.tileEntity != null && !this.tileEntity.getPositionedTags().isEmpty()) {
            Item phase = this.nextPlantPhase();
            for (Map.Entry<BlockPos, List<String>> entry : this.tileEntity.getPositionedTags().entrySet()) {
                if (!(entry.getValue().contains("bamboo") && phase == Items.field_222068_kQ || entry.getValue().contains("sugar") && phase == Items.field_222065_kN) && (!entry.getValue().contains("cactus") || phase != Items.field_221774_cw)) continue;
                filtered.add(this.getPosition().func_177971_a((Vector3i)entry.getKey()));
            }
        }
        return filtered;
    }

    public Item nextPlantPhase() {
        if (this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.PLANT_2) > 0.0) {
            int next = this.settings.indexOf(this.currentPhase);
            while (this.settings.get(next = (next + 1) % this.settings.size()) == this.getSetting()) {
            }
            this.currentPhase = this.settings.get(next);
            return this.currentPhase;
        }
        return this.getSetting();
    }

    private Item getSetting() {
        String setting = this.getSetting(MODE).getValue();
        if (setting.equals(Items.field_222065_kN.func_77658_a())) {
            return Items.field_222065_kN;
        }
        if (setting.equals(Items.field_221774_cw.func_77658_a())) {
            return Items.field_221774_cw;
        }
        if (setting.equals(Items.field_222068_kQ.func_77658_a())) {
            return Items.field_222068_kQ;
        }
        return Items.field_222065_kN;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(BuildingPlantation.PLANTATION).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingPlantation.PLANTATION);
            return isRecipeAllowed.orElse(false);
        }
    }
}

