/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.Optional;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingFletcher
extends AbstractBuilding {
    private static final String FLETCHER = "fletcher";

    public BuildingFletcher(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FLETCHER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(BuildingFletcher.FLETCHER).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingFletcher.FLETCHER);
            if (isRecipeAllowed.isPresent()) {
                return isRecipeAllowed.get();
            }
            Item output = recipe.getPrimaryOutput().func_77973_b();
            return output instanceof ArrowItem || output instanceof DyeableArmorItem && ((DyeableArmorItem)output).func_200880_d() == ArmorMaterial.LEATHER;
        }
    }
}

