/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.FarmerFieldModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingFarmer
extends AbstractBuilding {
    public static final ISettingKey<BoolSetting> FERTILIZE = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "fertilize"));
    private static final String FARMER = "farmer";
    private static final int MAX_BUILDING_LEVEL = 5;

    public BuildingFarmer(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.HOE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public boolean canBeGathered() {
        return true;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        for (FarmerFieldModule module : this.getModules(FarmerFieldModule.class)) {
            for (BlockPos field : module.getFarmerFields()) {
                TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
                if (!(scareCrow instanceof ScarecrowTileEntity) || ItemStackUtils.isEmpty(((ScarecrowTileEntity)scareCrow).getSeed()).booleanValue()) continue;
                ItemStack seedStack = ((ScarecrowTileEntity)scareCrow).getSeed();
                toKeep.put(arg_0 -> ((ItemStack)seedStack).func_77969_a(arg_0), (Tuple<Integer, Boolean>)new Tuple((Object)64, (Object)true));
            }
        }
        return toKeep;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FARMER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public boolean requestFertilizer() {
        return this.getSetting(FERTILIZE).getValue();
    }

    @Override
    public boolean canEat(ItemStack stack) {
        for (FarmerFieldModule module : this.getModules(FarmerFieldModule.class)) {
            for (BlockPos field : module.getFarmerFields()) {
                TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
                if (!(scareCrow instanceof ScarecrowTileEntity) || ItemStackUtils.isEmpty(((ScarecrowTileEntity)scareCrow).getSeed()).booleanValue() || !ItemStackUtils.compareItemStacksIgnoreStackSize(((ScarecrowTileEntity)scareCrow).getSeed(), stack).booleanValue()) continue;
                return false;
            }
        }
        if (stack.func_77973_b() == Items.field_151015_O) {
            return false;
        }
        return super.canEat(stack);
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(BuildingFarmer.FARMER).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingFarmer.FARMER).orElse(false);
        }
    }
}

