/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.MultiOutputRecipe;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BuildingDyer
extends AbstractBuilding {
    private static final String DYER = "dyer";
    private static final String DYER_SMELTING = "dyer_smelting";

    public BuildingDyer(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return DYER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class SmeltingModule
    extends AbstractCraftingBuildingModule.Smelting {
        public SmeltingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(BuildingDyer.DYER_SMELTING).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingDyer.DYER_SMELTING).orElse(false);
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        private List<ItemStorage> woolItems;

        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(BuildingDyer.DYER).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingDyer.DYER).orElse(false);
        }

        @Override
        public IRecipeStorage getFirstRecipe(Predicate<ItemStack> stackPredicate) {
            IRecipeStorage recipe = super.getFirstRecipe(stackPredicate);
            if (recipe == null && stackPredicate.test(new ItemStack((IItemProvider)Items.field_221603_aE))) {
                HashMap<ItemStorage, Integer> inventoryCounts = new HashMap<ItemStorage, Integer>();
                if (!this.building.getColony().getBuildingManager().hasWarehouse()) {
                    return null;
                }
                for (ItemStorage color : this.getWoolItems()) {
                    for (IBuilding iBuilding : this.building.getColony().getBuildingManager().getWareHouses()) {
                        int colorCount = InventoryUtils.getCountFromBuilding(iBuilding, color);
                        inventoryCounts.put(color, inventoryCounts.getOrDefault(color, 0) + colorCount);
                    }
                }
                ItemStorage woolToUse = (ItemStorage)inventoryCounts.entrySet().stream().min(Map.Entry.comparingByValue(Comparator.reverseOrder())).get().getKey();
                IToken<?> token = this.getTokenForWool(woolToUse);
                recipe = IColonyManager.getInstance().getRecipeManager().getRecipe(token);
            }
            return recipe;
        }

        @Override
        public boolean holdsRecipe(IToken<?> token) {
            if (super.holdsRecipe(token)) {
                return true;
            }
            return IColonyManager.getInstance().getRecipeManager().getRecipe(token).getPrimaryOutput().func_77973_b() == Items.field_221603_aE;
        }

        @Override
        public IRecipeStorage getFirstFulfillableRecipe(Predicate<ItemStack> stackPredicate, int count, boolean considerReservation) {
            IRecipeStorage recipe = super.getFirstFulfillableRecipe(stackPredicate, count, considerReservation);
            if (recipe == null && stackPredicate.test(new ItemStack((IItemProvider)Items.field_221603_aE))) {
                HashSet<InventoryCitizen> handlers = new HashSet<InventoryCitizen>();
                for (ICitizenData workerEntity : this.building.getAllAssignedCitizen()) {
                    handlers.add(workerEntity.getInventory());
                }
                for (ItemStorage color : this.getWoolItems()) {
                    IToken<?> token = this.getTokenForWool(color);
                    IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
                    IRecipeStorage toTest = storage.getRecipeType() instanceof MultiOutputRecipe ? storage.getClassicForMultiOutput(stackPredicate) : storage;
                    if (!toTest.canFullFillRecipe(count, considerReservation ? this.reservedStacks() : Collections.emptyMap(), new ArrayList<IItemHandler>(handlers), this.building)) continue;
                    return toTest;
                }
            }
            return recipe;
        }

        private List<ItemStorage> getWoolItems() {
            if (this.woolItems == null) {
                this.woolItems = ItemTags.field_199904_a.func_230236_b_().stream().filter(item -> !item.equals(Items.field_221603_aE)).map(i -> new ItemStorage(new ItemStack((IItemProvider)i))).collect(Collectors.toList());
            }
            return this.woolItems;
        }

        private IToken<?> getTokenForWool(ItemStorage wool) {
            IRecipeStorage tempRecipe = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{ImmutableList.of((Object)wool, (Object)new ItemStorage(new ItemStack((IItemProvider)Items.field_222069_lA, 1))), 1, new ItemStack((IItemProvider)Items.field_221603_aE, 1), Blocks.field_150350_a});
            return IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(tempRecipe);
        }
    }
}

