/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableMap;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.huts.WindowHutCrusherModule;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.crusher.CrusherSetModeMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingCrusher
extends AbstractBuilding {
    private static final double BUILDING_LEVEL_MULTIPLIER = 16.0;
    private static final String CRUSHER_DESC = "crusher";
    private static final int MAX_BUILDING_LEVEL = 5;
    private final Map<ItemStorage, IRecipeStorage> crusherRecipes = new HashMap<ItemStorage, IRecipeStorage>();
    private int dailyQuantity = 0;
    private int currentDailyQuantity = 0;
    private ItemStorage crusherMode = null;
    private boolean oneByOne = false;

    public BuildingCrusher(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        if (this.crusherMode == null || this.crusherMode.isEmpty()) {
            this.loadCrusherMode();
        }
    }

    private void loadCrusherMode() {
        CraftingModule module = this.getFirstModuleOccurance(CraftingModule.class);
        this.crusherRecipes.clear();
        ImmutableMap<IToken<?>, IRecipeStorage> recipes = IColonyManager.getInstance().getRecipeManager().getRecipes();
        for (IToken<?> token : module.getRecipes()) {
            IRecipeStorage storage = (IRecipeStorage)recipes.get(token);
            if (storage == null) continue;
            ItemStorage key = storage.getCleanedInput().get(0);
            if (this.crusherMode == null) {
                this.crusherMode = key;
            }
            this.crusherRecipes.put(key, storage);
        }
    }

    public IRecipeStorage getCurrentRecipe() {
        return this.crusherRecipes.get(this.crusherMode);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CRUSHER_DESC;
    }

    public void setCrusherMode(ItemStorage crusherMode, int dailyQuantity) {
        this.crusherMode = crusherMode;
        this.dailyQuantity = dailyQuantity;
    }

    public Tuple<ItemStorage, Integer> getCrusherMode() {
        return new Tuple((Object)this.crusherMode, (Object)this.dailyQuantity);
    }

    public void setCurrentDailyQuantity(int currentDailyQuantity) {
        this.currentDailyQuantity = currentDailyQuantity;
    }

    public int getMaxDailyQuantity() {
        if (this.getBuildingLevel() >= 5) {
            return Integer.MAX_VALUE;
        }
        return (int)(Math.pow(this.getBuildingLevel(), 2.0) * 16.0);
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.currentDailyQuantity = 0;
    }

    public int getCurrentDailyQuantity() {
        return this.currentDailyQuantity;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.dailyQuantity = compound.func_74762_e("daily");
        this.currentDailyQuantity = compound.func_74762_e("currentDaily");
        if (compound.func_150296_c().contains("Crushermode")) {
            this.crusherMode = new ItemStorage(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Crushermode")));
        }
        this.oneByOne = compound.func_74767_n("Crusherratio");
        this.loadCrusherMode();
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74768_a("daily", this.dailyQuantity);
        compound.func_74768_a("currentDaily", this.currentDailyQuantity);
        if (this.crusherMode != null) {
            CompoundNBT crusherModeNBT = new CompoundNBT();
            this.crusherMode.getItemStack().func_77955_b(crusherModeNBT);
            compound.func_218657_a("Crushermode", (INBT)crusherModeNBT);
        }
        compound.func_74757_a("Crusherratio", this.oneByOne);
        return compound;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        boolean oneOne;
        super.serializeToView(buf);
        boolean bl = oneOne = this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.CRUSHING_11) > 0.0;
        if (this.crusherRecipes.isEmpty() || this.oneByOne != oneOne) {
            this.loadCrusherMode();
        }
        if (this.crusherMode == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.func_150788_a(this.crusherMode.getItemStack());
        }
        buf.writeInt(this.dailyQuantity);
        buf.writeInt(this.crusherRecipes.size());
        for (ItemStorage storage : this.crusherRecipes.keySet()) {
            buf.func_150788_a(storage.getItemStack());
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }
    }

    public static class View
    extends AbstractBuildingView {
        private int dailyQuantity = 0;
        private ItemStorage crusherMode;
        private final List<ItemStorage> crusherModes = new ArrayList<ItemStorage>();

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            if (buf.readBoolean()) {
                this.crusherMode = new ItemStorage(buf.func_150791_c());
            }
            this.dailyQuantity = buf.readInt();
            this.crusherModes.clear();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.crusherModes.add(new ItemStorage(buf.func_150791_c()));
            }
        }

        public void setCrusherMode(ItemStorage crusherMode, int dailyQuantity) {
            this.crusherMode = crusherMode;
            this.dailyQuantity = dailyQuantity;
            Network.getNetwork().sendToServer(new CrusherSetModeMessage(this, crusherMode, dailyQuantity));
        }

        public Tuple<ItemStorage, Integer> getCrusherMode() {
            return new Tuple((Object)this.crusherMode, (Object)this.dailyQuantity);
        }

        public List<ItemStorage> getCrusherModes() {
            return this.crusherModes;
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCrusherModule(this);
        }
    }
}

