/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingConcreteMixer
extends AbstractBuilding {
    private static final String CONCRETE_MIXER = "concretemixer";
    private static final int WATER_DEPTH_SUPPORT = 5;
    private final Map<Integer, List<BlockPos>> waterPos = new HashMap<Integer, List<BlockPos>>();
    private int minWaterLevel = 5;

    public BuildingConcreteMixer(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.PICKAXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        if (!blockState.func_204520_s().func_206888_e() && blockState.func_204520_s().func_206886_c() == Fluids.field_207212_b && blockState.func_204520_s().func_206882_g() <= 5) {
            List fluidPos = this.waterPos.getOrDefault(blockState.func_204520_s().func_206882_g(), new ArrayList());
            if (!fluidPos.contains(pos)) {
                fluidPos.add(pos);
            }
            this.waterPos.put(blockState.func_204520_s().func_206882_g(), fluidPos);
            this.minWaterLevel = Math.min(this.minWaterLevel, blockState.func_204520_s().func_206882_g());
        }
        super.registerBlockPosition(blockState, pos, world);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        @NotNull ListNBT waterMap = new ListNBT();
        for (Map.Entry<Integer, List<BlockPos>> entry : this.waterPos.entrySet()) {
            CompoundNBT waterCompound = new CompoundNBT();
            waterCompound.func_74768_a("level", entry.getKey().intValue());
            @NotNull ListNBT waterList = new ListNBT();
            for (BlockPos pos : entry.getValue()) {
                waterList.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
            }
            waterCompound.func_218657_a("Pond", (INBT)waterList);
            waterMap.add((Object)waterCompound);
        }
        compound.func_218657_a("Pond", (INBT)waterMap);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.waterPos.clear();
        ListNBT waterMapList = compound.func_150295_c("Pond", 10);
        for (int i = 0; i < waterMapList.size(); ++i) {
            CompoundNBT waterCompound = waterMapList.func_150305_b(i);
            int level = waterCompound.func_74762_e("level");
            this.minWaterLevel = Math.min(this.minWaterLevel, level);
            ListNBT waterTagList = waterCompound.func_150295_c("Pond", 10);
            ArrayList<BlockPos> water = new ArrayList<BlockPos>();
            for (int j = 0; j < waterTagList.size(); ++j) {
                CompoundNBT waterSubCompound = waterTagList.func_150305_b(j);
                BlockPos waterPos = NBTUtil.func_186861_c((CompoundNBT)waterSubCompound);
                if (water.contains(waterPos)) continue;
                water.add(waterPos);
            }
            this.waterPos.put(level, water);
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CONCRETE_MIXER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Nullable
    public BlockPos getBlockToMine() {
        for (int i = 1; i <= this.minWaterLevel; ++i) {
            for (BlockPos pos : this.waterPos.getOrDefault(i, Collections.emptyList())) {
                if (!ModTags.concreteBlock.func_230235_a_((Object)this.colony.getWorld().func_180495_p(pos).func_177230_c())) continue;
                return pos;
            }
        }
        return null;
    }

    @Nullable
    public BlockPos getBlockToPlace() {
        for (int i = 1; i <= this.minWaterLevel; ++i) {
            for (BlockPos pos : this.waterPos.getOrDefault(i, Collections.emptyList())) {
                if (this.colony.getWorld().func_180495_p(pos).func_204520_s().func_206888_e() || this.colony.getWorld().func_180495_p(pos).func_185904_a().func_76220_a()) continue;
                return pos;
            }
        }
        return null;
    }

    public int outputBlockCountInWorld(ItemStack primaryOutput) {
        int count = 0;
        if (primaryOutput.func_77973_b() instanceof BlockItem) {
            for (int i = 1; i <= this.minWaterLevel; ++i) {
                for (BlockPos pos : this.waterPos.getOrDefault(i, Collections.emptyList())) {
                    if (((BlockItem)primaryOutput.func_77973_b()).func_179223_d() != this.colony.getWorld().func_180495_p(pos).func_177230_c()) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean canRecipeBeAdded(@NotNull IToken<?> token) {
            return false;
        }
    }
}

