/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingBlacksmith
extends AbstractBuilding {
    private static final String BLACKSMITH = "blacksmith";

    public BuildingBlacksmith(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BLACKSMITH;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(BuildingBlacksmith.BLACKSMITH).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            boolean matchOverride;
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            ItemStack output = recipe.getPrimaryOutput();
            boolean bl = matchOverride = output.func_77973_b() instanceof ToolItem || output.func_77973_b() instanceof SwordItem || output.func_77973_b() instanceof ArmorItem || output.func_77973_b() instanceof HoeItem || output.func_77973_b() instanceof ShieldItem || Compatibility.isTinkersWeapon(output);
            if (matchOverride) {
                return true;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingBlacksmith.BLACKSMITH).orElse(false);
        }
    }
}

