/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.compatibility.CompatibilityManager;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.buildings.modules.settings.StringSetting;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingBeekeeper
extends AbstractBuilding {
    public static final ISettingKey<StringSetting> MODE = new SettingKey<StringSetting>(StringSetting.class, new ResourceLocation("minecolonies", "beekeeper"));
    public static final String HONEYCOMB = "com.minecolonies.core.apiary.setting.honeycomb";
    public static final String HONEY = "com.minecolonies.core.apiary.setting.honey";
    public static final String BOTH = "com.minecolonies.core.apiary.setting.both";
    private static final String BEEKEEPER = "beekeeper";
    private Set<BlockPos> hives = new HashSet<BlockPos>();

    public BuildingBeekeeper(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> Items.field_151097_aZ == stack.func_77973_b(), new Tuple((Object)1, (Object)true));
        this.keepX.put(stack -> Items.field_151069_bo == stack.func_77973_b(), new Tuple((Object)4, (Object)true));
        this.keepX.put(stack -> ItemTags.field_226159_I_.func_230235_a_((Object)stack.func_77973_b()), new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BEEKEEPER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        NBTUtils.streamCompound(compound.func_150295_c("hives", 10)).map(NBTUtil::func_186861_c).forEach(this.hives::add);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_218657_a("hives", (INBT)this.hives.stream().map(NBTUtil::func_186859_a).collect(NBTUtils.toListNBT()));
        return nbt;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
    }

    public Set<BlockPos> getHives() {
        return Collections.unmodifiableSet(new HashSet<BlockPos>(this.hives));
    }

    public void removeHive(BlockPos pos) {
        this.hives.remove(pos);
    }

    public void addHive(BlockPos pos) {
        this.hives.add(pos);
    }

    public String getHarvestTypes() {
        return this.getSetting(MODE).getValue();
    }

    public int getMaximumHives() {
        return (int)Math.pow(2.0, this.getBuildingLevel() - 1);
    }

    public static class HerdingModule
    extends AnimalHerdingModule {
        public HerdingModule() {
            super(ModJobs.beekeeper, EntityType.field_226289_e_, ItemStack.field_190927_a);
        }

        @Override
        @NotNull
        public List<ItemStack> getBreedingItems() {
            if (this.building != null) {
                // empty if block
            }
            return CompatibilityManager.getAllBeekeeperFlowers().stream().map(flower -> new ItemStack((IItemProvider)flower.getItem(), 2)).collect(Collectors.toList());
        }

        @Override
        @NotNull
        public List<LootTableAnalyzer.LootDrop> getExpectedLoot() {
            ArrayList<LootTableAnalyzer.LootDrop> drops = new ArrayList<LootTableAnalyzer.LootDrop>(super.getExpectedLoot());
            drops.add(new LootTableAnalyzer.LootDrop(Collections.singletonList(new ItemStack((IItemProvider)Items.field_226635_pU_, 3)), 1.0f, 0.0f, false));
            drops.add(new LootTableAnalyzer.LootDrop(Collections.singletonList(new ItemStack((IItemProvider)Items.field_226638_pX_)), 1.0f, 0.0f, false));
            return drops;
        }
    }
}

