/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingArchery
extends AbstractBuilding {
    private static final String SCHEMATIC_NAME = "archery";
    private final List<BlockPos> shootingStands = new ArrayList<BlockPos>();
    private final List<BlockPos> shootingTargets = new ArrayList<BlockPos>();

    public BuildingArchery(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block == Blocks.field_235396_nb_) {
            this.shootingTargets.add(pos);
        } else if (block == Blocks.field_150426_aN) {
            this.shootingStands.add(pos);
        }
        super.registerBlockPosition(block, pos, world);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.shootingTargets.clear();
        this.shootingStands.clear();
        ListNBT targetList = compound.func_150295_c("archeryTargets", 10);
        this.shootingTargets.addAll(NBTUtils.streamCompound(targetList).map(targetCompound -> BlockPosUtil.read(targetCompound, "target")).collect(Collectors.toList()));
        ListNBT standTagList = compound.func_150295_c("archeryStands", 10);
        this.shootingStands.addAll(NBTUtils.streamCompound(standTagList).map(targetCompound -> BlockPosUtil.read(targetCompound, "stand")).collect(Collectors.toList()));
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT targetList = this.shootingTargets.stream().map(target -> BlockPosUtil.write(new CompoundNBT(), "target", target)).collect(NBTUtils.toListNBT());
        compound.func_218657_a("archeryTargets", (INBT)targetList);
        ListNBT standTagList = this.shootingStands.stream().map(target -> BlockPosUtil.write(new CompoundNBT(), "stand", target)).collect(NBTUtils.toListNBT());
        compound.func_218657_a("archeryStands", (INBT)standTagList);
        return compound;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    public BlockPos getRandomShootingStandPosition(Random random) {
        if (!this.shootingStands.isEmpty()) {
            return this.shootingStands.get(random.nextInt(this.shootingStands.size()));
        }
        return null;
    }

    public BlockPos getRandomShootingTarget(Random random) {
        if (!this.shootingTargets.isEmpty()) {
            return this.shootingTargets.get(random.nextInt(this.shootingTargets.size()));
        }
        return null;
    }
}

