/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.views;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowHutMinPlaceholder;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.HutRenameMessage;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingView
implements IBuildingView {
    private final IColonyView colony;
    @NotNull
    private final BlockPos location;
    @NotNull
    private BlockPos parent = BlockPos.field_177992_a;
    private int buildingLevel = 0;
    private int buildingMaxLevel = 0;
    private int buildingDmPrio = 1;
    private int rotation;
    private boolean isBuildingMirrored;
    private int workOrderLevel = -1;
    private ImmutableCollection<IToken<?>> resolvers;
    private IToken<?> requesterId;
    private IToken<?> rsDataStoreToken;
    private String schematicName;
    private String style;
    private String customName = "";
    private int claimRadius = 0;
    private List<BlockPos> containerlist = new ArrayList<BlockPos>();
    private boolean isDeconstructed;
    protected List<IBuildingModuleView> moduleViews = new ArrayList<IBuildingModuleView>();
    private BuildingEntry buildingType;

    protected AbstractBuildingView(IColonyView c, @NotNull BlockPos l) {
        this.colony = c;
        this.location = new BlockPos((Vector3i)l);
    }

    @Override
    @NotNull
    public BlockPos getID() {
        return this.location;
    }

    @Override
    @NotNull
    public BlockPos getPosition() {
        return this.location;
    }

    @Override
    @NotNull
    public BlockPos getParent() {
        return this.parent;
    }

    @Override
    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public int getBuildingMaxLevel() {
        return this.buildingMaxLevel;
    }

    @Override
    public boolean isBuildingMaxLevel() {
        return this.buildingLevel >= this.buildingMaxLevel;
    }

    @Override
    public int getCurrentWorkOrderLevel() {
        return this.workOrderLevel;
    }

    @Override
    public String getSchematicName() {
        return this.schematicName;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public boolean isMirrored() {
        return this.isBuildingMirrored;
    }

    @Override
    public boolean hasWorkOrder() {
        return this.workOrderLevel != -1;
    }

    @Override
    public boolean isBuilding() {
        return this.workOrderLevel != 0 && this.workOrderLevel != -1 && this.workOrderLevel > this.buildingLevel;
    }

    @Override
    public boolean isRepairing() {
        return this.workOrderLevel != 0 && this.workOrderLevel != -1 && this.workOrderLevel == this.buildingLevel;
    }

    @Override
    public boolean isDeconstructing() {
        return this.workOrderLevel == 0;
    }

    @Override
    public int getClaimRadius() {
        return this.claimRadius;
    }

    @Override
    public List<BlockPos> getContainerList() {
        return new ArrayList<BlockPos>(this.containerlist);
    }

    @Override
    public void openGui(boolean shouldOpenInv) {
        if (shouldOpenInv) {
            Network.getNetwork().sendToServer(new OpenInventoryMessage(this));
        } else {
            @Nullable Window window = this.getWindow();
            if (window != null) {
                window.open();
            }
        }
    }

    @Override
    @Nullable
    public Window getWindow() {
        if (!this.getModuleViews(WorkerBuildingModuleView.class).isEmpty()) {
            return new WindowHutWorkerModulePlaceholder<AbstractBuildingView>(this, this.getCustomName());
        }
        return new WindowHutMinPlaceholder<AbstractBuildingView>(this);
    }

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        this.buildingLevel = buf.readInt();
        this.buildingMaxLevel = buf.readInt();
        this.buildingDmPrio = buf.readInt();
        this.workOrderLevel = buf.readInt();
        this.style = buf.func_150789_c(Short.MAX_VALUE);
        this.schematicName = buf.func_150789_c(Short.MAX_VALUE);
        this.parent = buf.func_179259_c();
        this.customName = buf.func_150789_c(Short.MAX_VALUE);
        this.rotation = buf.readInt();
        this.isBuildingMirrored = buf.readBoolean();
        this.claimRadius = buf.readInt();
        ArrayList list = new ArrayList();
        int resolverSize = buf.readInt();
        for (int i = 0; i < resolverSize; ++i) {
            CompoundNBT compound = buf.func_150793_b();
            if (compound == null) continue;
            list.add(StandardFactoryController.getInstance().deserialize(compound));
        }
        this.resolvers = ImmutableList.copyOf(list);
        CompoundNBT compound = buf.func_150793_b();
        if (compound != null) {
            this.requesterId = (IToken)StandardFactoryController.getInstance().deserialize(compound);
        }
        this.containerlist.clear();
        int racks = buf.readInt();
        for (int i = 0; i < racks; ++i) {
            this.containerlist.add(buf.func_179259_c());
        }
        this.loadRequestSystemFromNBT(buf.func_150793_b());
        this.isDeconstructed = buf.readBoolean();
        for (IBuildingModuleView module : this.moduleViews) {
            module.deserialize(buf);
        }
    }

    private void loadRequestSystemFromNBT(CompoundNBT compound) {
        this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("DataStoreToken"));
    }

    private IRequestSystemBuildingDataStore getDataStore() {
        return this.colony.getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE);
    }

    @Override
    public Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.getDataStore().getOpenRequestsByCitizen();
    }

    protected Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.getDataStore().getCitizensByRequest();
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(@NotNull ICitizenDataView citizenData, Class<R> requestType) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf((Type)requestType)).map(request -> request).iterator());
    }

    @Override
    public ImmutableList<IRequest<?>> getOpenRequests(@NotNull ICitizenDataView data) {
        if (data == null || this.getColony() == null || this.getColony().getRequestManager() == null) {
            return ImmutableList.of();
        }
        if (!this.getOpenRequestsByCitizen().containsKey(data.getId())) {
            return ImmutableList.of();
        }
        Collection<IToken<?>> list = this.getOpenRequestsByCitizen().get(data.getId());
        if (list == null || list.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(list.stream().filter(Objects::nonNull).map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    @Override
    public ImmutableList<IRequest<?>> getOpenRequestsOfBuilding() {
        return ImmutableList.copyOf(this.getOpenRequestsByCitizen().values().stream().flatMap(Collection::stream).filter(Objects::nonNull).map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    @Override
    public IColonyView getColony() {
        return this.colony;
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull ICitizenDataView citizenData, Class<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf((Type)requestType)).map(request -> request).filter(filter).iterator());
    }

    @Override
    public IToken<?> getId() {
        return this.requesterId;
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        Integer citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(request.getId());
        if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
            this.getOpenRequestsByCitizen().remove(citizenThatRequested);
        }
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        if (this.getOpenRequestsOfBuilding().contains(request)) {
            Integer citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
            this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(request.getId());
            if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
                this.getOpenRequestsByCitizen().remove(citizenThatRequested);
            }
        }
    }

    @Override
    @NotNull
    public IFormattableTextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        try {
            StringTextComponent component = new StringTextComponent("");
            component.func_230529_a_((ITextComponent)new TranslationTextComponent(this.getCustomName().isEmpty() ? this.getSchematicName() : this.getCustomName()));
            if (this.getColony() == null || !this.getCitizensByRequest().containsKey(request.getId())) {
                return component;
            }
            int citizenId = this.getCitizensByRequest().get(request.getId());
            if (citizenId == -1 || this.getColony().getCitizen(citizenId) == null) {
                return component;
            }
            component.func_230529_a_((ITextComponent)new StringTextComponent(": "));
            component.func_230529_a_((ITextComponent)new StringTextComponent(this.getColony().getCitizen(this.getCitizensByRequest().get(request.getId())).getName()));
            return component;
        }
        catch (Exception ex) {
            Log.getLogger().warn((Object)ex);
            return new StringTextComponent("");
        }
    }

    @Override
    @NotNull
    public ILocation getLocation() {
        return null;
    }

    @Override
    public int getBuildingDmPrio() {
        return this.buildingDmPrio;
    }

    @Override
    public ImmutableCollection<IToken<?>> getResolverIds() {
        return this.resolvers;
    }

    @Override
    public void setCustomName(String name) {
        this.customName = name;
        Network.getNetwork().sendToServer(new HutRenameMessage(this, name));
    }

    @Override
    public boolean isDeconstructed() {
        return this.isDeconstructed;
    }

    @Override
    @NotNull
    public <T extends IBuildingModuleView> T getModuleView(Class<T> clazz) {
        for (IBuildingModuleView view : this.moduleViews) {
            if (!clazz.isInstance(view)) continue;
            return (T)view;
        }
        return null;
    }

    @Override
    @NotNull
    public <T extends IBuildingModuleView> T getModuleViewMatching(Class<T> clazz, Predicate<? super T> modulePredicate) {
        for (IBuildingModuleView module : this.moduleViews) {
            if (!clazz.isInstance(module) || !modulePredicate.test(clazz.cast(module))) continue;
            return (T)module;
        }
        return null;
    }

    @Override
    @NotNull
    public <T extends IBuildingModuleView> List<T> getModuleViews(Class<T> clazz) {
        return this.moduleViews.stream().filter(clazz::isInstance).map(c -> c).collect(Collectors.toList());
    }

    @Override
    public void registerModule(IBuildingModuleView iModuleView) {
        iModuleView.setBuildingView(this);
        this.moduleViews.add(iModuleView);
    }

    @Override
    public List<IBuildingModuleView> getAllModuleViews() {
        return this.moduleViews;
    }

    @Override
    public final BuildingEntry getBuildingType() {
        return this.buildingType;
    }

    @Override
    public void setBuildingType(BuildingEntry buildingType) {
        this.buildingType = buildingType;
    }

    @Override
    public Set<Integer> getAllAssignedCitizens() {
        HashSet<Integer> assignees = new HashSet<Integer>();
        for (WorkerBuildingModuleView view : this.getModuleViews(WorkerBuildingModuleView.class)) {
            assignees.addAll(view.getAssignedCitizens());
        }
        return assignees;
    }
}

