/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.modules.settings.IBlockSettingFactory;
import com.minecolonies.api.colony.buildings.modules.settings.IBoolSettingFactory;
import com.minecolonies.api.colony.buildings.modules.settings.IIntSettingFactory;
import com.minecolonies.api.colony.buildings.modules.settings.IStringSetting;
import com.minecolonies.api.colony.buildings.modules.settings.IStringSettingFactory;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.modules.settings.BlockSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.BuilderModeSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.CrafterRecipeSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.DynamicTreesSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.FollowModeSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.GuardTaskSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.IntSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.PatrolModeSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.PlantationSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.StringSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.StringSettingWithDesc;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SettingsFactories {

    public static class DynamicTreesSettingFactory
    extends AbstractIntSettingFactory<DynamicTreesSetting> {
        @Override
        @NotNull
        public DynamicTreesSetting getNewInstance(int def, int current) {
            return new DynamicTreesSetting(def, current);
        }

        @Override
        @NotNull
        public TypeToken<DynamicTreesSetting> getFactoryOutputType() {
            return TypeToken.of(DynamicTreesSetting.class);
        }

        @Override
        public short getSerializationId() {
            return 57;
        }
    }

    public static class BuilderModeSettingFactory
    extends AbstractStringSettingsFactory<BuilderModeSetting> {
        @Override
        @NotNull
        public TypeToken<BuilderModeSetting> getFactoryOutputType() {
            return TypeToken.of(BuilderModeSetting.class);
        }

        @Override
        @NotNull
        public BuilderModeSetting getNewInstance(List<String> value, int curr) {
            return new BuilderModeSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 56;
        }
    }

    public static class CrafterRecipeSettingFactory
    extends AbstractStringSettingsFactory<CrafterRecipeSetting> {
        @Override
        @NotNull
        public TypeToken<CrafterRecipeSetting> getFactoryOutputType() {
            return TypeToken.of(CrafterRecipeSetting.class);
        }

        @Override
        @NotNull
        public CrafterRecipeSetting getNewInstance(List<String> value, int curr) {
            return new CrafterRecipeSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 55;
        }
    }

    public static class FollowModeSettingFactory
    extends AbstractStringSettingsFactory<FollowModeSetting> {
        @Override
        @NotNull
        public TypeToken<FollowModeSetting> getFactoryOutputType() {
            return TypeToken.of(FollowModeSetting.class);
        }

        @Override
        @NotNull
        public FollowModeSetting getNewInstance(List<String> value, int curr) {
            return new FollowModeSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 53;
        }
    }

    public static class GuardTaskSettingFactory
    extends AbstractStringSettingsFactory<GuardTaskSetting> {
        @Override
        @NotNull
        public TypeToken<GuardTaskSetting> getFactoryOutputType() {
            return TypeToken.of(GuardTaskSetting.class);
        }

        @Override
        @NotNull
        public GuardTaskSetting getNewInstance(List<String> value, int curr) {
            return new GuardTaskSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 52;
        }
    }

    public static class PatrolModeSettingFactory
    extends AbstractStringSettingsFactory<PatrolModeSetting> {
        @Override
        @NotNull
        public TypeToken<PatrolModeSetting> getFactoryOutputType() {
            return TypeToken.of(PatrolModeSetting.class);
        }

        @Override
        @NotNull
        public PatrolModeSetting getNewInstance(List<String> value, int curr) {
            return new PatrolModeSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 51;
        }
    }

    public static class StringWithDescSettingsFactory
    extends AbstractStringSettingsFactory<StringSettingWithDesc> {
        @Override
        @NotNull
        public TypeToken<StringSettingWithDesc> getFactoryOutputType() {
            return TypeToken.of(StringSettingWithDesc.class);
        }

        @Override
        @NotNull
        public StringSettingWithDesc getNewInstance(List<String> value, int curr) {
            return new StringSettingWithDesc(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 50;
        }
    }

    public static class PlantationSettingsFactory
    extends AbstractStringSettingsFactory<PlantationSetting> {
        @Override
        @NotNull
        public TypeToken<PlantationSetting> getFactoryOutputType() {
            return TypeToken.of(PlantationSetting.class);
        }

        @Override
        @NotNull
        public PlantationSetting getNewInstance(List<String> value, int curr) {
            return new PlantationSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 49;
        }
    }

    public static class IntSettingFactory
    extends AbstractIntSettingFactory<IntSetting> {
        @Override
        @NotNull
        public TypeToken<IntSetting> getFactoryOutputType() {
            return TypeToken.of(IntSetting.class);
        }

        @Override
        @NotNull
        public IntSetting getNewInstance(int value, int def) {
            return new IntSetting(value, def);
        }

        @Override
        public short getSerializationId() {
            return 48;
        }
    }

    public static abstract class AbstractIntSettingFactory<T extends IntSetting>
    implements IIntSettingFactory<T> {
        private static final String TAG_VALUE = "value";
        private static final String TAG_DEFAULT = "default";

        @Override
        @NotNull
        public TypeToken<FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull IntSetting storage) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a(TAG_VALUE, storage.getValue());
            compound.func_74768_a(TAG_DEFAULT, storage.getDefault());
            return compound;
        }

        @Override
        @NotNull
        public T deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            return (T)((IntSetting)this.getNewInstance(nbt.func_74762_e(TAG_VALUE), nbt.func_74762_e(TAG_DEFAULT)));
        }

        @Override
        public void serialize(@NotNull IFactoryController controller, @NotNull IntSetting input, @NotNull PacketBuffer packetBuffer) {
            packetBuffer.writeInt(input.getValue());
            packetBuffer.writeInt(input.getDefault());
        }

        @Override
        @NotNull
        public T deserialize(@NotNull IFactoryController controller, @NotNull PacketBuffer buffer) throws Throwable {
            return (T)((IntSetting)this.getNewInstance(buffer.readInt(), buffer.readInt()));
        }
    }

    public static class BlockSettingFactory
    implements IBlockSettingFactory<BlockSetting> {
        private static final String TAG_VALUE = "value";
        private static final String TAG_DEF = "default";

        @Override
        @NotNull
        public TypeToken<BlockSetting> getFactoryOutputType() {
            return TypeToken.of(BlockSetting.class);
        }

        @Override
        @NotNull
        public TypeToken<FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public BlockSetting getNewInstance(BlockItem value, BlockItem def) {
            return new BlockSetting(value, def);
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull BlockSetting storage) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a(TAG_VALUE, storage.getValue().getRegistryName().toString());
            compound.func_74778_a(TAG_DEF, storage.getDefault().getRegistryName().toString());
            return compound;
        }

        @Override
        @NotNull
        public BlockSetting deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            BlockItem value = (BlockItem)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i(TAG_VALUE)));
            BlockItem def = (BlockItem)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i(TAG_DEF)));
            return this.getNewInstance(value, def);
        }

        @Override
        public void serialize(@NotNull IFactoryController controller, @NotNull BlockSetting input, @NotNull PacketBuffer packetBuffer) {
            packetBuffer.func_150788_a(new ItemStack((IItemProvider)input.getValue()));
            packetBuffer.func_150788_a(new ItemStack((IItemProvider)input.getDefault()));
        }

        @Override
        @NotNull
        public BlockSetting deserialize(@NotNull IFactoryController controller, @NotNull PacketBuffer buffer) throws Throwable {
            BlockItem value = (BlockItem)buffer.func_150791_c().func_77973_b();
            BlockItem def = (BlockItem)buffer.func_150791_c().func_77973_b();
            return this.getNewInstance(value, def);
        }

        @Override
        public short getSerializationId() {
            return 47;
        }
    }

    public static class StringSettingsFactory
    extends AbstractStringSettingsFactory<StringSetting> {
        @Override
        @NotNull
        public TypeToken<StringSetting> getFactoryOutputType() {
            return TypeToken.of(StringSetting.class);
        }

        @Override
        @NotNull
        public StringSetting getNewInstance(List<String> value, int curr) {
            return new StringSetting(value, curr);
        }

        @Override
        public short getSerializationId() {
            return 46;
        }
    }

    public static abstract class AbstractStringSettingsFactory<T extends IStringSetting>
    implements IStringSettingFactory<T> {
        private static final String TAG_VALUE = "value";
        private static final String TAG_LIST = "settings";

        @Override
        @NotNull
        public TypeToken<FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull IStringSetting storage) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a(TAG_VALUE, storage.getCurrentIndex());
            ListNBT list = new ListNBT();
            for (String setting : storage.getSettings()) {
                CompoundNBT compoundNBT = new CompoundNBT();
                compoundNBT.func_74778_a(TAG_VALUE, setting);
                list.add((Object)compoundNBT);
            }
            compound.func_218657_a(TAG_LIST, (INBT)list);
            return compound;
        }

        @Override
        @NotNull
        public T deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            int current = nbt.func_74762_e(TAG_VALUE);
            ArrayList<String> settings = new ArrayList<String>();
            ListNBT list = nbt.func_150295_c(TAG_LIST, 10);
            for (int i = 0; i < list.size(); ++i) {
                settings.add(list.func_150305_b(i).func_74779_i(TAG_VALUE));
            }
            return (T)((IStringSetting)this.getNewInstance(settings, current));
        }

        @Override
        public void serialize(@NotNull IFactoryController controller, @NotNull IStringSetting input, @NotNull PacketBuffer packetBuffer) {
            packetBuffer.writeInt(input.getCurrentIndex());
            packetBuffer.writeInt(input.getSettings().size());
            for (String setting : input.getSettings()) {
                packetBuffer.func_180714_a(setting);
            }
        }

        @Override
        @NotNull
        public T deserialize(@NotNull IFactoryController controller, @NotNull PacketBuffer buffer) throws Throwable {
            int currentIndex = buffer.readInt();
            int size = buffer.readInt();
            ArrayList<String> settings = new ArrayList<String>();
            for (int i = 0; i < size; ++i) {
                settings.add(buffer.func_150789_c(Short.MAX_VALUE));
            }
            return (T)((IStringSetting)this.getNewInstance(settings, currentIndex));
        }
    }

    public static class BoolSettingFactory
    extends AbstractBoolSettingFactory<BoolSetting> {
        @Override
        @NotNull
        public TypeToken<BoolSetting> getFactoryOutputType() {
            return TypeToken.of(BoolSetting.class);
        }

        @Override
        @NotNull
        public BoolSetting getNewInstance(boolean value, boolean def) {
            return new BoolSetting(value, def);
        }

        @Override
        public short getSerializationId() {
            return 43;
        }
    }

    public static abstract class AbstractBoolSettingFactory<T extends BoolSetting>
    implements IBoolSettingFactory<T> {
        private static final String TAG_VALUE = "value";
        private static final String TAG_DEFAULT = "default";

        @Override
        @NotNull
        public TypeToken<FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public T deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            return (T)((BoolSetting)this.getNewInstance(nbt.func_74767_n(TAG_VALUE), nbt.func_74767_n(TAG_DEFAULT)));
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull T storage) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74757_a(TAG_VALUE, ((BoolSetting)storage).getValue());
            compound.func_74757_a(TAG_DEFAULT, ((BoolSetting)storage).getDefault());
            return compound;
        }

        @Override
        public void serialize(@NotNull IFactoryController controller, @NotNull T input, @NotNull PacketBuffer packetBuffer) {
            packetBuffer.writeBoolean(((BoolSetting)input).getValue());
            packetBuffer.writeBoolean(((BoolSetting)input).getDefault());
        }

        @Override
        @NotNull
        public T deserialize(@NotNull IFactoryController controller, @NotNull PacketBuffer buffer) throws Throwable {
            return (T)((BoolSetting)this.getNewInstance(buffer.readBoolean(), buffer.readBoolean()));
        }
    }
}

