/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.View;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.coremod.colony.buildings.modules.settings.StringSetting;
import java.util.List;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlantationSetting
extends StringSetting {
    private boolean hasResearch;

    public PlantationSetting(String ... settings) {
        super(settings);
    }

    public PlantationSetting(List<String> settings, int currentIndex) {
        super(settings, currentIndex);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        this.hasResearch = building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.PLANT_2) > 0.0;
        Loader.createFromXMLFile((String)"minecolonies:gui/layouthuts/layoutstringsetting.xml", (View)((View)pane));
        ((Text)pane.findPaneOfTypeByID("id", Text.class)).setText(key.getUniqueId().toString());
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> settingsModuleView.trigger(key));
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        if (this.hasResearch) {
            ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setText(this.getCombinedSetting());
        } else {
            ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setText((IFormattableTextComponent)new TranslationTextComponent(this.getSettings().get(this.getCurrentIndex())));
        }
    }

    private IFormattableTextComponent getCombinedSetting() {
        TranslationTextComponent component = new TranslationTextComponent("");
        for (int i = 0; i < this.getSettings().size(); ++i) {
            if (i == this.getCurrentIndex()) continue;
            if (!component.func_150253_a().isEmpty()) {
                component.func_230529_a_((ITextComponent)new StringTextComponent(" & "));
            }
            component.func_230529_a_((ITextComponent)new TranslationTextComponent(this.getSettings().get(i)));
        }
        return component;
    }
}

