/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.View;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.client.gui.WindowSelectRes;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSetting
implements ISetting {
    private BlockItem value;
    private BlockItem defaultValue;

    public BlockSetting(BlockItem init) {
        this.value = init;
        this.defaultValue = init;
    }

    public BlockSetting(BlockItem value, BlockItem def) {
        this.value = value;
        this.defaultValue = def;
    }

    public BlockItem getValue() {
        return this.value;
    }

    public BlockItem getDefault() {
        return this.defaultValue;
    }

    public void setValue(BlockItem value) {
        this.value = value;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        Loader.createFromXMLFile((String)"minecolonies:gui/layouthuts/layoutblocksetting.xml", (View)((View)pane));
        ((Text)pane.findPaneOfTypeByID("id", Text.class)).setText(key.getUniqueId().toString());
        ((Text)pane.findPaneOfTypeByID("desc", Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.setting." + key.getUniqueId().toString()));
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> new WindowSelectRes(window, building, stack -> {
            BlockState state;
            Item item = stack.func_77973_b();
            if (!(item instanceof BlockItem)) {
                return false;
            }
            Block block = ((BlockItem)item).func_179223_d();
            if (block.hasTileEntity(state = block.func_176223_P()) || block instanceof FallingBlock) {
                return false;
            }
            return block.func_220053_a(state, (IBlockReader)new SingleStateBlockGetter(state), BlockPos.field_177992_a, ISelectionContext.func_216377_a()).equals(VoxelShapes.func_197868_b()) && state.func_185904_a().func_76230_c();
        }, (stack, qty) -> {
            this.value = (BlockItem)stack.func_77973_b();
            settingsModuleView.trigger(key);
        }, false).open());
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        ((ItemIcon)pane.findPaneOfTypeByID("icon", ItemIcon.class)).setItem(new ItemStack((IItemProvider)this.value));
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.switch"));
    }

    @Override
    public void trigger() {
    }

    public class SingleStateBlockGetter
    implements IBlockReader {
        private final BlockState state;

        public SingleStateBlockGetter(BlockState state) {
            this.state = state;
        }

        @Nullable
        public TileEntity func_175625_s(@NotNull BlockPos pos) {
            return null;
        }

        @NotNull
        public BlockState func_180495_p(@NotNull BlockPos pos) {
            if (pos == BlockPos.field_177992_a) {
                return this.state;
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        @NotNull
        public FluidState func_204610_c(@NotNull BlockPos pos) {
            return Fluids.field_204541_a.func_207188_f();
        }
    }
}

