/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorkerModule;
import com.minecolonies.api.colony.buildings.modules.IAssignsJob;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingRequestResolver;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class WorkerBuildingModule
extends AbstractAssignedCitizenModule
implements IAssignsJob,
IBuildingEventsModule,
ITickingModule,
IPersistentModule,
IBuildingWorkerModule,
ICreatesResolversModule {
    private final Skill primary;
    private final Skill secondary;
    private final JobEntry jobEntry;
    private final boolean canWorkingDuringRain;
    private final Function<IBuilding, Integer> sizeLimit;

    public WorkerBuildingModule(JobEntry entry, Skill primary, Skill secondary, boolean canWorkingDuringRain, Function<IBuilding, Integer> sizeLimit) {
        this.jobEntry = entry;
        this.primary = primary;
        this.secondary = secondary;
        this.canWorkingDuringRain = canWorkingDuringRain;
        this.sizeLimit = sizeLimit;
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (citizen.getWorkBuilding() != null) {
            for (WorkerBuildingModule module : citizen.getWorkBuilding().getModules(WorkerBuildingModule.class)) {
                if (!module.hasAssignedCitizen(citizen)) continue;
                module.removeCitizen(citizen);
            }
        }
        if (!super.assignCitizen(citizen)) {
            Log.getLogger().warn("Unable to assign citizen:" + citizen.getName() + " to building:" + this.building.getSchematicName() + " jobname:" + this.getJobDisplayName());
            return false;
        }
        return true;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        block3: {
            int[] residentIds;
            block2: {
                super.deserializeNBT(compound);
                if (!compound.func_150296_c().contains("worker")) break block2;
                ListNBT workersTagList = compound.func_150295_c("worker", 10);
                for (int i = 0; i < workersTagList.size(); ++i) {
                    ICitizenData data = this.building.getColony().getCitizenManager().getCivilian(workersTagList.func_150305_b(i).func_74762_e("workerId"));
                    if (data == null || data.getJob() == null || data.getJob().getJobRegistryEntry() != this.jobEntry) continue;
                    this.assignCitizen(data);
                }
                break block3;
            }
            if (!compound.func_74764_b(this.jobEntry.getKey().toString())) break block3;
            CompoundNBT jobCompound = compound.func_74775_l(this.jobEntry.getKey().toString());
            for (int citizenId : residentIds = jobCompound.func_74759_k("residents")) {
                ICitizenData citizen = this.building.getColony().getCitizenManager().getCivilian(citizenId);
                if (citizen == null) continue;
                this.assignCitizen(citizen);
            }
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        ICitizenData joblessCitizen;
        if (!this.isFull() && (this.building.getBuildingLevel() > 0 && this.building.isBuilt() || this.building instanceof BuildingBuilder) && (this.getHiringMode() == HiringMode.DEFAULT && !this.building.getColony().isManualHiring() || this.getHiringMode() == HiringMode.AUTO) && (joblessCitizen = colony.getCitizenManager().getJoblessCitizen()) != null) {
            this.assignCitizen(joblessCitizen);
        }
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        super.serializeNBT(compound);
        CompoundNBT jobCompound = new CompoundNBT();
        if (!this.assignedCitizen.isEmpty()) {
            int[] residentIds = new int[this.assignedCitizen.size()];
            for (int i = 0; i < this.assignedCitizen.size(); ++i) {
                residentIds[i] = ((ICitizenData)this.assignedCitizen.get(i)).getId();
            }
            jobCompound.func_74783_a("residents", residentIds);
        }
        compound.func_218657_a(this.jobEntry.getKey().toString(), (INBT)jobCompound);
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeRegistryId((IForgeRegistryEntry)this.jobEntry);
        buf.writeInt(this.getModuleMax());
        buf.writeInt(this.getPrimarySkill().ordinal());
        buf.writeInt(this.getSecondarySkill().ordinal());
    }

    @Override
    void onAssignment(ICitizenData citizen) {
        citizen.setWorkBuilding(this.building);
        for (AbstractCraftingBuildingModule module : this.building.getModules(AbstractCraftingBuildingModule.class)) {
            module.updateWorkerAvailableForRecipes();
        }
        citizen.getJob().onLevelUp();
        this.building.getColony().getProgressManager().progressEmploy((int)this.building.getColony().getCitizenManager().getCitizens().stream().filter(citizenData -> citizenData.getJob() != null).count());
    }

    @Override
    void onRemoval(ICitizenData citizen) {
        citizen.setWorkBuilding(null);
        this.building.cancelAllRequestsOfCitizen(citizen);
        citizen.setVisibleStatus(null);
    }

    @Override
    public int getModuleMax() {
        return this.sizeLimit.apply(this.building);
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        for (Optional<AbstractEntityCitizen> entityCitizen : Objects.requireNonNull(this.getAssignedEntities())) {
            if (!entityCitizen.isPresent() || entityCitizen.get().getCitizenJobHandler().getColonyJob() != null) continue;
            entityCitizen.get().getCitizenJobHandler().setModelDependingOnJob(null);
        }
        this.building.getColony().getCitizenManager().calculateMaxCitizens();
    }

    public String getJobDisplayName() {
        return new TranslationTextComponent(this.jobEntry.getTranslationKey()).getString();
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return this.jobEntry.produceJob(citizen);
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return this.building.getBuildingLevel() >= this.building.getMaxBuildingLevel() || this.canWorkingDuringRain;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return this.primary;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return this.secondary;
    }

    @Override
    public List<IRequestResolver<?>> createResolvers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new IRequestResolver[]{new BuildingRequestResolver(this.building.getRequester().getLocation(), this.building.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)), new PrivateWorkerCraftingRequestResolver(this.building.getRequester().getLocation(), this.building.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN), this.jobEntry), new PrivateWorkerCraftingProductionResolver(this.building.getRequester().getLocation(), this.building.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN), this.jobEntry)});
        return builder.build();
    }

    @Override
    public JobEntry getJobEntry() {
        return this.jobEntry;
    }
}

