/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class SettingsModule
extends AbstractBuildingModule
implements IPersistentModule,
ISettingsModule {
    final Map<ISettingKey<?>, ISetting> settings = new LinkedHashMap();

    @Override
    public <T extends ISetting> T getSetting(ISettingKey<T> key) {
        return (T)((ISetting)this.settings.getOrDefault(key, null));
    }

    @Override
    public ISettingsModule with(ISettingKey<?> key, ISetting setting) {
        this.settings.put(key, setting);
        return this;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        CompoundNBT settingsCompound = compound.func_74775_l("settings");
        ListNBT list = settingsCompound.func_150295_c("settingslist", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT entryCompound = list.func_150305_b(i);
            ResourceLocation key = new ResourceLocation(entryCompound.func_74779_i("key"));
            try {
                ISetting setting = (ISetting)StandardFactoryController.getInstance().deserialize(entryCompound.func_74775_l("value"));
                SettingKey settingsKey = new SettingKey(setting.getClass(), key);
                if (!this.settings.containsKey(settingsKey)) continue;
                this.settings.put(settingsKey, setting);
                continue;
            }
            catch (IllegalArgumentException ex) {
                Log.getLogger().warn("Detected Removed Setting");
            }
        }
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        CompoundNBT settingsCompound = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (Map.Entry<ISettingKey<?>, ISetting> setting : this.settings.entrySet()) {
            CompoundNBT entryCompound = new CompoundNBT();
            entryCompound.func_74778_a("key", setting.getKey().getUniqueId().toString());
            entryCompound.func_218657_a("value", (INBT)StandardFactoryController.getInstance().serialize(setting.getValue()));
            list.add((Object)entryCompound);
        }
        settingsCompound.func_218657_a("settingslist", (INBT)list);
        compound.func_218657_a("settings", (INBT)settingsCompound);
    }

    @Override
    public void serializeToView(PacketBuffer buf) {
        buf.writeInt(this.settings.size());
        for (Map.Entry<ISettingKey<?>, ISetting> setting : this.settings.entrySet()) {
            buf.func_192572_a(setting.getKey().getUniqueId());
            StandardFactoryController.getInstance().serialize(buf, setting.getValue());
        }
    }

    @Override
    public void updateSetting(ISettingKey<?> settingKey, ISetting value, ServerPlayerEntity sender) {
        if (this.settings.containsKey(settingKey)) {
            this.settings.put(settingKey, value);
            value.onUpdate(this.building, sender);
        }
    }
}

