/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.modules.IAssignsJob;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.coremod.colony.jobs.JobQuarrier;
import com.minecolonies.coremod.colony.requestsystem.resolvers.StationRequestResolver;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.jetbrains.annotations.NotNull;

public class QuarryModule
extends AbstractAssignedCitizenModule
implements IAssignsJob,
IBuildingEventsModule,
ITickingModule,
IPersistentModule,
ICreatesResolversModule {
    private boolean isFinished = false;

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (!this.isFull() && (this.getHiringMode() == HiringMode.DEFAULT && !this.building.getColony().isManualHiring() || this.getHiringMode() == HiringMode.AUTO)) {
            for (ICitizenData data : colony.getCitizenManager().getCitizens()) {
                if (!(data.getJob() instanceof JobQuarrier) || this.hasAssignedCitizen(data) || ((JobQuarrier)data.getJob()).findQuarry() != null) continue;
                this.assignCitizen(data);
            }
        }
        for (ICitizenData citizenData : new ArrayList<ICitizenData>(this.getAssignedCitizen())) {
            if (citizenData.getJob() instanceof JobQuarrier) continue;
            this.removeCitizen(citizenData);
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        int[] residentIds;
        super.deserializeNBT(compound);
        CompoundNBT quarryCompound = compound.func_74775_l("quarryassignment");
        for (int citizenId : residentIds = quarryCompound.func_74759_k("miners")) {
            ICitizenData citizen = this.building.getColony().getCitizenManager().getCivilian(citizenId);
            if (citizen == null) continue;
            this.assignCitizen(citizen);
        }
        this.isFinished = quarryCompound.func_74767_n("isfinished");
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        super.serializeNBT(compound);
        CompoundNBT quarrycompound = new CompoundNBT();
        if (!this.assignedCitizen.isEmpty()) {
            int[] residentIds = new int[this.assignedCitizen.size()];
            for (int i = 0; i < this.assignedCitizen.size(); ++i) {
                residentIds[i] = ((ICitizenData)this.assignedCitizen.get(i)).getId();
            }
            quarrycompound.func_74783_a("miners", residentIds);
        }
        compound.func_218657_a("quarryassignment", (INBT)quarrycompound);
        quarrycompound.func_74757_a("isfinished", this.isFinished);
    }

    @Override
    public void onRemoval(ICitizenData citizen) {
    }

    @Override
    public void onAssignment(ICitizenData citizen) {
    }

    @Override
    public int getModuleMax() {
        return 1;
    }

    @Override
    public JobEntry getJobEntry() {
        return ModJobs.quarrier;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setFinished() {
        this.isFinished = true;
        this.markDirty();
    }

    @Override
    public List<IRequestResolver<?>> createResolvers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new StationRequestResolver(this.building.getRequester().getLocation(), this.building.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }
}

